package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.entity.QSysUserTerminalDO;
import com.elitescloud.cloudt.system.model.entity.SysUserTerminalDO;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/28
 */
@Repository
public class SysUserTerminalRepoProc extends BaseRepoProc<SysUserTerminalDO> {
    private static final QSysUserTerminalDO QDO = QSysUserTerminalDO.sysUserTerminalDO;

    public SysUserTerminalRepoProc() {
        super(QDO);
    }

    /**
     * 根据ID批量删除记录
     *
     * @param ids ids
     */
    public void deleteById(List<Long> ids) {
        jpaQueryFactory.delete(QDO)
                .where(QDO.id.in(ids))
                .execute();
    }

    /**
     * 根据用户ID删除
     *
     * @param userId
     */
    public void deleteByUserId(Long userId) {
        super.deleteByValue(QDO.userId, userId);
    }

    /**
     * 删除
     *
     * @param userId
     * @param terminals
     */
    public void delete(Long userId, Collection<String> terminals) {
        super.jpaQueryFactory.delete(QDO)
                .where(QDO.userId.eq(userId).and(QDO.terminalCode.in(terminals)))
                .execute();
    }

    /**
     * 获取用户关联的终端
     *
     * @param userId 用户ID
     * @return 终端
     */
    public List<String> getTerminalStrByUserId(Long userId) {
        return jpaQueryFactory.select(QDO.terminalCode)
                .from(QDO)
                .where(QDO.userId.eq(userId))
                .fetch();

    }

    /**
     * 获取用户关联的终端
     *
     * @param userId 用户ID
     * @return 终端
     */
    public List<Terminal> getTerminalByUserId(Long userId) {
        return jpaQueryFactory.select(QDO.terminalCode)
                .from(QDO)
                .where(QDO.userId.eq(userId))
                .fetch()
                .stream()
                .map(Terminal::valueOf)
                .collect(Collectors.toList());

    }

    /**
     * 获取用户关联的终端
     *
     * @param userIds 用户ID
     * @return 终端
     */
    public Map<Long, List<Terminal>> getTerminalByUserId(List<Long> userIds) {
        return jpaQueryFactory.select(QDO.userId, QDO.terminalCode)
                .from(QDO)
                .where(QDO.userId.in(userIds))
                .fetch()
                .stream()
                .collect(Collectors.groupingBy(tuple -> tuple.get(QDO.userId),
                        Collectors.collectingAndThen(Collectors.toList(),
                                t -> t.stream().map(tuple -> Terminal.valueOf(tuple.get(QDO.terminalCode))).collect(Collectors.toList()))
                ));

    }

    /**
     * 根据用户获取终端绑定情况
     *
     * @param userId 用户ID
     * @return 关联信息
     */
    public List<SysUserTerminalDO> queryByUserId(Long userId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.userId.eq(userId))
                .fetch();
    }

}
