package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantCurrencyDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantCurrencyDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
@Repository
public class TenantCurrencyRepoProc extends BaseRepoProc<SysTenantCurrencyDO> {
    private static final QSysTenantCurrencyDO QDO = QSysTenantCurrencyDO.sysTenantCurrencyDO;

    public TenantCurrencyRepoProc() {
        super(QDO);
    }

    /**
     * 获取ID
     *
     * @param tenantId
     * @param currCode
     * @return
     */
    public Long getId(long tenantId, @NotBlank String currCode) {
        return super.jpaQueryFactory.select(QDO.id)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId).and(QDO.currCode.eq(currCode)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 查询禁用的
     *
     * @param tenantId
     * @return
     */
    public List<String> queryCurrCodesOfDisabled(long tenantId) {
        return super.jpaQueryFactory.select(QDO.currCode)
                .from(QDO)
                .where(QDO.sysTenantId.eq(tenantId).and(QDO.enabled.eq(false)))
                .fetch();
    }
}
