package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.UnifyQueryPagedQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUnifyQueryRecordDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUnifyQueryRecordDO;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/6
 */
@Repository
public class UnifyQueryRepoProc extends BaseRepoProc<SysUnifyQueryRecordDO> {
    private static final QSysUnifyQueryRecordDO QDO = QSysUnifyQueryRecordDO.sysUnifyQueryRecordDO;

    public UnifyQueryRepoProc() {
        super(QDO);
    }

    public void updateQueryResult(long id, boolean success, String data, String failReason, LocalDateTime finishTime, long cost) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.success, success)
                .set(QDO.queryResult, data)
                .set(QDO.finishTime, finishTime)
                .set(QDO.costTime, cost)
                .set(QDO.failReason, failReason)
                .where(QDO.id.eq(id))
                .execute();
    }

    public PagingVO<SysUnifyQueryRecordDO> pageMng(UnifyQueryPagedQueryVO queryVO) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.userId, queryVO.getUserId())
                .andBetween(QDO.queryTime, queryVO.getQueryTimeStart(), queryVO.getQueryTimeEnd())
                .andEq(QDO.appCode, queryVO.getAppCode())
                .andEq(QDO.businessObjectCode, queryVO.getBusinessObjectCode())
                .andEq(QDO.success, queryVO.getSuccess())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.queryTime.desc());
    }
}
