package com.elitescloud.cloudt.system.util;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:09
 * @Description:
 */
public class BeanFormat {
    /**
     * 获得字段值，通过反射直接获得字段值，并不调用getXXX方法<br>
     * 对象同样支持Map类型，fieldNameOrIndex即为key
     *
     * <ul>
     *     <li>Map: fieldNameOrIndex需为key，获取对应value</li>
     *     <li>Collection: fieldNameOrIndex当为数字，返回index对应值，非数字遍历集合返回子bean对应name值</li>
     *     <li>Array: fieldNameOrIndex当为数字，返回index对应值，非数字遍历数组返回子bean对应name值</li>
     * </ul>
     *
     * @param bean             Bean对象
     * @param fieldNameOrIndex 字段名或序号，序号支持负数
     * @return 字段值
     */
    public Object getFieldValue(Object bean, String fieldNameOrIndex) {
        return BeanUtils.getFieldValue(bean, fieldNameOrIndex);
    }
}
