package com.elitescloud.cloudt.system.util;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:28
 * @Description:
 */
@Slf4j
public class BpmnTraceUtil {
    public static final String X_BPMN_TRACE_ID = "X-Bpmn-TraceId";

    /**
     * 初始化链路ID
     */
    public static void initTraceId() {
        String traceId = MDC.get(X_BPMN_TRACE_ID);
        if (StrUtil.isBlank(traceId)) {
            MDC.put(X_BPMN_TRACE_ID, IdUtil.fastSimpleUUID());
        }
    }

    /**
     * 清空上下文
     */
    public static void clearTraceId() {
        MDC.remove(X_BPMN_TRACE_ID);
    }

    public static String getTraceId() {
        return MDC.get(X_BPMN_TRACE_ID);
    }
}
