package com.elitescloud.cloudt.system.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:12
 * @Description:
 */
@Slf4j
public class IamUserUtil {
    private static final Logger log = LoggerFactory.getLogger(IamUserUtil.class);
    private static final Long DEFAULT_TENANT_ID = -1L;
    private static final String CURR_USER_ERROR = "获取当前用户信息失败";

    public IamUserUtil() {
    }

    public static boolean isLogin() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        return ObjectUtil.isNull(user);
    }

    public static GeneralUserDetails currentUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull(user)) {
            throw new BusinessException("获取当前用户信息失败");
        } else {
            return user;
        }
    }

    public static String currentUserName() {
        String userName = SecurityContextUtil.currentUserName();
        if (StrUtil.isBlank(userName)) {
            throw new BusinessException("获取当前用户信息失败");
        } else {
            return userName;
        }
    }

    public static Long currentUserId() {
        Long userId = SecurityContextUtil.currentUserId();
        if (ObjectUtil.isNull(userId)) {
            throw new BusinessException("获取当前用户信息失败");
        } else {
            return userId;
        }
    }

    public static String currentUserIdStr() {
        return String.valueOf(currentUserId());
    }

    public static Long currentTenantId() {
        SysTenantDTO tenant = currentTenant();
        return ObjectUtil.isNull(tenant.getId()) ? DEFAULT_TENANT_ID : tenant.getId();
    }

    public static String currentTenantIdStr() {
        return String.valueOf(currentTenantId());
    }

    public static Long currentUserOuId() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (ObjectUtil.isNull(user)) {
            throw new BusinessException("获取当前用户信息失败");
        } else {
            return (Long) Optional.of(user).map(GeneralUserDetails::getUser).map(SysUserDTO::getOuId).orElse(0L);
        }
    }

    public static SysTenantDTO currentTenant() {
        return TenantClient.getSessionTenant();
    }

    public static String currentTenantCode() {
        SysTenantDTO tenant = TenantClient.getSessionTenant();
        return ObjectUtil.isNull(tenant) ? null : tenant.getTenantCode();
    }

    public static long currentTenantIdByCookie() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        Cookie[] cookies = request.getCookies();
        if (ObjectUtil.isNotNull(cookies)) {
            List<String> tokens = (List) Arrays.stream(cookies).filter((cookie) -> {
                return "token".equals(cookie.getName());
            }).map(Cookie::getValue).collect(Collectors.toList());
            GeneralUserDetails user = CollUtil.isNotEmpty(tokens) ?
                    SecurityContextUtil.convertToken(((String) tokens.get(0)).replace("Bearer%20", "")) : null;
            return (Long) Optional.ofNullable(user).map(GeneralUserDetails::getUser).map(SysUserDTO::getTenantId).orElse(DEFAULT_TENANT_ID);
        } else {
            return DEFAULT_TENANT_ID;
        }
    }

    public static String currentToken() {
        return SecurityContextUtil.currentToken();
    }
}
