package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.system.service.SysLogService;
import com.elitescloud.cloudt.system.service.impl.SysLogServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:30
 * @Description:
 */
@Slf4j
public class LogUtil {

    private static final Logger logger = LoggerFactory.getLogger(LogUtil.class);
    private static SysLogService sysLogService;

    private static SysLogService getInstance() {
        if (sysLogService == null) {
            sysLogService = (SysLogService) SpringUtil.getBean(SysLogServiceImpl.class);
        }

        return sysLogService;
    }

    public static void info(String message) {
        getInstance().info(message);
    }

    public static void info(String message, Object param) {
        getInstance().info(message, param);
    }

    public static void error(String message) {
        getInstance().error(message, (Object) null, "");
    }

    public static void error(String message, String trackTypeError) {
        getInstance().error(message, (Object) null, trackTypeError);
    }

    public static void error(String message, Throwable ex) {
        getInstance().error(message, (Object) null, ex);
    }

    public static void error(String message, Object param, Throwable ex) {
        getInstance().error(message, param, ex);
    }

    public static void error(String message, Object param, String trackTypeError) {
        getInstance().error(message, param, trackTypeError);
    }

    public static void info(String trackType, String message, Object param) {
        getInstance().info(trackType, message, param);
    }

    public static void error(String trackType, String message, Object param, Throwable ex) {
        getInstance().error(trackType, message, param, ex);
    }

    public static void error(String trackType, String message, Object param, String trackTypeError) {
        getInstance().error(trackType, message, param, trackTypeError);
    }

    public LogUtil() {
    }
}
