package com.elitescloud.cloudt.system.util;

import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/12/25 20:45
 * @Description:
 */
public class MapUtils {
    public MapUtils() {
    }

    public static <K, V> V putIfPresent(Map<K, V> map, K key, V value) {
        return key != null && value != null ? map.put(key, value) : value;
    }

    public static Map<String, String[]> convert(MultiValueMap<String, String> multivalueMap) {
        Map<String, String[]> map = new HashMap();
        Iterator var2 = multivalueMap.entrySet().iterator();

        while (var2.hasNext()) {
            Map.Entry<String, List<String>> entry = (Map.Entry) var2.next();
            String key = (String) entry.getKey();
            List<String> values = (List) entry.getValue();
            String[] array = (String[]) values.toArray(new String[0]);
            map.put(key, array);
        }

        return map;
    }

    public static MultiValueMap<String, String> convert(Map<String, String[]> multivalueMap) {
        MultiValueMap<String, String> map = new LinkedMultiValueMap();
        Iterator var2 = multivalueMap.entrySet().iterator();

        while (var2.hasNext()) {
            Map.Entry<String, String[]> entry = (Map.Entry) var2.next();
            map.addAll((String) entry.getKey(), List.of((String[]) entry.getValue()));
        }

        return map;
    }
}
