package com.elitescloud.cloudt.ucenter.api.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "广告管理查询出参")
public class AdInfoDTO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;
    @ApiModelProperty("广告id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("广告编码")
    private String adCode;

    @ApiModelProperty("广告图片文件编码")
    private String imgFileCode;

    @ApiModelProperty("广告标题")
    private String adTitle;

    @ApiModelProperty("广告位说明")
    private String adSpaceDesc;

    @ApiModelProperty("广告位id")
    private Long adSpaceId;

    @ApiModelProperty("广告位code")
    private String adSpaceCode;

    @ApiModelProperty("广告位名称")
    private String adSpaceName;

    @ApiModelProperty("链接类型")
    private String adLinkType;

    @ApiModelProperty("链接地址")
    private String linkAddress;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    private String showFlag;

    @ApiModelProperty("广告排序")
    private Integer sortNo;

    @ApiModelProperty("广告开始时间")
    private LocalDateTime showBeginTime;

    @ApiModelProperty("广告结束时间")
    private LocalDateTime showEndTime;
}
