package com.elitescloud.cloudt.ucenter.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Data
@ApiModel(description = "网站外观配置信息表")
public class WebsiteAppearanceSaveVO implements Serializable {

    private static final long serialVersionUID = 6323896646377721743L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "标题", required = true)
    @NotNull(message = "标题不能为空")
    private String title;

    @ApiModelProperty(value = "网站类型", required = true)
    @NotNull(message = "网站类型不能为空")
    private String type;

    @ApiModelProperty(value = "浏览器logo图片id")
    private String browserLogoId;

    @ApiModelProperty(value = "网页logo图片id")
    private String webpageLogoId;

    @ApiModelProperty(value = "主题色", required = true)
    @NotNull(message = "主题色不能为空")
    private String themeColor;

    @ApiModelProperty(value = "字体大小")
    private Integer fontSize;

    @ApiModelProperty(value = "默认语言")
    private String language;

    @ApiModelProperty(value = "是否支持多语言")
    private Boolean multiLanguageFlag;

    @ApiModelProperty(value = "菜单是否展开")
    private Boolean menuUnfoldFlag;

    @ApiModelProperty(value = "菜单区域宽度")
    private Integer menuWidth;

    @ApiModelProperty(value = "网站描述")
    private String description;

    @ApiModelProperty(value = "表格双击后可编辑")
    private Boolean tableDoubleClickEdit;
}
