package com.elitescloud.cloudt.ucenter.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.ucenter.api.dto.PcBarDTO;
import com.elitescloud.cloudt.ucenter.api.dto.WebsiteBarDTO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.UpBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteBarRespVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteBarSaveVO;
import com.elitescloud.cloudt.ucenter.entity.WebsiteBarDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 16:12
 */
@Mapper(config = BaseMapperConfig.class)
public interface WebsiteBarConvert {

    WebsiteBarConvert INSTANCE = Mappers.getMapper(WebsiteBarConvert.class);

    /**
     * do转saveVo
     *
     * @param websiteBarDO do
     * @return saveVo
     */
    WebsiteBarSaveVO do2SaveVo(WebsiteBarDO websiteBarDO);

    /**
     * do转dto
     *
     * @param websiteBarDO do
     * @return dto
     */
    PcBarDTO do2Dto(WebsiteBarDO websiteBarDO);


    /**
     * saveVo转do
     *
     * @param websiteBarSaveVO saveVo
     * @return do
     */
    WebsiteBarDO saveVo2Do(WebsiteBarSaveVO websiteBarSaveVO);

    List<UpBarRespVO> dosUpBarVos(List<WebsiteBarDO> doList);

    List<WebsiteBarRespVO> barDTOsToVos(List<WebsiteBarDTO> records);

    WebsiteBarRespVO do2DetailRespVo(WebsiteBarDO websiteBarDO);
}
