package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_ad_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_ad_info", comment = "广告信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class AdInfoDO extends BaseModel implements Serializable {

    @Column(name = "ad_code")
    private String adCode;

    @Column(name = "ad_title")
    private String adTitle;

    @Column(name = "ad_space_id")
    private Long adSpaceId;

    @Column(name = "ad_space_code")
    private String adSpaceCode;

    @Column(name = "ad_space_name")
    private String adSpaceName;

    @Comment(value = "[UDC]cloudt-system:SHOW_FLAG")
    @Column(name = "ad_link_type")
    private String adLinkType;

    @Column(name = "show_flag")
    private String showFlag;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "show_begin_time")
    private LocalDateTime showBeginTime;

    @Column(name = "show_end_time")
    private LocalDateTime showEndTime;

    @Comment(value = "[UDC]cloudt-system:TARGET_TYPE")
    @Column(name = "target_type")
    private String targetType;

    @Column(name = "link_address_id")
    private Long linkAddressId;

    @Column(name = "link_address")
    private String  linkAddress;

    @Column(name = "img_file_code")
    private String imgFileCode;

    @Column(name = "video_file_code")
    private String videoFileCode;

    @Comment(value = "[UDC]cloudt-system:SOURCE_TYPE")
    @Column(name = "source_type")
    private String sourceType;

    @Comment(value = "链接来源")
    @Column()
    private String linkSource;
}