package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.io.Serializable;

@Entity
@Table(name = "sys_article_category", indexes = {
        @Index(name = "idx_article_category_pid", columnList = "pid")
})
@org.hibernate.annotations.Table(appliesTo = "sys_article_category", comment = "文章分类")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleCategoryDO extends BaseModel implements Serializable {
    @Serial
    private static final long serialVersionUID = 5099388629967014878L;

    @Column()
    private String categoryName;

    @Column()
    private Integer sortNo;

    @Column()
    private String showFlag;

    @Column()
    private Long pid;

    @Column()
    private Long rootId;

//    @Column(name = "pid_list")
//    private String pidList;
}
