package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "sys_article_info", indexes = {
        @Index(name = "idx_article_info_code", columnList = "articleCode"),
        @Index(name = "idx_article_info_category", columnList = "categoryId"),
})
@org.hibernate.annotations.Table(appliesTo = "sys_article_info", comment = "文章信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ArticleInfoDO extends BaseModel implements Serializable {

    @Column()
    private String articleAuthor;

    @Column()
    private String articleName;

    @Column()
    private String articleCode;

    @Column()
    private Integer sortNo;

    @Column()
    private String showFlag;

    @Column()
    private Long categoryId;

    @Column()
    private String categoryName;

    @Lob
    @Column()
    private String articleDetail;
}
