package com.elitescloud.cloudt.ucenter.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_message_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "sys_message_info", comment = "消息信息")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MessageInfoDO extends BaseModel implements Serializable {


    @Column(name = "message_title")
    private String messageTitle;

    @Column(name = "category_code")
    private String categoryCode;

    @Column(name = "publish_status")
    private String publishStatus;

    @Column(name = "message_detail")
    private String messageDetail;

    @Column(name = "total_count")
    private Integer totalCount;

    @Column(name = "read_count")
    private Integer readCount;

    @Column(name = "publish_time")
    private LocalDateTime publishTime;

    @Column(name = "record_id")
    private String recordId;
}
