package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Entity
@Table(name = "sys_website_appearance")
@org.hibernate.annotations.Table(appliesTo = "sys_website_appearance", comment = "网站外观配置信息表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class WebsiteAppearanceDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 864686640564020191L;

    @Column(name = "title")
    private String title;

    @Column(name = "type")
    private String type;

    @Column(name = "browser_logo_id")
    private String browserLogoId;

    @Column(name = "webpage_logo_id")
    private String webpageLogoId;

    @Column(name = "theme_color")
    private String themeColor;

    @Column(name = "font_size")
    private Integer fontSize;

    @Column(name = "language")
    private String language;

    @Column(name = "multi_language_flag")
    private Boolean multiLanguageFlag;

    @Column(name = "menu_unfold_flag")
    private Boolean menuUnfoldFlag;

    @Column(name = "menu_width")
    private Integer menuWidth;

    @Column()
    @Comment(value = "表格双击后编辑", defaultValue = "1")
    private Boolean tableDoubleClickEdit;

    @Column(name = "description")
    private String description;

}
