package com.elitescloud.cloudt.ucenter.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.AdSpaceDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdSpacePagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.resp.AdSpaceRespVO;
import com.elitescloud.cloudt.ucenter.entity.AdSpaceDO;
import com.elitescloud.cloudt.ucenter.entity.QAdSpaceDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

@Repository
//@RequiredArgsConstructor
public class AdSpaceRepoProc extends BaseRepoProc<AdSpaceDO> {

    private final static QAdSpaceDO Q_DO = QAdSpaceDO.adSpaceDO;

    protected AdSpaceRepoProc() {
        super(Q_DO);
    }

    public PagingVO<AdSpaceDTO> findAdSpacePagingResults(AdSpacePagingParam param) {
        JPAQuery<AdSpaceDTO> query = select(AdSpaceDTO.class);
        List<Predicate> predicates = new ArrayList<>();
        if (!StringUtils.isEmpty(param.getAdSpaceCodeName())) {
            String likeStr = "%" + param.getAdSpaceCodeName() + "%";
            predicates.add(Q_DO.adSpaceCode.like(likeStr).or(Q_DO.adSpaceName.like(likeStr)));
        }
        if (StringUtils.isNotEmpty(param.getShowStyle())) {
            predicates.add(Q_DO.showStyle.eq(param.getShowStyle()));
        }
        predicates.add(Q_DO.deleteFlag.eq(0).or(Q_DO.deleteFlag.isNull()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, Q_DO);
        param.setPaging(query);
        return PagingVO.<AdSpaceDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.adSpaceCode,
                Q_DO.adSpaceName,
                Q_DO.adSpaceDesc,
                Q_DO.sortNo,
                Q_DO.showStyle
        )).from(Q_DO);
    }

    public List<AdSpaceRespVO> queryByCodes(List<String> codes) {
        List<AdSpaceRespVO> fetch = select(AdSpaceRespVO.class)
                .where(Q_DO.adSpaceCode.in(codes))
                .where(Q_DO.deleteFlag.eq(0).or(Q_DO.deleteFlag.isNull()))
                .fetch();
        return fetch;
    }

    public Long updateByCode(List<String> code, Integer deleteFlag) {
        Long res = jpaQueryFactory.update(Q_DO)
                .set(Q_DO.deleteFlag, deleteFlag)
                .where(Q_DO.adSpaceCode.in(code))
                .execute();
        return res;
    }

    private Predicate buildPredicate(AdSpacePagingParam adSpacePagingParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(adSpacePagingParam.getAdSpaceCodeName()), Q_DO.adSpaceCode, adSpacePagingParam.getAdSpaceCodeName())
                .buildOr();
        return predicate;
    }

}
