package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.ucenter.entity.MessageReceiverDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public interface MessageReceiverRepo extends JpaRepository<MessageReceiverDO, Long>, QuerydslPredicateExecutor<MessageReceiverDO> {

    @Transactional
    @Modifying
    @Query(value = "delete from sys_message_receiver where message_id = ?1", nativeQuery = true)
    void deleteByMessageId(Long messageId);

    Integer deleteAllByMessageIdIn(List<Long> ids);

    List<MessageReceiverDO> findAllByMessageId(Long messageId);
    @Transactional
    @Modifying
    @Query(value = "update sys_message_receiver set read_status = '0' where message_id = ?1", nativeQuery = true)
    void updateReadStatusByMessageId(Long messageId);

    @Transactional
    @Modifying
    @Query(value = "update sys_message_receiver set delete_flag = 1 where message_id in ?1", nativeQuery = true)
    void updateByMessageIdInBatch(List<Long> publishIdList);


    @Transactional
    @Modifying
    @Query(value = "delete from sys_message_receiver where message_id in ?1", nativeQuery = true)
    void deleteByMessageIdInBatch(List<Long> publishIdList);
}
