ALTER TABLE sys_role
    ADD parent_code varchar(100) DEFAULT '' NULL COMMENT '上级角色编码';
CREATE INDEX idx_role_parent USING BTREE ON sys_role (parent_code);


CREATE TABLE `sys_role_related`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `related_type`       varchar(255) NOT NULL COMMENT '关联类型',
    `related_id`         varchar(255) NOT NULL COMMENT '关联标识',
    `role_code`          varchar(255) NOT NULL COMMENT '角色（组）编码',
    `role_group`         bit(1)       DEFAULT NULL COMMENT '是否是角色组',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_role_related_relatedid` (`related_id`),
    KEY `idx_role_related_role` (`role_code`)
) COMMENT ='角色关联';