-- `cloudt3-system`.com_payment_term definition

CREATE TABLE `com_payment_term`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `pt_code`            varchar(40)  DEFAULT NULL COMMENT '代码',
    `pt_name`            varchar(40)  DEFAULT NULL COMMENT '名称',
    `days`               int          DEFAULT NULL COMMENT '天数',
    `base_day_type`      varchar(40)  DEFAULT NULL COMMENT '基于日期类型',
    `day_calc_method`    varchar(40)  DEFAULT NULL COMMENT '日期计算方式 是否含工作日',
    `valid_from`         datetime     DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     DEFAULT NULL COMMENT '失效日期',
    `enable_flag`        int          DEFAULT '0' COMMENT '是否有效',
    `account_code`       varchar(40)  DEFAULT NULL COMMENT '对账报账编码',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT NULL COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT 'sec_ou_id',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT ='支付条款 币种 此表使用CODE来引用，不使用ID。';


-- `cloudt3-system`.dynamic_bo_field_definition definition

CREATE TABLE `dynamic_bo_field_definition`
(
    `id`                                   bigint       NOT NULL COMMENT '记录唯一ID',
    `business_object_code`                 varchar(255) DEFAULT NULL COMMENT '标识此字段所属的业务对象编码',
    `basic_module_code`                    varchar(255) DEFAULT NULL COMMENT '标识此字段所属的模块或实体 DynamicBoModelDo表关联',
    `db_field`                             bit(1)       NOT NULL COMMENT '是否数据库字段',
    `db_table_name`                        varchar(255) DEFAULT NULL COMMENT '数据库表名',
    `db_field_name`                        varchar(255) DEFAULT NULL,
    `db_field_type`                        varchar(255) DEFAULT NULL COMMENT '数据库字段类型',
    `db_field_length`                      int          DEFAULT NULL COMMENT '字段长度',
    `db_field_precision`                   int          DEFAULT NULL COMMENT '字段精度',
    `db_field_scale`                       int          DEFAULT NULL COMMENT '字段位数 precision配合',
    `db_field_nullable`                    bit(1)       DEFAULT NULL,
    `db_field_default_value`               varchar(255) DEFAULT NULL COMMENT '字段的默认值',
    `db_field_primary_key`                 bit(1)       DEFAULT NULL,
    `db_field_unique`                      bit(1)       DEFAULT NULL COMMENT '字段值是否需要唯一',
    `db_field_index`                       bit(1)       DEFAULT NULL COMMENT '是否为该字段创建索引',
    `db_field_foreign_table`               varchar(255) DEFAULT NULL,
    `db_field_foreign_field`               varchar(255) DEFAULT NULL,
    `db_field_check_constraint`            varchar(255) DEFAULT NULL,
    `db_field_constraints`                 varchar(255) DEFAULT NULL,
    `db_field_description`                 varchar(255) DEFAULT NULL,
    `db_field_virtual_field`               bit(1)       DEFAULT NULL,
    `db_field_calculation_expression`      varchar(255) DEFAULT NULL,
    `db_field_auto_increment`              bit(1)       DEFAULT NULL,
    `db_field_collation`                   varchar(255) DEFAULT NULL,
    `db_order`                             int          DEFAULT NULL,
    `basic_key`                            varchar(255) NOT NULL COMMENT '数据库和API中使用的唯一键名',
    `basic_key_as`                         varchar(255) DEFAULT NULL COMMENT '数据库和API中使用的唯一键名别名',
    `basic_name`                           varchar(255) DEFAULT NULL COMMENT '用户界面显示的字段名',
    `basic_type`                           varchar(255) NOT NULL COMMENT '字段的数据类型',
    `basic_description`                    varchar(255) DEFAULT NULL COMMENT '字段用途或输入要求的描述信息。',
    `basic_default_value`                  varchar(255) DEFAULT NULL COMMENT '创建实体时的默认值',
    `basic_required`                       bit(1)       DEFAULT NULL COMMENT '指示字段在创建或更新实体时是否必填',
    `basic_display_order`                  int          DEFAULT NULL COMMENT '前端显示的排序顺序',
    `basic_status`                         varchar(255) DEFAULT NULL COMMENT '字段是否启用',
    `display_type`                         varchar(255) DEFAULT NULL COMMENT '展示类型指明了字段在前端UI中的展示方式',
    `display_options_json`                 longtext COMMENT '选项值，仅对枚举类型的字段适用，存储为JSON字符串',
    `display_multivalue`                   bit(1)       DEFAULT NULL COMMENT '指示字段是否可以包含多个值',
    `display_group`                        varchar(255) DEFAULT NULL COMMENT '字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性',
    `display_readonly`                     bit(1)       DEFAULT NULL COMMENT '只读属性指示字段在UI中是否只能被显示而不能被修改',
    `display_visibility_condition_json`    longtext COMMENT '控制字段在UI中的可见性的条件，存储为JSON字符串',
    `display_ui_attributes_json`           longtext COMMENT 'UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串',
    `display_linked_entity`                varchar(255) DEFAULT NULL COMMENT '关联实体类型和关系。如果字段值指向另一个实体，该属性定义了所关联的实体类型。',
    `display_dynamic_attributes_json`      longtext COMMENT '动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串',
    `display_dependent_fields_json`        longtext COMMENT '依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。',
    `config_web_validation_pattern`        longtext COMMENT '前端验证模式，提供一个正则表达式或其他验证模式，用于前端实时验证用户输入。',
    `config_web_extended_data`             longtext COMMENT '前端扩展数据存储',
    `config_web_function`                  longtext COMMENT '前端函数存储',
    `config_searchable`                    bit(1)       DEFAULT NULL COMMENT '可搜索属性标记字段是否可以被用作搜索条件',
    `config_sortable`                      bit(1)       DEFAULT NULL COMMENT '可排序属性指示字段是否可以用作列表排序的依据',
    `config_import_export`                 bit(1)       DEFAULT NULL COMMENT '导入导出属性标记字段是否应包含在数据导入导出操作中',
    `config_access_control_json`           longtext COMMENT '权限控制，存储为JSON字符串。定义了哪些用户或角oles可以访问或修改字段。',
    `config_track_history`                 bit(1)       DEFAULT NULL COMMENT '历史记录属性指示是否追踪字段值的变更历史',
    `config_encrypted`                     bit(1)       DEFAULT NULL COMMENT '数据加密属性标记',
    `config_sensitive`                     bit(1)       DEFAULT NULL COMMENT '敏感数据标记',
    `config_autocomplete_suggestions_json` longtext COMMENT '自动填充建议属性，存储为JSON字符串。提供用户输入时的自动完成建议。',
    `tenant_id`                            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`                       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`                   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `basic_state`                          bit(1)       DEFAULT b'1' COMMENT '字段是否启用',
    PRIMARY KEY (`id`),
    KEY `idx_bo_business_object_code` (`business_object_code`),
    KEY `idx_bo_basic_module_code` (`basic_module_code`),
    KEY `idx_bo_basic_key` (`basic_key`),
    KEY `idx_bo_basic_type` (`basic_type`),
    KEY `idx_bo_basic_status` (`basic_status`),
    KEY `idx_bo_display_type` (`display_type`),
    KEY `idx_bo_config_searchable` (`config_searchable`),
    KEY `idx_bo_config_sortable` (`config_sortable`),
    KEY `idx_bo_config_import_export` (`config_import_export`),
    KEY `idx_dynamic_bofield_businessobj` (`business_object_code`),
    KEY `idx_dynamic_bofield_bmocode` (`basic_module_code`),
    KEY `idx_dynamic_bofield_table` (`db_table_name`)
) COMMENT ='动态bo字段定义表';

-- `cloudt3-system`.dynamic_bo_model definition

CREATE TABLE `dynamic_bo_model`
(
    `id`                   bigint NOT NULL COMMENT '记录唯一ID',
    `bo_model_code`        varchar(255) DEFAULT NULL COMMENT 'BO模型编码，唯一标识',
    `bo_mode_name`         varchar(255) DEFAULT NULL COMMENT 'BO模型名称',
    `database_table_name`  varchar(255) DEFAULT NULL COMMENT 'BO模型对应的数据库表名',
    `description`          varchar(255) DEFAULT NULL COMMENT 'BO模型描述',
    `creation_table`       bit(1)       DEFAULT NULL COMMENT '是否创建表',
    `form_json`            json         DEFAULT NULL COMMENT '业务对象模型表单展示JSON',
    `list_page_json`       json         DEFAULT NULL COMMENT '业务对象模型列表展示JSON',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `business_object_code` varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    PRIMARY KEY (`id`),
    KEY `idx_dynamicbo_code` (`bo_model_code`),
    KEY `idx_dynamicbo_businessobj` (`business_object_code`),
    KEY `idx_dynamicbo_table` (`database_table_name`)
) COMMENT ='动态BO模型定义表';

-- `cloudt3-system`.dynamic_bo_model_relation definition

CREATE TABLE `dynamic_bo_model_relation`
(
    `id`                      bigint NOT NULL COMMENT '记录唯一ID',
    `bo_model_code`           varchar(255) DEFAULT NULL COMMENT 'BO模型编码',
    `bo_model_code_relevance` varchar(255) DEFAULT NULL COMMENT 'BO模型编码',
    `bo_model_type`           varchar(255) DEFAULT NULL COMMENT 'BO模型类型（主表/明细表）',
    `tenant_id`               bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`           bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`           bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                  varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`          bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                 varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`             datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`          bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                 varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`             datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`             int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`      int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`               bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`             bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`               bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='BO模型关系表';

-- `cloudt3-system`.dynamic_configurator definition

CREATE TABLE `dynamic_configurator`
(
    `id`                               bigint NOT NULL COMMENT '记录唯一ID',
    `dynamic_configurator_name`        varchar(255) DEFAULT NULL COMMENT '配置能力名称',
    `dynamic_configurator_code`        varchar(255) DEFAULT NULL COMMENT '配置能力编码，唯一标识',
    `dynamic_configurator_type`        varchar(255) DEFAULT NULL COMMENT '配置能力表类型（单表/主表明细表）',
    `layout_template_code`             varchar(255) DEFAULT NULL COMMENT '前端展示布局模板编码',
    `layout_template_name`             varchar(255) DEFAULT NULL COMMENT '前端展示布局模板名称',
    `dynamic_configurator_status`      varchar(255) DEFAULT NULL COMMENT '状态',
    `dynamic_configurator_description` varchar(500) DEFAULT NULL COMMENT '描述',
    `form_json`                        longtext COMMENT '表单展示JSON',
    `list_page_json`                   longtext COMMENT '列表展示JSON',
    `frontend_extension_json`          longtext COMMENT '前端扩展字段json',
    `approval_json`                    longtext COMMENT '流程JSON',
    `operate_json`                     longtext COMMENT '功能模块操作JSON',
    `tenant_id`                        bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                    bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                    bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                           varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`                   bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                          varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                      datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                   bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                          varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                      datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                      int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`               int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                        bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                      bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                        bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `approval_type`                    varchar(255) DEFAULT NULL COMMENT '流程审批类型',
    `app_code`                         varchar(255) DEFAULT NULL COMMENT '发布应用编码',
    `menu_group_code`                  varchar(255) DEFAULT NULL COMMENT '发布应用分组编码',
    `menu_code`                        varchar(255) DEFAULT NULL COMMENT '发布后菜单编码',
    `deploy_status`                    varchar(255) DEFAULT NULL COMMENT '部署状态',
    `published`                        bit(1)       DEFAULT b'0' COMMENT '是否已发布',
    `deployed`                         bit(1)       DEFAULT b'0' COMMENT '是否已部署',
    `enabled`                          bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `created_approval`                 bit(1)       DEFAULT b'0' COMMENT '是否已创建审批流程',
    `approval_engine`                  varchar(255) DEFAULT NULL COMMENT '工作流引擎',
    `approval_key`                     varchar(255) DEFAULT NULL COMMENT '流程定义Key',
    PRIMARY KEY (`id`),
    KEY `idx_dynamicf_code` (`dynamic_configurator_code`),
    KEY `idx_dynamicf_approvalkey` (`approval_key`)
) COMMENT ='配置能力表';

-- `cloudt3-system`.dynamic_configurator_bo_relation definition

CREATE TABLE `dynamic_configurator_bo_relation`
(
    `id`                        bigint NOT NULL COMMENT '记录唯一ID',
    `dynamic_configurator_code` varchar(255) DEFAULT NULL COMMENT '配置能力编码',
    `bo_model_code`             varchar(255) DEFAULT NULL COMMENT 'BO模型编码',
    `bo_model_type`             varchar(255) DEFAULT NULL COMMENT 'BO模型类型（主表/明细表）',
    `tenant_id`                 bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`             bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`             bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                    varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`            bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                   varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`               datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`            bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                   varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`               datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`               int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`        int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                 bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`               bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                 bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_dynamic_cfg2bo_cfg` (`dynamic_configurator_code`),
    KEY `idx_dynamic_cfg2bo_bo` (`bo_model_code`)
) COMMENT ='配置能力BO关系表';

-- `cloudt3-system`.observation_operation_auto_log definition

CREATE TABLE `observation_operation_auto_log`
(
    `id`                    bigint       NOT NULL AUTO_INCREMENT,
    `app_name`              varchar(255)          DEFAULT NULL COMMENT '应用标识 （非必填，默认：取值spring.application.name，微服务工程名）',
    `menu_code`             varchar(255)          DEFAULT NULL COMMENT '操作页面编码（非必填，默认：取值http request head获取请求）',
    `business_type`         varchar(255) NOT NULL COMMENT '唯一业务类型（必填），业务对象名称，开发指定，规范：业务对象的名称应直观地描述其作用或所代表的实体',
    `business_type_name`    varchar(255)          DEFAULT NULL COMMENT '唯一业务类型（必填），业务对象名称中文',
    `business_param`        varchar(255) NOT NULL COMMENT '唯一业务参数（必填），重要参数：产品或开发需求文档上标注，如：订单编号，员工编号。 用于操作日志查询）',
    `operation_type`        varchar(255) NOT NULL COMMENT '操作类型，必填：使用OperationTypeEnum枚举 必填（枚举：创建，编辑，删除，审批，导出，导入，查询，其他）',
    `operation_type_name`   varchar(255)          DEFAULT NULL COMMENT '操作类型名称，默认：使用操作类型枚举名称，如果是其他类型，必填',
    `operation_description` text         NOT NULL COMMENT '操作描述（必填），操作主数据记录',
    `operation_before_data` text COMMENT '操作前数据存储（非必填）',
    `operation_after_data`  text COMMENT '操作后数据存储（非必填）',
    `operation_time`        varchar(255) NOT NULL COMMENT '操作时间（必填）默认：当前时间',
    `operation_user_name`   varchar(255)          DEFAULT NULL COMMENT '操作人名称（非必填）默认：当前登录操作人',
    `operation_user_id`     bigint                DEFAULT NULL COMMENT '操作人ID（非必填）默认：当前登录操作人',
    `request_url`           varchar(255)          DEFAULT NULL COMMENT '操作请求地址 （非必填）默认：通过HTTP REQUEST获取地址',
    `tenant_id`             bigint                DEFAULT NULL COMMENT '租户ID：默认：当前操作人租户',
    `request_method`        varchar(255)          DEFAULT NULL COMMENT '请求方式（非必填）默认：通过HTTP REQUEST获取',
    `operation_ip`          varchar(255)          DEFAULT NULL COMMENT '操作IP （非必填）默认：当前请求IP',
    `success`               tinyint(1)   NOT NULL DEFAULT '0' COMMENT '是否成功（必填） 默认：false',
    `exception_desc`        text COMMENT '失败描述，成功非必填，失败必填',
    `token`                 text COMMENT 'token',
    `ext1`                  text COMMENT '扩展1',
    `ext2`                  text COMMENT '扩展2',
    `ext3`                  text COMMENT '扩展3',
    `source`                varchar(255)          DEFAULT NULL COMMENT '数据来源',
    `operation_name`        varchar(255)          DEFAULT NULL COMMENT '操作人名称',
    `trace_id_sys`          varchar(255)          DEFAULT NULL COMMENT '链路ID-系统生成',
    `trace_id_ext`          varchar(255)          DEFAULT NULL COMMENT '链路ID-其他链路工具，默认sk',
    `creation_date`         datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `sys_delayed`           bigint       NOT NULL DEFAULT '0' COMMENT '耗时',
    `executor_source`       varchar(255)          DEFAULT NULL COMMENT '执行来源',
    PRIMARY KEY (`id`, `creation_date`) USING BTREE,
    KEY `business_param_index` (`business_param`) USING BTREE,
    KEY `business_type` (`business_type`) USING BTREE,
    KEY `operation_type` (`operation_type`) USING BTREE,
    KEY `operation_time` (`operation_time`) USING BTREE,
    KEY `menu_code` (`menu_code`) USING BTREE
) ROW_FORMAT = DYNAMIC COMMENT ='业务操作日志表-自动'
    /*!50100 PARTITION BY RANGE (year(`creation_date`))
    (PARTITION p2023 VALUES LESS THAN (2023) ENGINE = InnoDB,
    PARTITION p2024 VALUES LESS THAN (2024) ENGINE = InnoDB,
    PARTITION p2025 VALUES LESS THAN (2025) ENGINE = InnoDB,
    PARTITION p2026 VALUES LESS THAN (2026) ENGINE = InnoDB,
    PARTITION p2027 VALUES LESS THAN (2027) ENGINE = InnoDB,
    PARTITION p2028 VALUES LESS THAN (2028) ENGINE = InnoDB,
    PARTITION p2029 VALUES LESS THAN (2029) ENGINE = InnoDB,
    PARTITION pMax VALUES LESS THAN MAXVALUE ENGINE = InnoDB) */;


-- `cloudt3-system`.observation_operation_log definition

CREATE TABLE `observation_operation_log`
(
    `id`                    bigint       NOT NULL AUTO_INCREMENT,
    `app_name`              varchar(255)          DEFAULT NULL COMMENT '应用标识 （非必填，默认：取值spring.application.name，微服务工程名）',
    `menu_code`             varchar(255)          DEFAULT NULL COMMENT '操作页面编码（非必填，默认：取值http request head获取请求）',
    `business_type`         varchar(255) NOT NULL COMMENT '唯一业务类型（必填），业务对象名称，开发指定，规范：业务对象的名称应直观地描述其作用或所代表的实体，业务对象对应实体的DO名称 如：SysPlatformUdcDO，SysPlatformMenusDO',
    `business_type_name`    varchar(255)          DEFAULT NULL COMMENT '唯一业务类型（必填），业务对象名称中文',
    `business_param`        varchar(255) NOT NULL COMMENT '唯一业务参数（必填），重要参数：产品或开发需求文档上标注，如：订单编号，员工编号。 用于操作日志查询）',
    `operation_type`        varchar(255) NOT NULL COMMENT '操作类型，必填：使用OperationTypeEnum枚举 必填（枚举：创建，编辑，删除，审批，导出，导入，查询，其他）',
    `operation_type_name`   varchar(255)          DEFAULT NULL COMMENT '操作类型名称，默认：使用操作类型枚举名称，如果是其他类型，必填',
    `operation_description` text         NOT NULL COMMENT '操作描述（必填），操作主数据记录',
    `operation_before_data` text COMMENT '操作前数据存储（非必填）',
    `operation_after_data`  text COMMENT '操作后数据存储（非必填）',
    `operation_time`        varchar(255) NOT NULL COMMENT '操作时间（必填）默认：当前时间',
    `operation_user_name`   varchar(255)          DEFAULT NULL COMMENT '操作人名称（非必填）默认：当前登录操作人',
    `operation_user_id`     bigint                DEFAULT NULL COMMENT '操作人ID（非必填）默认：当前登录操作人',
    `request_url`           varchar(255)          DEFAULT NULL COMMENT '操作请求地址 （非必填）默认：通过HTTP REQUEST获取地址',
    `tenant_id`             bigint                DEFAULT NULL COMMENT '租户ID：默认：当前操作人租户',
    `request_method`        varchar(255)          DEFAULT NULL COMMENT '请求方式（非必填）默认：通过HTTP REQUEST获取',
    `operation_ip`          varchar(255)          DEFAULT NULL COMMENT '操作IP （非必填）默认：当前请求IP',
    `success`               tinyint(1)   NOT NULL DEFAULT '0' COMMENT '是否成功（必填） 默认：false',
    `exception_desc`        text COMMENT '失败描述，成功非必填，失败必填',
    `token`                 text COMMENT 'token',
    `ext1`                  text COMMENT '扩展1',
    `ext2`                  text COMMENT '扩展2',
    `ext3`                  text COMMENT '扩展3',
    `source`                varchar(255)          DEFAULT NULL COMMENT '数据来源',
    `operation_name`        varchar(255)          DEFAULT NULL COMMENT '操作人名称',
    `trace_id_sys`          varchar(255)          DEFAULT NULL COMMENT '链路ID-系统生成',
    `trace_id_ext`          varchar(255)          DEFAULT NULL COMMENT '链路ID-其他链路工具，默认sk',
    `creation_date`         datetime     NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `sys_delayed`           bigint       NOT NULL DEFAULT '0' COMMENT '耗时',
    `executor_source`       varchar(255)          DEFAULT NULL COMMENT '执行来源',
    PRIMARY KEY (`id`, `creation_date`) USING BTREE,
    KEY `business_param_index` (`business_param`) USING BTREE,
    KEY `business_type` (`business_type`) USING BTREE,
    KEY `operation_type` (`operation_type`) USING BTREE,
    KEY `operation_time` (`operation_time`) USING BTREE,
    KEY `menu_code` (`menu_code`) USING BTREE
)
    ROW_FORMAT = DYNAMIC COMMENT ='业务操作日志表-人工'
    /*!50100 PARTITION BY RANGE (year(`creation_date`))
    (PARTITION p2023 VALUES LESS THAN (2023) ENGINE = InnoDB,
    PARTITION p2024 VALUES LESS THAN (2024) ENGINE = InnoDB,
    PARTITION p2025 VALUES LESS THAN (2025) ENGINE = InnoDB,
    PARTITION p2026 VALUES LESS THAN (2026) ENGINE = InnoDB,
    PARTITION p2027 VALUES LESS THAN (2027) ENGINE = InnoDB,
    PARTITION p2028 VALUES LESS THAN (2028) ENGINE = InnoDB,
    PARTITION p2029 VALUES LESS THAN (2029) ENGINE = InnoDB,
    PARTITION pMax VALUES LESS THAN MAXVALUE ENGINE = InnoDB) */;


-- `cloudt3-system`.sys_ad_info definition

CREATE TABLE `sys_ad_info`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `ad_code`            varchar(64)  DEFAULT NULL COMMENT '广告编码',
    `ad_title`           varchar(256) DEFAULT NULL COMMENT '广告标题',
    `ad_space_id`        bigint       DEFAULT NULL COMMENT '广告位id',
    `ad_space_code`      varchar(256) DEFAULT NULL COMMENT '广告位编码',
    `ad_space_name`      varchar(256) DEFAULT NULL COMMENT '广告位名称',
    `ad_link_type`       varchar(16)  DEFAULT NULL COMMENT '链接类型 internal-内部链接  external-外部链接  custom-自定义',
    `show_flag`          varchar(16)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `sort_no`            int          DEFAULT NULL COMMENT '广告排序',
    `show_begin_time`    datetime     DEFAULT NULL COMMENT '广告开始时间',
    `show_end_time`      datetime     DEFAULT NULL COMMENT '广告结束时间',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型(文章)',
    `link_address_id`    bigint       DEFAULT NULL COMMENT '链接地址id',
    `link_address`       varchar(256) DEFAULT NULL COMMENT '链接地址',
    `img_file_code`      varchar(128) DEFAULT NULL COMMENT '图片文件编码，文件服务器上的文件唯一标识',
    `video_file_code`    varchar(128) DEFAULT NULL COMMENT '视频文件编码，文件服务器上的文件唯一标识',
    `source_type`        varchar(32)  DEFAULT NULL COMMENT '资源类型 1-图片 2-视频',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='广告信息';


-- `cloudt3-system`.sys_ad_space definition

CREATE TABLE `sys_ad_space`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `ad_space_code`      varchar(64)  DEFAULT NULL COMMENT '广告位编码',
    `ad_space_name`      varchar(256) DEFAULT NULL COMMENT '广告位名称',
    `ad_space_desc`      varchar(256) DEFAULT NULL COMMENT '广告位说明',
    `sort_no`            int          DEFAULT NULL COMMENT '排序',
    `show_style`         varchar(32)  DEFAULT NULL COMMENT '展现形式(轮播/平铺/弹窗)',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='广告位信息';


-- `cloudt3-system`.sys_alert definition

CREATE TABLE `sys_alert`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `business_type`      varchar(255) NOT NULL COMMENT '业务类型',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uq_alert_bt` (`business_type`, `tenant_id`)
) COMMENT ='系统预警提醒';


-- `cloudt3-system`.sys_alert_config definition

CREATE TABLE `sys_alert_config`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `business_type`      varchar(255) NOT NULL COMMENT '业务类型',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `alert_type`         varchar(255) NOT NULL COMMENT '提醒方式',
    `cfg_json`           longtext COMMENT '配置内容',
    `description`        varchar(255) DEFAULT NULL COMMENT '说明',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_alert_cfg_bt` (`business_type`)
) COMMENT ='系统预警提醒配置';


-- `cloudt3-system`.sys_app_navbar definition

CREATE TABLE `sys_app_navbar`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `name`               varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1)   DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(32)  DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1)   DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort`               int          DEFAULT NULL COMMENT '排序',
    `upper_bar_id`       bigint       DEFAULT NULL COMMENT '上级栏目id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='APP快捷导航栏信息表';


-- `cloudt3-system`.sys_article_category definition

CREATE TABLE `sys_article_category`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `category_name`      varchar(64)  DEFAULT NULL COMMENT '分类名称',
    `sort_no`            int          DEFAULT NULL COMMENT '分类排序',
    `show_flag`          varchar(32)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `pid`                bigint       DEFAULT NULL COMMENT '父类id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `show_flag_no`       int          DEFAULT NULL COMMENT '是否显示序号',
    `root_id`            bigint       DEFAULT NULL COMMENT '一级分类id',
    `pid_list`           varchar(256) DEFAULT NULL COMMENT '父类id集合',
    PRIMARY KEY (`id`)
) COMMENT ='文章分类';


-- `cloudt3-system`.sys_article_info definition

CREATE TABLE `sys_article_info`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `article_author`     varchar(64)  DEFAULT NULL COMMENT '文章作者',
    `article_name`       varchar(256) DEFAULT NULL COMMENT '文章名称',
    `article_code`       varchar(64)  DEFAULT NULL COMMENT '文章编码',
    `sort_no`            int          DEFAULT NULL COMMENT '文章排序',
    `show_flag`          varchar(32)  DEFAULT NULL COMMENT '是否显示 HIDE-隐藏 DISPLAY-显示',
    `category_id`        bigint       DEFAULT NULL COMMENT '分类id',
    `category_name`      varchar(256) DEFAULT NULL COMMENT '分类名称',
    `article_detail`     longtext COMMENT '文章详情',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `file_code`          varchar(64)  DEFAULT NULL,
    `file_url`           varchar(256) DEFAULT NULL COMMENT '文章详情url',
    PRIMARY KEY (`id`)
) COMMENT ='文章信息';


-- `cloudt3-system`.sys_basic_record definition

CREATE TABLE `sys_basic_record`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `record_type`        varchar(255) DEFAULT NULL COMMENT '记录类型',
    `all_data`           bit(1)       DEFAULT b'0' COMMENT '是否全量',
    `data_version`       varchar(255) DEFAULT NULL COMMENT '数据版本',
    `data_type`          varchar(255) DEFAULT NULL COMMENT '数据类型',
    `tenant_code`        varchar(255) DEFAULT NULL COMMENT '租户编码',
    `description`        varchar(255) DEFAULT NULL COMMENT '说明',
    `data_file_code`     varchar(255) DEFAULT NULL COMMENT '数据文件',
    `attribute`          longtext COMMENT '属性列表',
    `operate_time`       datetime(6)  DEFAULT NULL COMMENT '操作时间',
    `success`            bit(1)       DEFAULT b'0' COMMENT '是否成功',
    `finished`           bit(1)       DEFAULT b'0' COMMENT '是否结束',
    `finish_time`        datetime(6)  DEFAULT NULL COMMENT '结束时间',
    `fail_reason`        longtext COMMENT '失败原因',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `all_type`           bit(1)       DEFAULT b'0' COMMENT '是否全量',
    `all_version`        bit(1)       DEFAULT b'0' COMMENT '是否全量',
    `sync_tenant`        bit(1)       DEFAULT b'0' COMMENT '是否同步给租户',
    `state`              varchar(255) DEFAULT NULL COMMENT '状态',
    `backup_file_code`   varchar(255) DEFAULT NULL COMMENT '备份文件',
    `std`                bit(1)       DEFAULT b'0' COMMENT '是否标产',
    `app_codes`          varchar(255) DEFAULT NULL COMMENT '导出应用',
    PRIMARY KEY (`id`)
) COMMENT ='基础数据同步记录';


-- `cloudt3-system`.sys_business_object definition

CREATE TABLE `sys_business_object`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_code`      varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `code`               varchar(255) DEFAULT NULL COMMENT '业务对象的编码',
    `name`               varchar(255) DEFAULT NULL COMMENT '业务对象的名称',
    `custom_name`        varchar(255) DEFAULT NULL COMMENT '自定义名称',
    `description`        varchar(255) DEFAULT NULL COMMENT '业务对象的描述',
    `entity_class_name`  varchar(255) DEFAULT NULL COMMENT 'entity类的名称',
    `domain`             varchar(255) DEFAULT NULL COMMENT '领域分类',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `data_source`        varchar(255) DEFAULT NULL COMMENT '数据来源',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `public_resource`    bit(1)       DEFAULT b'0' COMMENT '是否是公共资源',
    `support_tenant`     bit(1)       DEFAULT b'1' COMMENT '是否支持租户',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_business_obj_key` (`open_api_code`, `code`),
    KEY `idx_business_obj_openapi` (`open_api_code`),
    KEY `idx_business_obj_app` (`app_code`),
    KEY `idx_business_obj_code` (`code`),
    KEY `idx_business_obj_domain` (`domain`)
) COMMENT ='业务对象';


-- `cloudt3-system`.sys_business_object_ref definition

CREATE TABLE `sys_business_object_ref`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`        varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_id`   bigint       NOT NULL COMMENT '业务对象ID',
    `business_object_code` varchar(255) NOT NULL COMMENT '业务对象编码',
    `ref`                  varchar(255) NOT NULL COMMENT '关联标识',
    `ref_type`             varchar(255) NOT NULL COMMENT '关联类型',
    `sort_no`              int          DEFAULT '0' COMMENT '顺序',
    `data_source`          varchar(255) DEFAULT NULL COMMENT '数据来源',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_business_obj_ref_objid` (`business_object_id`),
    KEY `idx_business_obj_ref_objc` (`business_object_code`),
    KEY `idx_business_obj_ref_ref` (`ref`),
    KEY `idx_business_obj_ref_openapi` (`open_api_code`)
) COMMENT ='业务对象的关联关系';


-- `cloudt3-system`.sys_business_operation definition

CREATE TABLE `sys_business_operation`
(
    `id`                           bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`                varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_code`         varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_object_id`           bigint       NOT NULL COMMENT '业务对象ID',
    `app_code`                     varchar(255) DEFAULT NULL COMMENT '应用编码',
    `operation_code`               varchar(255) NOT NULL COMMENT '操作编码',
    `operation_description`        varchar(255) DEFAULT NULL COMMENT '操作描述',
    `custom_name`                  varchar(255) DEFAULT NULL COMMENT '自定义名称',
    `detail`                       varchar(255) DEFAULT NULL COMMENT '详细描述',
    `permission_ref`               varchar(255) DEFAULT NULL COMMENT '关联权限的业务操作编码',
    `operation_type`               varchar(255) DEFAULT NULL COMMENT '操作类型',
    `permission_enabled`           bit(1)       DEFAULT b'0' COMMENT '是否启用权限',
    `field_permission_auto_filter` bit(1)       DEFAULT b'0' COMMENT '是否自动过滤字段权限',
    `scope`                        varchar(255) DEFAULT NULL COMMENT '操作范围',
    `state`                        varchar(255) DEFAULT NULL COMMENT '操作状态',
    `display_type`                 varchar(255) DEFAULT NULL COMMENT '显示类型',
    `display_style`                varchar(255) DEFAULT NULL COMMENT '显示样式',
    `display_condition`            varchar(255) DEFAULT NULL COMMENT '显示条件',
    `display_icon`                 varchar(255) DEFAULT NULL COMMENT '显示图标',
    `display_order`                int          DEFAULT NULL COMMENT '显示顺序',
    `api_name`                     varchar(255) DEFAULT NULL COMMENT 'API操作名称',
    `api_description`              varchar(255) DEFAULT NULL COMMENT 'API描述',
    `api_url`                      varchar(255) DEFAULT NULL COMMENT 'API的URL',
    `api_method`                   varchar(255) DEFAULT NULL COMMENT 'API的方法',
    `data_source`                  varchar(255) DEFAULT NULL COMMENT '数据来源',
    `enabled`                      bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`                    bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                       varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`               bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                      varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                  datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`               bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                      varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                  datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                  int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`           int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                    bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                  bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                    bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `permission_field_names`       longtext COMMENT '权限字段，多个以逗号分隔',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_business_objopera_key` (`operation_code`),
    KEY `idx_business_objopera_openapi` (`open_api_code`),
    KEY `idx_business_objopera_busiobj` (`business_object_id`),
    KEY `idx_business_objopera_code` (`operation_code`),
    KEY `idx_business_objopera_app` (`app_code`),
    KEY `idx_business_objopera_busiobjc` (`business_object_code`),
    KEY `idx_business_objopera_type` (`operation_type`),
    KEY `idx_business_objopera_perms` (`permission_enabled`),
    KEY `idx_business_objopera_ref` (`permission_ref`)
) COMMENT ='业务对象的操作';


-- `cloudt3-system`.sys_business_operation_param definition

CREATE TABLE `sys_business_operation_param`
(
    `id`                      bigint NOT NULL COMMENT '记录唯一ID',
    `business_object_id`      bigint NOT NULL COMMENT '业务对象ID',
    `business_object_code`    varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_operation_id`   bigint NOT NULL COMMENT '业务对象操作ID',
    `business_operation_code` varchar(255) DEFAULT NULL COMMENT '业务对象操作编码',
    `open_api_code`           varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `open_api_operation_code` varchar(255) DEFAULT NULL COMMENT 'OpenApi的操作编码',
    `field_name`              varchar(255) DEFAULT NULL COMMENT '字段名称',
    `field_description`       varchar(255) DEFAULT NULL COMMENT '字段描述',
    `request`                 bit(1)       DEFAULT b'1' COMMENT '是否为请求参数',
    `field_type`              varchar(255) DEFAULT NULL COMMENT '字段类型',
    `field_java_type`         varchar(255) DEFAULT NULL COMMENT '字段类型(java)',
    `ref`                     bit(1)       DEFAULT NULL COMMENT '是否有依赖',
    `ref_value`               varchar(255) DEFAULT NULL COMMENT '依赖地址',
    `depth`                   int          DEFAULT NULL COMMENT '参数深度',
    `param_path`              varchar(255) DEFAULT NULL COMMENT '参数路径',
    `api_result`              bit(1)       DEFAULT b'0' COMMENT '是否是ApiResult的参数',
    `paging_result`           bit(1)       DEFAULT b'0' COMMENT '是否是PagingVO的参数',
    `required`                bit(1)       DEFAULT b'0' COMMENT '是否必须',
    `deprecated`              bit(1)       DEFAULT b'0' COMMENT '是否已过期',
    `param_in`                varchar(255) DEFAULT NULL COMMENT '参数位置',
    `single`                  bit(1)       DEFAULT b'0' COMMENT '是否是单值',
    `collection_type`         varchar(255) DEFAULT NULL COMMENT '集合类型',
    `data_source`             varchar(255) DEFAULT NULL COMMENT '数据来源',
    `enabled`                 bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`               bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`           bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`           bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                  varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`          bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                 varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`             datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`          bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                 varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`             datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`             int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`      int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`               bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`             bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`               bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `field_permission_filter` bit(1)       DEFAULT NULL COMMENT '是否过滤权限字段',
    PRIMARY KEY (`id`),
    KEY `idx_business_opera_param_openapi` (`open_api_code`),
    KEY `idx_business_opera_param_obj` (`business_object_id`),
    KEY `idx_business_opera_param_operation` (`business_operation_id`)
) COMMENT ='业务操作的参数';


-- `cloudt3-system`.sys_business_param definition

CREATE TABLE `sys_business_param`
(
    `id`                          bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`               varchar(255) DEFAULT NULL COMMENT 'OpenApi的编码',
    `business_object_id`          bigint       NOT NULL COMMENT '业务对象ID',
    `business_object_code`        varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `business_operation_id`       bigint       DEFAULT NULL COMMENT '业务操作ID',
    `business_operation_code`     varchar(255) DEFAULT NULL COMMENT '业务操作编码',
    `business_operation_param_id` bigint       DEFAULT NULL COMMENT '业务操作参数ID',
    `enabled`                     bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `entity_field`                bit(1)       DEFAULT b'0' COMMENT '是否为entity类的字段',
    `entity_class_name`           varchar(255) DEFAULT NULL COMMENT 'entity类的名称',
    `table_name`                  varchar(255) DEFAULT NULL COMMENT '表名',
    `field_name`                  varchar(255) NOT NULL COMMENT '字段名称',
    `column_name`                 varchar(255) DEFAULT NULL COMMENT '列名称',
    `field_description`           varchar(255) DEFAULT NULL COMMENT '字段描述',
    `custom_description`          varchar(255) DEFAULT NULL COMMENT '自定义描述',
    `field_java_type`             varchar(255) DEFAULT NULL COMMENT '字段类型(java)',
    `nullable`                    bit(1)       DEFAULT b'1' COMMENT '是否可为空',
    `single`                      bit(1)       DEFAULT b'1' COMMENT '是否单值',
    `enumeration`                 bit(1)       DEFAULT b'0' COMMENT '是否枚举类',
    `enum_type`                   varchar(255) DEFAULT NULL COMMENT '枚举值类型',
    `sort_no`                     int          DEFAULT '0' COMMENT '顺序',
    `related_business_object`     varchar(255) DEFAULT NULL COMMENT '关联业务对象标识',
    `related_field`               varchar(255) DEFAULT NULL COMMENT '关联业务对象字段',
    `values_json`                 longtext COMMENT '值列表',
    `user_type`                   varchar(255) DEFAULT NULL COMMENT '账号类型',
    `data_permission_enabled`     bit(1)       DEFAULT b'1' COMMENT '是否应于数据权限过滤',
    `field_permission_enabled`    bit(1)       DEFAULT b'1' COMMENT '是否应于字段权限过滤',
    `base_field`                  bit(1)       DEFAULT b'1' COMMENT '是否为基础字段',
    `deprecated`                  bit(1)       DEFAULT b'0' COMMENT '是否过期',
    `tenant_id`                   bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`               bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`               bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                      varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`              bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                     varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                 datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`              bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                     varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                 datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                 int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`          int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                   bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                 bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                   bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_business_param_openapi` (`open_api_code`),
    KEY `idx_business_param_obj` (`business_object_id`),
    KEY `idx_business_param_operation` (`business_operation_id`)
) COMMENT ='业务对象的参数';


-- `cloudt3-system`.sys_common_search definition

CREATE TABLE `sys_common_search`
(
    `id`                    bigint NOT NULL COMMENT '记录唯一ID',
    `common_search_id`      varchar(32)   DEFAULT NULL COMMENT '通查ID',
    `common_search_name`    varchar(32)   DEFAULT NULL COMMENT '通查名称',
    `common_search_content` varchar(512)  DEFAULT NULL COMMENT '通查内容',
    `common_search_param`   varchar(512)  DEFAULT NULL COMMENT '通查参数',
    `connection_name`       varchar(256)  DEFAULT NULL COMMENT '连接名字',
    `database_type`         varchar(16)   DEFAULT NULL COMMENT '数据库类型',
    `cache_flag`            tinyint(1)    DEFAULT '0' COMMENT '是否缓存：1是，0否',
    `cache_live_time`       decimal(8, 0) DEFAULT NULL COMMENT '缓存存活时间',
    `sub_search`            varchar(64)   DEFAULT NULL COMMENT '子查询',
    `tenant_id`             bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int           DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `user_name`             varchar(32)   DEFAULT NULL COMMENT '用户名',
    `password`              varchar(32)   DEFAULT NULL COMMENT '密码',
    PRIMARY KEY (`id`)
) COMMENT ='通用查询';


-- `cloudt3-system`.sys_currency_rate definition

CREATE TABLE `sys_currency_rate`
(
    `id`                 bigint         NOT NULL COMMENT '记录唯一ID',
    `from_curr`          varchar(255)   NOT NULL COMMENT '自货币码',
    `to_curr`            varchar(255)   NOT NULL COMMENT '至货币码',
    `ratio`              decimal(20, 8) NOT NULL COMMENT '汇率',
    `cal_method`         varchar(255)   NOT NULL COMMENT '算法',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `valid_from`         datetime(6)  DEFAULT NULL COMMENT '有效时间-起始',
    `valid_to`           datetime(6)  DEFAULT NULL COMMENT '有效时间-截止',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `idx_currency_rate_from` (`from_curr`)
) COMMENT ='汇率';


-- `cloudt3-system`.sys_custom_field_definition definition

CREATE TABLE `sys_custom_field_definition`
(
    `id`                                   bigint       NOT NULL COMMENT '记录唯一ID',
    `business_object_code`                 varchar(255) NOT NULL COMMENT '标识此字段所属的业务对象编码',
    `basic_module_code`                    varchar(255) NOT NULL COMMENT '标识此字段所属的模块或实体',
    `basic_name`                           varchar(255) NOT NULL COMMENT '用户界面显示的字段名',
    `basic_localized_name`                 varchar(255) DEFAULT NULL COMMENT '支持多语言环境下的字段名称',
    `basic_key`                            varchar(255) NOT NULL COMMENT '数据库和API中使用的唯一键名',
    `basic_type`                           varchar(255) NOT NULL COMMENT '字段的数据类型',
    `basic_description`                    varchar(255) DEFAULT NULL COMMENT '字段用途或输入要求的描述信息。',
    `basic_default_value`                  varchar(255) DEFAULT NULL COMMENT '创建实体时的默认值',
    `basic_required`                       bit(1)       DEFAULT NULL COMMENT '指示字段在创建或更新实体时是否必填',
    `basic_display_order`                  int          DEFAULT NULL COMMENT '前端显示的排序顺序',
    `basic_status`                         varchar(255) DEFAULT NULL COMMENT '字段是否启用',
    `display_type`                         varchar(255) DEFAULT NULL COMMENT '展示类型指明了字段在前端UI中的展示方式',
    `display_options_json`                 json         DEFAULT NULL COMMENT '选项值，仅对枚举类型的字段适用，存储为JSON字符串',
    `display_multivalue`                   bit(1)       DEFAULT NULL COMMENT '指示字段是否可以包含多个值',
    `display_group`                        varchar(255) DEFAULT NULL COMMENT '字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性',
    `display_readonly`                     bit(1)       DEFAULT NULL COMMENT '只读属性指示字段在UI中是否只能被显示而不能被修改',
    `display_visibility_condition_json`    json         DEFAULT NULL COMMENT '控制字段在UI中的可见性的条件，存储为JSON字符串',
    `display_ui_attributes_json`           json         DEFAULT NULL COMMENT ' UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串',
    `display_linked_entity`                varchar(255) DEFAULT NULL COMMENT '关联实体类型和关系。如果字段值指向另一个实体，该属性定义了所关联的实体类型。',
    `display_dynamic_attributes_json`      json         DEFAULT NULL COMMENT '动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串',
    `display_dependent_fields_json`        json         DEFAULT NULL COMMENT '依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。',
    `config_web_validation_pattern`        longtext COMMENT '前端校验模式数据存储',
    `config_web_extended_data`             longtext COMMENT '前端扩展数据存储',
    `config_web_function`                  longtext COMMENT '前端函数存储',
    `config_searchable`                    bit(1)       DEFAULT NULL COMMENT '可搜索属性标记字段是否可以被用作搜索条件',
    `config_sortable`                      bit(1)       DEFAULT NULL COMMENT '可排序属性指示字段是否可以用作列表排序的依据',
    `config_import_export`                 bit(1)       DEFAULT NULL COMMENT '导入导出属性标记字段是否应包含在数据导入导出操作中',
    `config_access_control_json`           longtext COMMENT '权限控制，存储为JSON字符串',
    `config_track_history`                 bit(1)       DEFAULT NULL COMMENT '历史记录属性指示是否追踪字段值的变更历史',
    `config_encrypted`                     bit(1)       DEFAULT NULL COMMENT '数据加密属性标记',
    `config_sensitive`                     bit(1)       DEFAULT NULL COMMENT '敏感数据标记',
    `config_autocomplete_suggestions_json` json         DEFAULT NULL COMMENT '自动填充建议属性',
    `tenant_id`                            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`                       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`                   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `basic_default_type`                   varchar(255) DEFAULT NULL COMMENT '创建实体时的默认值类型，填写当时，自定义，数据联动，公式',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_custom_business_object_code` (`business_object_code`) USING BTREE,
    KEY `idx_custom_basic_module_code` (`basic_module_code`) USING BTREE,
    KEY `idx_custom_basic_key` (`basic_key`) USING BTREE,
    KEY `idx_custom_basic_type` (`basic_type`) USING BTREE,
    KEY `idx_custom_basic_status` (`basic_status`) USING BTREE,
    KEY `idx_custom_display_type` (`display_type`) USING BTREE,
    KEY `idx_custom_config_searchable` (`config_searchable`) USING BTREE,
    KEY `idx_custom_config_sortable` (`config_sortable`) USING BTREE,
    KEY `idx_custom_config_import_export` (`config_import_export`) USING BTREE
) ROW_FORMAT = DYNAMIC COMMENT ='自定义字段定义表';


-- `cloudt3-system`.sys_data_relation definition

CREATE TABLE `sys_data_relation`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '关系编码',
    `name`               varchar(255) NOT NULL COMMENT '关系名称',
    `bo_code`            varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `ref_bo_code`        varchar(255) DEFAULT NULL COMMENT '关联的业务对象编码',
    `data_selector_code` varchar(255) DEFAULT NULL COMMENT '数据选择器编码',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_datarelation_code` (`code`)
) COMMENT ='数据关系';


-- `cloudt3-system`.sys_data_relation_cat definition

CREATE TABLE `sys_data_relation_cat`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `dr_code`            varchar(255) NOT NULL COMMENT '数据关系编码',
    `cat_code`           varchar(255) NOT NULL COMMENT '分类编码',
    `cat_name`           varchar(255) NOT NULL COMMENT '分类名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_datarelation_cat_dr` (`dr_code`)
) COMMENT ='数据关系的分类';


-- `cloudt3-system`.sys_data_relation_inst definition

CREATE TABLE `sys_data_relation_inst`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `dr_code`            varchar(255) NOT NULL COMMENT '数据关系编码',
    `cat_code`           varchar(255) DEFAULT NULL COMMENT '分类编码',
    `data_key`           varchar(255) DEFAULT NULL COMMENT '主数据的标识',
    `data_attribute`     varchar(255) DEFAULT NULL COMMENT '主数据的检索属性',
    `data_ext_json`      longtext COMMENT '主数据的扩展信息',
    `ref_data_key`       varchar(255) DEFAULT NULL COMMENT '关联数据的标识',
    `ref_data_attribute` varchar(255) DEFAULT NULL COMMENT '关联数据的检索属性',
    `ref_data_ext_json`  longtext COMMENT '关联数据的扩展信息',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_datarelation_inst_dr` (`dr_code`),
    KEY `idx_datarelation_inst_datak` (`data_key`),
    KEY `idx_datarelation_inst_cat` (`cat_code`),
    KEY `idx_datarelation_inst_attr` (`data_attribute`),
    KEY `idx_datarelation_inst_datakr` (`ref_data_key`)
) COMMENT ='业务对象与数据关联的配置';


-- `cloudt3-system`.sys_data_selector definition

CREATE TABLE `sys_data_selector`
(
    `id`                  bigint       NOT NULL COMMENT '记录唯一ID',
    `group_code`          varchar(255) DEFAULT NULL COMMENT '分组编码',
    `selector_code`       varchar(255) NOT NULL COMMENT '选择器编码',
    `selector_name`       varchar(255) DEFAULT NULL COMMENT '选择器名称',
    `enabled`             bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `component`           bit(1)       DEFAULT b'0' COMMENT '是否是公共组件',
    `component_code`      varchar(255) DEFAULT NULL COMMENT '组件编码',
    `data_api`            varchar(255) DEFAULT NULL COMMENT '数据接口API',
    `data_api_method`     varchar(255) DEFAULT NULL COMMENT '数据接口请求方式',
    `data_style`          varchar(255) DEFAULT NULL COMMENT '数据格式',
    `api_headers_json`    longtext COMMENT '数据接口请求头',
    `api_req_body_json`   longtext COMMENT '数据接口请求体',
    `api_req_params_json` longtext COMMENT '数据接口查询参数',
    `data_fields_str`     varchar(255) DEFAULT NULL COMMENT '使用的数据字段',
    `value_num_limit`     int          DEFAULT '-1' COMMENT '值数量限制',
    `ext_attributes_json` longtext COMMENT '扩展属性',
    `tenant_id`           bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_dataselect_group` (`group_code`),
    KEY `idx_dataselect_code` (`selector_code`)
) COMMENT ='数据选择器';


-- `cloudt3-system`.sys_data_selector_group definition

CREATE TABLE `sys_data_selector_group`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `group_code`         varchar(255) NOT NULL COMMENT '分组编码',
    `group_name`         varchar(255) NOT NULL COMMENT '分组名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '启用状态',
    `sort_no`            int          DEFAULT '0' COMMENT '排序',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='数据选择器分组';


-- `cloudt3-system`.sys_database_service_tenant definition

CREATE TABLE `sys_database_service_tenant`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `dbs_name`           varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_driver_class`   varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_url`            varchar(500) NOT NULL COMMENT '数据库链接字符串',
    `dbs_db_name`        varchar(255) NOT NULL COMMENT '数据库名称',
    `dbs_db_port`        varchar(255) NOT NULL COMMENT '数据库端口',
    `dbs_username`       varchar(255) NOT NULL COMMENT '账号',
    `dbs_password`       varchar(255) NOT NULL COMMENT '密码',
    `service_code`       varchar(255) NOT NULL COMMENT '服务编码',
    `tenant_code`        varchar(255) NOT NULL COMMENT '数据源租户编码',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `dbs_netaddress`     varchar(255) DEFAULT NULL COMMENT '服务器地址',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT ='服务租户数据源配置';


-- `cloudt3-system`.sys_database_source definition

CREATE TABLE `sys_database_source`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `dbs_name`           varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_driver_class`   varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_url`            varchar(500) NOT NULL COMMENT '连接地址',
    `dbs_username`       varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_password`       varchar(255) NOT NULL COMMENT '驱动类',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `service_code`       varchar(100) NOT NULL COMMENT '数据源所属服务编码',
    `tenant_code`        varchar(100) DEFAULT NULL COMMENT '数据源归属租户编码',
    `dbs_db_name`        varchar(255) DEFAULT NULL COMMENT '数据库名称',
    `dbs_db_port`        varchar(255) DEFAULT NULL COMMENT '数据库端口',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT ='数据源表';


-- `cloudt3-system`.sys_dpcr_api_fields definition

CREATE TABLE `sys_dpcr_api_fields`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint       DEFAULT NULL COMMENT '角色id',
    `menu_code`          varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `field_name`         varchar(255) DEFAULT NULL COMMENT '字段名称',
    `field_remark`       varchar(255) DEFAULT NULL COMMENT '字段描述',
    `field_api_visible`  bit(1)       DEFAULT NULL COMMENT 'api可见',
    `field_form_visible` bit(1)       DEFAULT NULL COMMENT '表单可见',
    `field_form_update`  bit(1)       DEFAULT NULL COMMENT '表单可编辑',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `api_code`           varchar(255) DEFAULT NULL COMMENT '接口编码',
    PRIMARY KEY (`id`),
    KEY `idx_dpcr_api_field_role` (`role_id`),
    KEY `idx_dpcr_api_field_app` (`app_code`),
    KEY `idx_dpcr_api_field_menu` (`menu_code`),
    KEY `idx_dpcr_api_field_api` (`api_code`)
) COMMENT ='角色-应用-菜单-API-列权限字段权限字符串表 ';


-- `cloudt3-system`.sys_dpr_role_api_rule definition

CREATE TABLE `sys_dpr_role_api_rule`
(
    `id`                        bigint NOT NULL COMMENT '记录唯一ID',
    `role_id`                   bigint        DEFAULT NULL COMMENT '角色id',
    `menu_code`                 varchar(255)  DEFAULT NULL COMMENT '菜单编码',
    `dpr_rule_group_id`         bigint        DEFAULT NULL COMMENT '行规则组id',
    `dpr_rule_id`               bigint        DEFAULT NULL COMMENT '行规则id',
    `role_rule_value`           varchar(2000) DEFAULT NULL COMMENT '自定义值',
    `role_rule_value_type`      varchar(200)  DEFAULT NULL COMMENT '自定义值填写类型（组件，自填）',
    `rule_order`                double        DEFAULT NULL COMMENT '规则排序',
    `rule_do_json`              longtext COMMENT '原始规则Json',
    `tenant_id`                 bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`             bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`             bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`                    varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`            bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                   varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`               datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`            bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                   varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`               datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`               int           DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`        int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                 bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`               bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                 bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `dpr_rule_relation`         varchar(200)  DEFAULT NULL COMMENT '规则关系',
    `dpr_rule_relation_name`    varchar(200)  DEFAULT NULL COMMENT '规则关系名称',
    `dpr_rule_name`             varchar(200)  DEFAULT NULL COMMENT '规则名称',
    `dpr_rule_declare`          varchar(2000) DEFAULT NULL COMMENT '规则描述',
    `dpr_rule_field`            varchar(100)  DEFAULT NULL COMMENT '规则字段',
    `dpr_rule_field_type`       varchar(100)  DEFAULT NULL COMMENT '规则字段类型',
    `dpr_rule_field_type_name`  varchar(200)  DEFAULT NULL COMMENT '规则条件类型名称',
    `dpr_rule_field_declare`    varchar(2000) DEFAULT NULL COMMENT '规则字段描述',
    `dpr_rule_condition`        varchar(200)  DEFAULT NULL COMMENT '规则条件类型',
    `dpr_rule_condition_name`   varchar(200)  DEFAULT NULL COMMENT '规则条件类型名称',
    `dpr_rule_value_type`       varchar(200)  DEFAULT NULL COMMENT '规则值类型',
    `dpr_rule_value_type_name`  varchar(200)  DEFAULT NULL COMMENT '规则值类型名称',
    `dpr_rule_value`            varchar(2000) DEFAULT NULL COMMENT '规则值',
    `dpr_rule_value_declare`    varchar(2000) DEFAULT NULL COMMENT '规则值说明',
    `dpr_sys_internally`        varchar(200)  DEFAULT NULL COMMENT '系统上下文内置类型枚举',
    `dpr_sys_internally_name`   varchar(200)  DEFAULT NULL COMMENT '系统上下文内置类型名称',
    `dpr_role_custom_app`       varchar(200)  DEFAULT NULL COMMENT '角色自定义选择组件',
    `dpr_role_custom_app_name`  varchar(200)  DEFAULT NULL COMMENT '角色自定义选择组件名称',
    `dpr_rule_group_rule_order` float         DEFAULT NULL COMMENT '排序',
    `app_code`                  varchar(255)  DEFAULT NULL COMMENT '应用编码',
    `api_code`                  varchar(255)  DEFAULT NULL COMMENT 'Api Code',
    `data_range`                bit(1)        DEFAULT NULL COMMENT '是否是数据范围',
    `dpr_rule_value_name`       varchar(255)  DEFAULT NULL COMMENT '规则值名称',
    `data_set`                  varchar(255)  DEFAULT NULL COMMENT '数据集类型',
    `bs1`                       longtext COMMENT '特用字段1',
    `bs2`                       longtext COMMENT '特用字段2',
    `bs3`                       longtext COMMENT '特用字段3',
    PRIMARY KEY (`id`),
    KEY `idx_dpr_row_role` (`role_id`),
    KEY `idx_dpr_row_app` (`app_code`),
    KEY `idx_dpr_row_menu` (`menu_code`),
    KEY `idx_dpr_row_api` (`api_code`)
) COMMENT ='角色-应用-菜单-API-行规则';


-- `cloudt3-system`.sys_emp_group definition

CREATE TABLE `sys_emp_group`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '员工组编号',
    `name`               varchar(255) NOT NULL COMMENT '员工组名称',
    `type`               varchar(255) DEFAULT NULL COMMENT '类型，[UDC]cloudt-system:empGroupType',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_emp_group_code` (`code`),
    KEY `idx_emp_group_type` (`type`)
) COMMENT ='员工组';


-- `cloudt3-system`.sys_emp_group_emp definition

CREATE TABLE `sys_emp_group_emp`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `group_id`           bigint NOT NULL COMMENT '员工组ID',
    `emp_id`             bigint NOT NULL COMMENT '员工ID',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_emp_group_emp_g` (`group_id`),
    KEY `idx_emp_group_emp_e` (`emp_id`)
) COMMENT ='员工组的员工';


-- `cloudt3-system`.sys_employee definition

CREATE TABLE `sys_employee`
(
    `id`                  bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`           bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`             bigint NOT NULL COMMENT '用户账号ID',
    `root_org_id`         bigint NOT NULL COMMENT '根组织ID',
    `last_name`           varchar(255) DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`          varchar(255) DEFAULT NULL COMMENT '姓名-名字',
    `gender`              varchar(255) DEFAULT NULL COMMENT '性别，（male-男，female-女，secret-保密）',
    `code`                varchar(255) DEFAULT NULL COMMENT '员工编号',
    `email`               varchar(255) DEFAULT NULL COMMENT '工作邮箱',
    `phone`               varchar(255) DEFAULT NULL COMMENT '办公电话',
    `join_time`           datetime(6)  DEFAULT NULL COMMENT '入职时间',
    `leave_time`          datetime(6)  DEFAULT NULL COMMENT '离职时间',
    `type`                varchar(255) DEFAULT NULL COMMENT '员工类型，[UDC]EMPLOYEE:TYPE',
    `photo`               varchar(255) DEFAULT NULL COMMENT '员工照片',
    `contract_start_time` datetime(6)  DEFAULT NULL COMMENT '合同起始时间',
    `contract_end_time`   datetime(6)  DEFAULT NULL COMMENT '合同截止时间',
    `enabled`             bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `sort_no`             int          DEFAULT '1' COMMENT '顺序',
    `served`              bit(1)       DEFAULT b'1' COMMENT '是否在职',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `duty`                varchar(255) DEFAULT NULL COMMENT '职务',
    `username`            varchar(255) DEFAULT NULL COMMENT '用户账号',
    `nick_name`           varchar(255) DEFAULT NULL COMMENT '昵称',
    `birth_date`          date         DEFAULT NULL COMMENT '生日',
    `email_work`          varchar(255) DEFAULT NULL COMMENT '工作邮箱',
    `mobile`              varchar(255) DEFAULT NULL COMMENT '手机号',
    `id_card`             varchar(255) DEFAULT NULL COMMENT '身份证号',
    `province_code`       varchar(255) DEFAULT NULL COMMENT '省编码',
    `city_code`           varchar(255) DEFAULT NULL COMMENT '市编码',
    `county_code`         varchar(255) DEFAULT NULL COMMENT '县编码',
    `address`             varchar(255) DEFAULT NULL COMMENT '详细地址',
    `personal_sign`       varchar(255) DEFAULT NULL COMMENT '个性签名',
    `avatar_url`          longtext COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`         varchar(255) DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `country_code`        varchar(255) DEFAULT NULL COMMENT '国家编码',
    `extension_info`      json         DEFAULT NULL,
    `custom_fields`       json         DEFAULT NULL COMMENT '自定义json字段',
    PRIMARY KEY (`id`),
    KEY `idx_sys_emp_user_id` (`user_id`),
    KEY `idx_sys_emp_root_org_id` (`root_org_id`),
    KEY `idx_sys_emp_code` (`code`),
    KEY `idx_sys_emp_type` (`type`),
    KEY `idx_sys_emp_email` (`email`)
) COMMENT ='员工';


-- `cloudt3-system`.sys_employee_org definition

CREATE TABLE `sys_employee_org`
(
    `id`                 bigint      NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint      NOT NULL COMMENT '用户账号ID',
    `employee_id`        bigint      NOT NULL COMMENT '员工ID',
    `root_org_id`        bigint      NOT NULL COMMENT '所属根组织ID',
    `org_id`             bigint      NOT NULL COMMENT '所属组织ID',
    `join_time`          datetime(6) NOT NULL COMMENT '加入时间',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `leader_user_id`     bigint       DEFAULT NULL COMMENT '领导用户ID',
    `leader_employee_id` bigint       DEFAULT NULL COMMENT '领导的员工ID',
    `extension_info`     json         DEFAULT NULL,
    `def`                bit(1)       DEFAULT NULL COMMENT '是否是默认组织',
    `position_id`        bigint       DEFAULT NULL COMMENT '员工所在组织的岗位ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_emp_org_user_id` (`user_id`),
    KEY `idx_sys_emp_org_emp_id` (`employee_id`),
    KEY `idx_sys_emp_org_root_org_id` (`root_org_id`),
    KEY `idx_sys_emp_org_org_id` (`org_id`),
    KEY `idx_sys_emp_org_leader` (`leader_user_id`),
    KEY `idx_emp_org_leader_emp` (`leader_employee_id`)
) COMMENT ='员工组织';


-- `cloudt3-system`.sys_file_info definition

CREATE TABLE `sys_file_info`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `url`                varchar(255) DEFAULT NULL COMMENT '链接',
    `file_code`          varchar(255) DEFAULT NULL COMMENT '编码',
    `source_id`          bigint       DEFAULT NULL COMMENT '来源id',
    `source_type`        varchar(255) DEFAULT NULL COMMENT '来源类型',
    `file_name`          varchar(255) DEFAULT NULL COMMENT '文件名称',
    `old_file_name`      varchar(255) DEFAULT NULL COMMENT '原始文件名称',
    `file_size`          varchar(255) DEFAULT NULL COMMENT '文件大小',
    `file_info`          varchar(255) DEFAULT NULL COMMENT '文件内容',
    `original_name`      varchar(256) DEFAULT NULL COMMENT '文件原名称',
    `suffix`             varchar(256) DEFAULT NULL COMMENT '文件名后缀',
    `mime_type`          varchar(256) DEFAULT NULL COMMENT '文件内容类型',
    `file_type`          varchar(256) DEFAULT NULL COMMENT '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见',
    `upload_time`        datetime(6)  DEFAULT NULL COMMENT '上传时间',
    `file_path`          varchar(256) DEFAULT NULL COMMENT '文件路径',
    `width`              int          DEFAULT NULL COMMENT '宽度，图片时有值',
    `height`             int          DEFAULT NULL COMMENT '高度，图片时有值',
    `url_preview`        varchar(256) DEFAULT NULL COMMENT '文件预览url',
    `uri_down_load`      varchar(256) DEFAULT NULL COMMENT '文件下载uri',
    `url_delete`         varchar(256) DEFAULT NULL COMMENT '文件删除url',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='文件信息';


-- `cloudt3-system`.sys_front_table_cfg definition

CREATE TABLE `sys_front_table_cfg`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `table_code`         varchar(255) NOT NULL COMMENT '表格编码',
    `owner_id`           bigint       NOT NULL COMMENT '拥有者ID',
    `owner_type`         varchar(255) NOT NULL COMMENT '拥有者类型',
    `config`             longtext COMMENT '配置内容',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_front_table_cfg_code` (`table_code`),
    KEY `idx_front_table_cfg_owner` (`owner_id`)
) COMMENT ='前端表格配置';


-- `cloudt3-system`.sys_id_generator definition

CREATE TABLE `sys_id_generator`
(
    `id`               varchar(255) NOT NULL COMMENT '主键ID',
    `gen_type`         varchar(255) NOT NULL COMMENT '生成器类型',
    `data_center_name` varchar(255) NOT NULL COMMENT '数据中心名称',
    `data_center_id`   int          NOT NULL COMMENT '数据中心ID',
    `worker_id`        int          NOT NULL COMMENT 'WorkerID',
    `instance_ip`      varchar(255) DEFAULT NULL COMMENT '实例IP',
    `create_time`      datetime(6)  DEFAULT NULL COMMENT '创建时间',
    `modify_time`      datetime(6)  DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_id_gen_uid` (`data_center_id`, `worker_id`),
    KEY `idx_id_gen_dcname` (`data_center_name`)
);


-- `cloudt3-system`.sys_menu_favor definition

CREATE TABLE `sys_menu_favor`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint       NOT NULL COMMENT '用户ID',
    `menu_code`          varchar(255) NOT NULL COMMENT '原菜单编码',
    `menu_name`          varchar(255) DEFAULT NULL COMMENT '显示名称',
    `sort_no`            int          DEFAULT '0' COMMENT '排序号',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_menu_favor_user` (`user_id`)
) COMMENT ='收藏菜单';


-- `cloudt3-system`.sys_menu_operation definition

CREATE TABLE `sys_menu_operation`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) NOT NULL COMMENT '菜单编码',
    `operation_code`     varchar(255) DEFAULT NULL COMMENT '业务操作编码',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_menu_operation_app` (`app_code`),
    KEY `idx_menu_operation_menu` (`menus_code`),
    KEY `idx_menu_operation_opera` (`operation_code`)
) COMMENT ='菜单与业务对象操作的关联';


-- `cloudt3-system`.sys_message_info definition

CREATE TABLE `sys_message_info`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `message_title`      varchar(256) DEFAULT NULL COMMENT '消息标题',
    `category_code`      varchar(256) DEFAULT NULL COMMENT '消息分类code',
    `publish_status`     char(1)      DEFAULT NULL COMMENT '发布状态 0-未发布 1-已发布',
    `message_detail`     longtext COMMENT '消息描述',
    `file_code`          varchar(256) DEFAULT NULL COMMENT '附件编码，文件服务器上的文件唯一标识',
    `total_count`        int          DEFAULT NULL COMMENT '总人数',
    `read_count`         int          DEFAULT '0' COMMENT '已阅读人数',
    `read_process`       varchar(16)  DEFAULT NULL COMMENT '阅读进度',
    `publish_time`       datetime     DEFAULT NULL COMMENT '发布时间',
    `record_id`          varchar(256) DEFAULT NULL COMMENT '消息记录标识',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `file_name`          varchar(256) DEFAULT NULL COMMENT '附件名称',
    PRIMARY KEY (`id`)
) COMMENT ='消息信息';


-- `cloudt3-system`.sys_message_receiver definition

CREATE TABLE `sys_message_receiver`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `message_id`         bigint       DEFAULT NULL COMMENT '消息id',
    `emp_id`             bigint       DEFAULT NULL COMMENT '员工id',
    `emp_no`             varchar(64)  DEFAULT NULL COMMENT '账号',
    `emp_name`           varchar(64)  DEFAULT NULL COMMENT '员工姓名',
    `mobile`             varchar(64)  DEFAULT NULL COMMENT '手机号',
    `dept_name`          varchar(64)  DEFAULT NULL COMMENT '部门名称',
    `read_status`        char(1)      DEFAULT NULL COMMENT '-1-草稿 0-未阅读 1-已阅读 阅读状态',
    `read_time`          datetime     DEFAULT NULL COMMENT '阅读时间',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='消息接收者信息';


-- `cloudt3-system`.sys_mq_consume definition

CREATE TABLE `sys_mq_consume`
(
    `id`                  bigint NOT NULL COMMENT '记录唯一ID',
    `message_id`          varchar(255) DEFAULT NULL COMMENT '消息ID',
    `record_id`           bigint       DEFAULT NULL COMMENT '消息记录ID',
    `app_code`            varchar(255) DEFAULT NULL COMMENT '应用编码',
    `consumer_name`       varchar(255) DEFAULT NULL COMMENT '消费者名称',
    `consumer_ip`         varchar(255) DEFAULT NULL COMMENT '消费者IP',
    `consume_time`        datetime(6)  DEFAULT NULL COMMENT '消费时间',
    `success`             bit(1)       DEFAULT b'0' COMMENT '是否消费成功',
    `fail_reason`         longtext COMMENT '消费失败原因',
    `original_message_id` varchar(255) DEFAULT NULL COMMENT '原始消息ID',
    `tenant_id`           bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `cost_time`           bigint       DEFAULT NULL COMMENT '消费耗时，单位毫秒',
    PRIMARY KEY (`id`),
    KEY `idx_mq_con_msgid` (`message_id`),
    KEY `idx_mq_con_recod` (`record_id`)
) COMMENT ='MQ消息消费记录';


-- `cloudt3-system`.sys_mq_message definition

CREATE TABLE `sys_mq_message`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `app_code`              varchar(255) DEFAULT NULL COMMENT '应用编码',
    `channel`               varchar(255) NOT NULL COMMENT '渠道编码',
    `message_content`       longtext COMMENT '消息内容',
    `send_time`             datetime(6)  DEFAULT NULL COMMENT '发送时间',
    `finish_time`           datetime(6)  DEFAULT NULL COMMENT '发送结束时间',
    `local`                 bit(1)       DEFAULT NULL COMMENT '是否本地化消费',
    `success`               bit(1)       DEFAULT NULL COMMENT '是否发送成功',
    `fail_reason`           longtext COMMENT '发送失败原因',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `message_id`            varchar(255) DEFAULT NULL COMMENT '消息ID',
    `sys_tenant_id`         bigint       DEFAULT NULL COMMENT '租户ID',
    `retry_times`           int          DEFAULT '0' COMMENT '发送重试的次数',
    `retried`               bit(1)       DEFAULT b'0' COMMENT '是否是重试消息',
    `retry_fail_reason`     varchar(255) DEFAULT NULL COMMENT '重试失败原因',
    `original_message_id`   varchar(255) DEFAULT NULL COMMENT '原始消息ID',
    `consumed`              bit(1)       DEFAULT b'0' COMMENT '是否已消费',
    `consume_time`          datetime(6)  DEFAULT NULL COMMENT '消费时间',
    `last_retry_message_id` varchar(255) DEFAULT NULL COMMENT '最后一次重试的消息ID',
    `business_key`          varchar(255) DEFAULT NULL COMMENT '业务数据key',
    PRIMARY KEY (`id`),
    KEY `idx_mq_msg_appcode` (`app_code`),
    KEY `idx_mq_msg_channel` (`channel`),
    KEY `idx_mq_msg_sendtime` (`send_time`),
    KEY `idx_mq_msg_success` (`success`),
    KEY `idx_mq_msg_msgid` (`message_id`),
    KEY `idx_mq_msg_tenantid` (`sys_tenant_id`),
    KEY `idx_mq_msg_key` (`business_key`)
) COMMENT ='MQ消息记录';


-- `cloudt3-system`.sys_mq_retry definition

CREATE TABLE `sys_mq_retry`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `message_id`         varchar(255) DEFAULT NULL COMMENT '消息ID',
    `retry_times`        int          DEFAULT '0' COMMENT '发送重试的次数',
    `send_time`          datetime(6)  DEFAULT NULL COMMENT '上次发送时间',
    `send_time_next`     datetime(6)  DEFAULT NULL COMMENT '下次发送时间',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `consumer`           bit(1)       DEFAULT NULL COMMENT '是否是消费失败',
    PRIMARY KEY (`id`),
    KEY `idx_mq_msg_msgid` (`message_id`)
) COMMENT ='MQ消息发送记录';


-- `cloudt3-system`.sys_msg_send_record definition

CREATE TABLE `sys_msg_send_record`
(
    `id`                  bigint NOT NULL COMMENT '记录唯一ID',
    `msg_type`            varchar(40)   DEFAULT NULL COMMENT '消息类型-枚举（模板、自定义）',
    `send_user_id`        varchar(40)   DEFAULT NULL COMMENT '发送人id',
    `send_user_name`      varchar(40)   DEFAULT NULL COMMENT '发送人名称',
    `recipient_user_name` varchar(40)   DEFAULT NULL COMMENT '接收人名称',
    `recipient_user_id`   varchar(40)   DEFAULT NULL COMMENT '接收人id',
    `send_time`           datetime(6)   DEFAULT NULL COMMENT '发送时间',
    `batch_uuid`          varchar(200)  DEFAULT NULL COMMENT '批量号',
    `tenant_id`           bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int           DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `send_user_code`      varchar(40)   DEFAULT NULL COMMENT '发送人编码',
    `recipient_user_code` varchar(40)   DEFAULT NULL COMMENT '发送人编码',
    `template_code`       varchar(200)  DEFAULT NULL COMMENT '模板编码',
    `template_name`       varchar(200)  DEFAULT NULL COMMENT '模板名称',
    `custom_param_json`   varchar(2000) DEFAULT NULL COMMENT '自定义参数json',
    `send_param_json`     longtext COMMENT '发送参数json',
    PRIMARY KEY (`id`),
    KEY `index_msgType` (`msg_type`),
    KEY `index_sendUserId` (`send_user_id`),
    KEY `index_sendTime` (`send_time`),
    KEY `index_batchUuid` (`batch_uuid`),
    KEY `index_recipientUserName` (`recipient_user_name`),
    KEY `index_recipientUserId` (`recipient_user_id`)
) COMMENT ='消息发送主记录';


-- `cloudt3-system`.sys_msg_send_record_dtl definition

CREATE TABLE `sys_msg_send_record_dtl`
(
    `id`                       bigint NOT NULL COMMENT '记录唯一ID',
    `msg_send_record_id`       bigint        DEFAULT NULL COMMENT '消息发送主表',
    `msg_type`                 varchar(200)  DEFAULT NULL COMMENT '消息类型-枚举-模板-自定义',
    `send_state`               varchar(40)   DEFAULT NULL COMMENT '发送状态-枚举-发送中，成功，失败',
    `sent_type_code`           varchar(200)  DEFAULT NULL COMMENT '发送类型-短信-邮箱-站内信-站内提醒websoket',
    `send_type_name`           varchar(200)  DEFAULT NULL COMMENT '发送类型名称',
    `sent_time_start`          datetime(6)   DEFAULT NULL COMMENT '发送时间',
    `sent_time_end`            datetime(6)   DEFAULT NULL COMMENT '发送回执时间',
    `sent_end_message`         varchar(2000) DEFAULT NULL COMMENT '发送回执信息',
    `sent_err_message`         longtext COMMENT '发送系统内异常信息',
    `send_user_id`             varchar(40)   DEFAULT NULL COMMENT '发送人id',
    `send_user_name`           varchar(200)  DEFAULT NULL COMMENT '发送人名称',
    `recipient_user_name`      varchar(200)  DEFAULT NULL COMMENT '接收人名称',
    `recipient_user_id`        varchar(40)   DEFAULT NULL COMMENT '接收人id',
    `template_id`              bigint        DEFAULT NULL COMMENT '模板id',
    `template_code`            varchar(200)  DEFAULT NULL COMMENT '模板编码',
    `template_name`            varchar(200)  DEFAULT NULL COMMENT '模板名称',
    `subject`                  varchar(200)  DEFAULT NULL COMMENT '主题-暂定udc',
    `title_content`            varchar(200)  DEFAULT NULL COMMENT '标题内容',
    `message_content`          longtext COMMENT '消息内容',
    `external_template_id`     varchar(200)  DEFAULT NULL COMMENT '外部模板id',
    `extend1`                  longtext,
    `extend2`                  longtext,
    `extend3`                  longtext,
    `extend4`                  longtext,
    `extend5`                  longtext,
    `read_flg`                 bit(1)        DEFAULT NULL COMMENT '是否已读',
    `read_time`                varchar(200)  DEFAULT NULL COMMENT '已读时间',
    `batch_uuid`               varchar(200)  DEFAULT NULL COMMENT '批量号',
    `tenant_id`                bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`            bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`            bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`                   varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`           bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                  varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`              datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`           bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                  varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`              datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`              int           DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`       int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`              bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `send_user_code`           varchar(40)   DEFAULT NULL COMMENT '发送人编码',
    `recipient_user_code`      varchar(40)   DEFAULT NULL COMMENT '发送人编码',
    `template_send_param_json` longtext COMMENT '模板发送参数json',
    `custom_param_json`        longtext COMMENT '自定义json参数',
    `recipient_account`        varchar(255)  DEFAULT NULL COMMENT '接收账号',
    `recipient_account_type`   varchar(255)  DEFAULT 'RECEIVER' COMMENT '接收账号类型',
    `receipt_user_id`          varchar(255)  DEFAULT NULL COMMENT '回执账号ID',
    `receipt_account`          varchar(255)  DEFAULT NULL COMMENT '回执账号',
    PRIMARY KEY (`id`),
    KEY `index_templateCode` (`template_code`),
    KEY `index_msgSendRecordId` (`msg_send_record_id`),
    KEY `index_sendState` (`send_state`),
    KEY `index_sentTypeCode` (`sent_type_code`),
    KEY `index_msgType` (`msg_type`),
    KEY `index_sendUserId` (`send_user_id`),
    KEY `index_sentTimeStart` (`sent_time_start`),
    KEY `index_batchUuid` (`batch_uuid`),
    KEY `index_recipientUserName` (`recipient_user_name`),
    KEY `index_recipientUserId` (`recipient_user_id`),
    KEY `idx_msg_rdl_sendusercode` (`send_user_code`),
    KEY `idx_msg_rdl_recipentusercode` (`recipient_user_code`)
) COMMENT ='消息发送明细表';


-- `cloudt3-system`.sys_msg_send_type definition

CREATE TABLE `sys_msg_send_type`
(
    `id`                    bigint NOT NULL COMMENT '记录唯一ID',
    `send_type_code`        varchar(200) DEFAULT NULL COMMENT '类型编码',
    `send_type_name`        varchar(200) DEFAULT NULL COMMENT '类型名称',
    `send_type_config_json` longtext COMMENT '类型配置json，邮箱，短信等-站内信-站内提醒websoket',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='发送类型配置表（暂时配置文件，不建表）';


-- `cloudt3-system`.sys_msg_template definition

CREATE TABLE `sys_msg_template`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `template_code`      varchar(200) DEFAULT NULL COMMENT '模板编码',
    `template_name`      varchar(200) DEFAULT NULL COMMENT '模板名称',
    `template_group`     varchar(200) DEFAULT NULL COMMENT '模板分组-UDC',
    `template_describe`  varchar(500) DEFAULT NULL COMMENT '模板描述',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `index_templateCode` (`template_code`),
    KEY `index_templateName` (`template_name`)
) COMMENT ='消息模板主表';


-- `cloudt3-system`.sys_msg_template_config definition

CREATE TABLE `sys_msg_template_config`
(
    `id`                    bigint NOT NULL COMMENT '记录唯一ID',
    `template_id`           bigint       DEFAULT NULL COMMENT '模板id',
    `template_code`         varchar(200) DEFAULT NULL COMMENT '模板编码',
    `template_name`         varchar(200) DEFAULT NULL COMMENT '模板名称',
    `send_type_code`        varchar(200) DEFAULT NULL COMMENT '发送类型',
    `send_type_switch`      bit(1)       DEFAULT NULL COMMENT '发送类型开关',
    `send_type_name`        varchar(200) DEFAULT NULL COMMENT '发送类型',
    `mes_subject`           varchar(200) DEFAULT NULL COMMENT '主题-暂定udc/暂时无用',
    `mes_title`             varchar(200) DEFAULT NULL COMMENT '标题',
    `mes_rich_content_sign` bit(1)       DEFAULT NULL COMMENT '是否富文本',
    `external_template_id`  varchar(200) DEFAULT NULL COMMENT '外部模板id',
    `mes_text`              longtext COMMENT '内容',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `external_sign_name`    varchar(255) DEFAULT NULL COMMENT '签名',
    `std_product`           bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`           varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `index_templateId` (`template_id`),
    KEY `index_sendTypeCode` (`send_type_code`),
    KEY `index_templateCode` (`template_code`),
    KEY `index_templateName` (`template_name`)
) COMMENT ='模板发送配置';


-- `cloudt3-system`.sys_msg_template_receiver definition

CREATE TABLE `sys_msg_template_receiver`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `template_id`        bigint       DEFAULT NULL COMMENT '模板Id',
    `template_config_id` bigint       DEFAULT NULL COMMENT '模板配置ID',
    `receiver_type`      varchar(255) NOT NULL COMMENT '接收人类型',
    `receiver_id`        bigint       DEFAULT NULL COMMENT '接收人ID',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_msg_tmpl_rer_tmplid` (`template_id`)
) COMMENT ='消息模板默认接收人';


-- `cloudt3-system`.sys_notice definition

CREATE TABLE `sys_notice`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `title`              varchar(255) NOT NULL COMMENT '标题',
    `summaries`          varchar(255) DEFAULT NULL COMMENT '摘要',
    `author_id`          bigint       DEFAULT NULL COMMENT '作者',
    `category`           varchar(255) DEFAULT NULL COMMENT '分类，[UDC]cloudt-system:noticeCategory',
    `notice_type`        varchar(255) DEFAULT NULL COMMENT '公告类型',
    `published`          bit(1)       DEFAULT b'0' COMMENT '是否已发布',
    `top`                bit(1)       DEFAULT b'0' COMMENT '是否置顶',
    `publish_time`       datetime     DEFAULT NULL COMMENT '发布时间',
    `change_time`        datetime     DEFAULT NULL COMMENT '修改时间',
    `txt_id`             bigint       DEFAULT NULL COMMENT '公告内容ID',
    `file_codes_str`     varchar(255) DEFAULT NULL COMMENT '附件标识，多个以逗号分隔',
    `read_amount`        bigint       DEFAULT '0' COMMENT '阅读量',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys`                bit(1)       DEFAULT b'0' COMMENT '是否系统公告',
    PRIMARY KEY (`id`),
    KEY `idx_notice_author` (`author_id`),
    KEY `idx_notice_publish` (`published`),
    KEY `idx_notice_publishtime` (`publish_time`),
    KEY `idx_notice_title` (`title`),
    KEY `idx_notice_category` (`category`),
    KEY `idx_notice_type` (`notice_type`)
) COMMENT ='系统公告';


-- `cloudt3-system`.sys_notice_txt definition

CREATE TABLE `sys_notice_txt`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `notice_id`          bigint NOT NULL COMMENT '公告ID',
    `txt`                longtext COMMENT '公告内容',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_notice_txt_noticeid` (`notice_id`)
) COMMENT ='系统公告内容';


-- `cloudt3-system`.sys_openapi_component_schema definition

CREATE TABLE `sys_openapi_component_schema`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint       NOT NULL COMMENT 'openApi信息ID',
    `schema_path`        varchar(255) NOT NULL COMMENT 'schema名称',
    `schema_type`        varchar(255) DEFAULT NULL COMMENT 'schema类型',
    `resource_id`        bigint       DEFAULT NULL COMMENT '原始数据的资源ID',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_compsche_info` (`open_api_info_id`),
    KEY `idx_openapi_compsche_path` (`schema_path`)
) COMMENT ='OpenAPI操作信息参数';


-- `cloudt3-system`.sys_openapi_info definition

CREATE TABLE `sys_openapi_info`
(
    `id`                                bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_code`                     varchar(255) DEFAULT NULL COMMENT 'OpenApi编码',
    `project`                           varchar(255) DEFAULT NULL COMMENT '项目编码',
    `project_name`                      varchar(255) DEFAULT NULL COMMENT '项目名称',
    `env`                               varchar(255) DEFAULT NULL COMMENT '环境编码',
    `env_name`                          varchar(255) DEFAULT NULL COMMENT '环境名称',
    `app_code`                          varchar(255) DEFAULT NULL COMMENT '应用编码',
    `app_name`                          varchar(255) DEFAULT NULL COMMENT '应用名称',
    `title`                             varchar(255) NOT NULL COMMENT '标题',
    `description`                       varchar(255) DEFAULT NULL COMMENT '描述',
    `version`                           varchar(255) DEFAULT NULL COMMENT '版本',
    `build_time`                        datetime(6)  DEFAULT NULL COMMENT 'OpenAPI构建时间',
    `project_version`                   varchar(255) DEFAULT NULL COMMENT '项目版本',
    `cloudt_boot_version`               varchar(255) DEFAULT NULL COMMENT '云梯架构版本',
    `resource_id`                       bigint       DEFAULT NULL COMMENT '原始数据的资源ID',
    `business_resource_id`              bigint       DEFAULT NULL COMMENT '业务对象的资源ID',
    `tags_json`                         longtext COMMENT '标签列表json',
    `state`                             varchar(255) DEFAULT NULL COMMENT 'OpenAPI状态',
    `fail_reason`                       longtext COMMENT 'OpenAPI更新失败原因',
    `start_update_time`                 datetime(6)  DEFAULT NULL COMMENT '开始更新时间',
    `end_update_time`                   datetime(6)  DEFAULT NULL COMMENT '结束更新时间',
    `business_object_state`             varchar(255) DEFAULT NULL COMMENT '业务对象状态',
    `business_object_fail_reason`       longtext COMMENT '业务对象更新失败原因',
    `business_object_start_update_time` datetime(6)  DEFAULT NULL COMMENT '开始更新时间',
    `business_object_end_update_time`   datetime(6)  DEFAULT NULL COMMENT '结束更新时间',
    `tenant_id`                         bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`                     bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`                     bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                            varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`                    bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                           varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`                       datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`                    bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                           varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`                       datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`                       int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`                int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                         bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`                       bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                         bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_openapi_info_code` (`open_api_code`),
    KEY `idx_openapi_info_app` (`app_code`)
) COMMENT ='OpenAPI信息';


-- `cloudt3-system`.sys_openapi_operation definition

CREATE TABLE `sys_openapi_operation`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`     bigint       NOT NULL COMMENT 'openApi信息ID',
    `operation_code`       varchar(255) NOT NULL COMMENT '操作编码',
    `operation_id`         longtext COMMENT '操作ID',
    `summary`              varchar(255)  DEFAULT NULL COMMENT '摘要信息',
    `description`          varchar(255)  DEFAULT NULL COMMENT '描述',
    `tags_json`            longtext COMMENT '标签列表json',
    `resource_id`          bigint        DEFAULT NULL COMMENT '原始数据的资源ID',
    `business_operation`   bit(1)        DEFAULT b'0' COMMENT '是否含有业务操作',
    `enabled`              bit(1)        DEFAULT b'1' COMMENT '是否启用',
    `url`                  varchar(255)  DEFAULT NULL COMMENT '接口地址',
    `method`               varchar(255)  DEFAULT NULL COMMENT '接口方法',
    `data_source`          varchar(255)  DEFAULT NULL COMMENT '数据来源',
    `tenant_id`            bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int           DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `api_type`             int           DEFAULT NULL COMMENT 'apiType类型 null|1=内部  2=外部（openfeign）',
    `operation_group`      varchar(255)  DEFAULT NULL COMMENT '操作分组',
    `return_type_json`     varchar(5000) DEFAULT NULL,
    `parameter_types_json` varchar(5000) DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_openapi_ope_code` (`open_api_info_id`, `operation_code`),
    KEY `idx_openapi_ope_info` (`open_api_info_id`),
    KEY `idx_openapi_ope_business` (`business_operation`),
    KEY `idx_openapi_ope_summary` (`summary`),
    KEY `idx_openapi_ope_url` (`url`)
) COMMENT ='OpenAPI操作信息';


-- `cloudt3-system`.sys_openapi_resource definition

CREATE TABLE `sys_openapi_resource`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint NOT NULL COMMENT 'openApi信息ID',
    `resource`           longtext COMMENT '资源内容字符串',
    `resource_byte`      longblob COMMENT '资源内容byte',
    `sort_no`            int          DEFAULT '0' COMMENT '排序',
    `ext1`               varchar(255) DEFAULT NULL COMMENT '扩展字段1',
    `ext2`               varchar(255) DEFAULT NULL COMMENT '扩展字段2',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_res_openapi` (`open_api_info_id`)
) COMMENT ='OpenAPI资源信息';


-- `cloudt3-system`.sys_openapi_tag definition

CREATE TABLE `sys_openapi_tag`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `open_api_info_id`   bigint NOT NULL COMMENT 'openApi信息ID',
    `operation_id`       bigint       DEFAULT NULL COMMENT 'openApi操作ID',
    `tag`                varchar(255) DEFAULT NULL COMMENT 'tag内容',
    `sort_no`            int          DEFAULT '0' COMMENT '序号',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_openapi_tag_info` (`open_api_info_id`),
    KEY `idx_openapi_tag_opera` (`operation_id`),
    KEY `idx_openapi_tag_tag` (`tag`)
) COMMENT ='OpenAPI标签';


-- `cloudt3-system`.sys_org definition

CREATE TABLE `sys_org`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `p_id`               bigint       DEFAULT '-1' COMMENT '上级节点ID',
    `root_id`            bigint       DEFAULT NULL COMMENT '根节点ID',
    `lft`                int          DEFAULT NULL COMMENT '左节点序号',
    `rgt`                int          DEFAULT NULL COMMENT '右节点序号',
    `depth`              int          DEFAULT NULL COMMENT '深度',
    `code`               varchar(255) NOT NULL COMMENT '组织编码',
    `name`               varchar(255) NOT NULL COMMENT '组织名称',
    `parent_code`        varchar(255) DEFAULT NULL COMMENT '上级组织编码',
    `short_name`         varchar(255) DEFAULT NULL COMMENT '简称',
    `type`               varchar(255) DEFAULT NULL COMMENT '类型，[UDC]ORG:TYPE',
    `entity`             bit(1)       DEFAULT b'1' COMMENT '是否是实体组织',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `executive`          bit(1)       DEFAULT b'1' COMMENT '是否行政组织',
    `ou_id`              bigint       DEFAULT NULL COMMENT '所属公司ID',
    `region`             varchar(255) DEFAULT NULL COMMENT '区域，[UDC]cloudt-system:region',
    `business_unit`      varchar(255) DEFAULT NULL COMMENT '事业部，[UDC]cloudt-system:businessUnit',
    `profitably_center`  varchar(255) DEFAULT NULL COMMENT '利润中心，[UDC]cloudt-system:profitablyCenter',
    `function_type`      varchar(255) DEFAULT NULL COMMENT '职能类型，[UDC]cloudt-system:functionType',
    `english_name`       varchar(255) DEFAULT NULL COMMENT '英语名称',
    `extension_info`     json         DEFAULT NULL,
    `outer_code`         varchar(255) DEFAULT NULL COMMENT '外部组织编码',
    PRIMARY KEY (`id`),
    KEY `idx_org_code` (`code`),
    KEY `idx_org_parent_code` (`parent_code`),
    KEY `idx_org_parent_type` (`type`),
    KEY `idx_org_pid` (`p_id`),
    KEY `idx_org_rootid` (`root_id`),
    KEY `idx_org_lft` (`lft`),
    KEY `idx_org_rgt` (`rgt`),
    KEY `idx_org_outer_code` (`outer_code`)
) COMMENT ='组织';


-- `cloudt3-system`.sys_org_bu_tree definition

CREATE TABLE `sys_org_bu_tree`
(
    `id`                  bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_type`        varchar(32)  DEFAULT NULL COMMENT '组织树类型',
    `bu_tree_type2`       varchar(32)  DEFAULT NULL COMMENT '组织树类型2',
    `bu_tree_type3`       varchar(32)  DEFAULT NULL COMMENT '组织树类型3',
    `bu_tree_status`      varchar(32)  DEFAULT NULL COMMENT '组织树状态',
    `bu_tree_code`        varchar(32)  DEFAULT NULL COMMENT '组织树编号',
    `bu_tree_name`        varchar(64)  DEFAULT NULL COMMENT '组织树名称',
    `bu_tree_version`     varchar(32)  DEFAULT NULL COMMENT '组织树版本',
    `now_version`         varchar(32)  DEFAULT NULL COMMENT '组织树当前版本',
    `cat`                 varchar(32)  DEFAULT NULL COMMENT '类别码',
    `cat2`                varchar(32)  DEFAULT NULL COMMENT '类别码2',
    `cat3`                varchar(32)  DEFAULT NULL COMMENT '类别码3',
    `cat4`                varchar(32)  DEFAULT NULL COMMENT '类别码4',
    `cat5`                varchar(32)  DEFAULT NULL COMMENT '类别码5',
    `cat6`                varchar(32)  DEFAULT NULL COMMENT '类别码6',
    `cat7`                varchar(32)  DEFAULT NULL COMMENT '类别码',
    `cat8`                varchar(32)  DEFAULT NULL COMMENT '类别码8',
    `cat9`                varchar(32)  DEFAULT NULL COMMENT '类别码9',
    `cat10`               varchar(32)  DEFAULT NULL COMMENT '类别码10',
    `release_time`        datetime(6)  DEFAULT NULL COMMENT '发布时间',
    `is_now_version`      bit(1)       DEFAULT NULL COMMENT '是否当前版本',
    `disable_time`        datetime(6)  DEFAULT NULL COMMENT '停用时间',
    `release_user`        varchar(255) DEFAULT NULL COMMENT '发布人',
    `version_instruction` varchar(255) DEFAULT NULL COMMENT '版本说明',
    `tenant_id`           bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='组织树';


-- `cloudt3-system`.sys_org_bu_tree_d definition

CREATE TABLE `sys_org_bu_tree_d`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_id`         bigint       DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint       DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT '组织编号',
    `data_source`        varchar(40)  DEFAULT NULL COMMENT '类别码20',
    `sync_status`        tinyint(1)   DEFAULT '0' COMMENT '同步的数据是否需要覆盖',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `pid`                bigint NOT NULL COMMENT '上级ID',
    `sort_no`            int          DEFAULT NULL COMMENT '排序号',
    `level`              int          DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    PRIMARY KEY (`id`),
    KEY `idx_bu_tree_pid` (`pid`),
    KEY `idx_bu_tree_code_path` (`code_path`)
) COMMENT ='组织树明细';


-- `cloudt3-system`.sys_org_bu_tree_version definition

CREATE TABLE `sys_org_bu_tree_version`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='组织树版本';


-- `cloudt3-system`.sys_orgbu_tree_employee definition

CREATE TABLE `sys_orgbu_tree_employee`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_id`         bigint       DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint       DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT '组织编号',
    `employee_id`        bigint       DEFAULT NULL COMMENT '员工id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `position_id`        bigint       DEFAULT NULL COMMENT '员工所在组织的岗位ID',
    `leader_user_id`     bigint       DEFAULT NULL COMMENT '领导用户ID',
    `leader_employee_id` bigint       DEFAULT NULL COMMENT '领导的员工ID',
    PRIMARY KEY (`id`)
) COMMENT ='组织树员工关系';


-- `cloudt3-system`.sys_ou definition

CREATE TABLE `sys_ou`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `ou_code`            varchar(255) NOT NULL COMMENT '公司编码',
    `ou_name`            varchar(255) NOT NULL COMMENT '公司名称',
    `ou_abbr`            varchar(255) DEFAULT NULL COMMENT '简称',
    `ou_type`            varchar(255) DEFAULT NULL COMMENT '公司类型，[UDC]cloudt-system:ouType',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `enabled`            bit(1)       DEFAULT b'0' COMMENT '是否启用',
    `legal_person`       varchar(255) DEFAULT NULL COMMENT '公司法人',
    `ic_register_no`     varchar(255) DEFAULT NULL COMMENT '工商登记号',
    `phone`              varchar(255) DEFAULT NULL COMMENT '电话号',
    `email`              varchar(255) DEFAULT NULL COMMENT '公司邮箱',
    `legal_ou_id`        bigint       DEFAULT NULL COMMENT '法人公司ID',
    `region`             varchar(255) DEFAULT NULL COMMENT '所属区域，[UDC]cloudt-system:region',
    `province_code`      varchar(255) DEFAULT NULL COMMENT '所在地-省份编码',
    `city_code`          varchar(255) DEFAULT NULL COMMENT '所在地-市编码',
    `county_code`        varchar(255) DEFAULT NULL COMMENT '所在地-县编码',
    `address`            varchar(255) DEFAULT NULL COMMENT '详细地址',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `pinyin`             varchar(255) DEFAULT NULL COMMENT '名称拼音',
    `country_code`       varchar(255) DEFAULT NULL COMMENT '国家编码',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_ou_name` (`ou_name`) USING BTREE,
    KEY `idx_ou_code` (`ou_code`)
) COMMENT ='公司';


-- `cloudt3-system`.sys_page_field_config definition

CREATE TABLE `sys_page_field_config`
(
    `id`                 bigint       NOT NULL COMMENT 'id',
    `app_code`           varchar(255) NOT NULL COMMENT '所属应用',
    `app_name`           varchar(255) NOT NULL COMMENT '所属应用名称',
    `config_name`        varchar(255) NOT NULL COMMENT '配置名称',
    `config_code`        varchar(255) NOT NULL COMMENT '配置编码',
    `tenant_id`          bigint         DEFAULT NULL COMMENT '租户id',
    `belong_org_id`      bigint         DEFAULT NULL COMMENT '所属组织',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '8',
    `create_user_id`     bigint         DEFAULT NULL COMMENT '创建人id',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '创建者',
    `create_time`        date           DEFAULT NULL COMMENT '创建时间',
    `modify_user_id`     bigint         DEFAULT NULL COMMENT '更新人id',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '更新人',
    `modify_time`        varchar(255)   DEFAULT NULL COMMENT '更新时间',
    `delete_flag`        int            DEFAULT NULL COMMENT '是否删除1是 0否',
    `audit_data_version` decimal(24, 6) DEFAULT NULL COMMENT '版本号',
    `sec_bu_id`          bigint         DEFAULT NULL COMMENT '所属组织',
    `sec_user_id`        bigint         DEFAULT NULL COMMENT '所属员工',
    `sec_ou_id`          bigint         DEFAULT NULL COMMENT '所属公司',
    `user_id`            bigint         DEFAULT NULL COMMENT '用户id',
    `role_id`            bigint         DEFAULT NULL COMMENT '角色id',
    `tenant_org_id`      bigint         DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            int          NOT NULL COMMENT '是否可用',
    PRIMARY KEY (`id`),
    KEY `index_configCode` (`config_code`),
    KEY `index_appCode` (`app_code`)
) COMMENT ='页面字段配置';


-- `cloudt3-system`.sys_page_field_config_dtl definition

CREATE TABLE `sys_page_field_config_dtl`
(
    `id`                  bigint         NOT NULL COMMENT 'id',
    `app_code`            varchar(255)   NOT NULL COMMENT '所属应用',
    `app_name`            varchar(255)   NOT NULL COMMENT '所属应用名称',
    `config_name`         varchar(255)   NOT NULL COMMENT '配置名称',
    `config_code`         varchar(255)   NOT NULL COMMENT '配置编码',
    `field_name`          varchar(255)   NOT NULL COMMENT '字段名称',
    `field_code`          varchar(255)   NOT NULL COMMENT '字段编码',
    `field_required`      int            DEFAULT NULL COMMENT '是否必填',
    `field_alias`         varchar(255)   DEFAULT NULL COMMENT '字段别名',
    `linenum`             decimal(24, 6) NOT NULL COMMENT '行号',
    `tenant_id`           bigint         DEFAULT NULL COMMENT '租户id',
    `belong_org_id`       bigint         DEFAULT NULL COMMENT '所属组织',
    `remark`              varchar(255)   DEFAULT NULL COMMENT '8',
    `create_user_id`      bigint         DEFAULT NULL COMMENT '创建人id',
    `creator`             varchar(255)   DEFAULT NULL COMMENT '创建者',
    `create_time`         date           DEFAULT NULL COMMENT '创建时间',
    `modify_user_id`      bigint         DEFAULT NULL COMMENT '更新人id',
    `updater`             varchar(255)   DEFAULT NULL COMMENT '更新人',
    `modify_time`         varchar(255)   DEFAULT NULL COMMENT '更新时间',
    `delete_flag`         int            DEFAULT NULL COMMENT '是否删除1是 0否',
    `audit_data_version`  decimal(24, 6) DEFAULT NULL COMMENT '版本号',
    `sec_bu_id`           bigint         DEFAULT NULL COMMENT '所属组织',
    `sec_user_id`         bigint         DEFAULT NULL COMMENT '所属员工',
    `sec_ou_id`           bigint         DEFAULT NULL COMMENT '所属公司',
    `user_id`             bigint         DEFAULT NULL COMMENT '用户id',
    `role_id`             bigint         DEFAULT NULL COMMENT '角色id',
    `tenant_org_id`       bigint         DEFAULT NULL COMMENT '租户组织ID',
    `field_type`          varchar(255)   DEFAULT NULL COMMENT '字段类型',
    `field_type_name`     varchar(255)   DEFAULT NULL COMMENT '字段类型名称',
    `field_order`         int            DEFAULT NULL COMMENT '字段排序',
    `field_hidden`        tinyint(1)     DEFAULT NULL COMMENT '是否隐藏',
    `field_edit`          tinyint(1)     DEFAULT NULL COMMENT '是否可编辑',
    `field_default_value` varchar(255)   DEFAULT NULL COMMENT '默认值展示',
    `field_width`         varchar(255)   DEFAULT NULL COMMENT '字段宽度',
    `field_description`   text COMMENT '字段帮助',
    `field_style`         varchar(255)   DEFAULT NULL COMMENT '字段样式',
    PRIMARY KEY (`id`),
    KEY `index_appCode` (`app_code`),
    KEY `index_configCode` (`config_code`),
    KEY `index_fieldCode` (`field_code`)
) COMMENT ='页面字段配置明细';


-- `cloudt3-system`.sys_pc_bar definition

CREATE TABLE `sys_pc_bar`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `name`               varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1)   DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(255) DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1)   DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort`               int          DEFAULT NULL COMMENT '排序',
    `upper_bar_id`       bigint       DEFAULT NULL COMMENT '上级栏目id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='网站外观配置信息表';


-- `cloudt3-system`.sys_permission_res definition

CREATE TABLE `sys_permission_res`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `res_type`           varchar(255) NOT NULL COMMENT '资源类型',
    `res_id`             varchar(255) NOT NULL COMMENT '资源标识',
    `owner_type`         varchar(255) NOT NULL COMMENT '持有者类型',
    `owner_id`           varchar(255) NOT NULL COMMENT '持有者标识',
    `assigner_type`      varchar(255) NOT NULL COMMENT '分配者类型',
    `assigner_id`        varchar(255) NOT NULL COMMENT '分配者标识',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_permission_res_res` (`res_id`),
    KEY `idx_permission_res_owner` (`owner_id`),
    KEY `idx_permission_res_assigner` (`assigner_id`)
) COMMENT ='权限资源配置';


-- `cloudt3-system`.sys_platform_admin_menus definition

CREATE TABLE `sys_platform_admin_menus`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `admin_type`         varchar(40)  DEFAULT NULL COMMENT '管理员类型',
    `menus_code`         varchar(400) DEFAULT NULL COMMENT '菜单编码',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `idx_admin_menu_type` (`admin_type`)
) COMMENT ='管理员菜单';


-- `cloudt3-system`.sys_platform_api_manage definition

CREATE TABLE `sys_platform_api_manage`
(
    `id`                        bigint NOT NULL COMMENT '记录唯一ID',
    `app_code`                  varchar(255) DEFAULT NULL COMMENT '接口所属应用',
    `api_name`                  varchar(255) DEFAULT NULL COMMENT '接口名称',
    `api_code`                  varchar(255) DEFAULT NULL COMMENT '接口编号',
    `request_type`              varchar(255) DEFAULT NULL COMMENT '请求类型',
    `api_path`                  varchar(255) DEFAULT NULL COMMENT '请求路径',
    `api_describe`              varchar(255) DEFAULT NULL COMMENT '接口描述',
    `tenant_id`                 bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`             bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`             bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                    varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`            bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                   varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`               datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`            bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                   varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`               datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`               int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`        int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                 bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`               bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                 bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`               bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`               varchar(255) DEFAULT NULL COMMENT '标产版本',
    `business_type`             varchar(255) DEFAULT NULL COMMENT '业务对象编码 business_type',
    `operation_type_name`       varchar(255) DEFAULT NULL COMMENT '操作类型名称',
    `operation_description`     varchar(255) DEFAULT NULL COMMENT '操作描述',
    `operation_scope`           varchar(255) DEFAULT NULL COMMENT '操作范围 OperationScopeEnum',
    `operation_state`           varchar(255) DEFAULT NULL COMMENT '操作状态 operationStateEnum',
    `business_type_name`        varchar(255) DEFAULT NULL COMMENT '业务对象名称',
    `business_type_description` varchar(255) DEFAULT NULL COMMENT '业务对象描述',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_api_code` (`api_code`),
    KEY `idx_api_app` (`app_code`)
) COMMENT ='接口管理';


-- `cloudt3-system`.sys_platform_api_parameter definition

CREATE TABLE `sys_platform_api_parameter`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `api_id`             bigint       DEFAULT NULL COMMENT '字段所属接口id',
    `api_code`           varchar(255) DEFAULT NULL COMMENT '字段所属接口编码',
    `field_name`         varchar(255) DEFAULT NULL COMMENT '字段名称',
    `field_type`         varchar(255) DEFAULT NULL COMMENT '字段类型',
    `field_is_null`      bit(1)       DEFAULT NULL COMMENT '字段是否可以为空',
    `field_explain`      varchar(255) DEFAULT NULL COMMENT '字段说明',
    `in_out_type`        varchar(32)  DEFAULT NULL COMMENT '字段类型',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`)
) COMMENT ='接口字段';


-- `cloudt3-system`.sys_platform_api_permission definition

CREATE TABLE `sys_platform_api_permission`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `permisson_path`     varchar(255) DEFAULT NULL COMMENT '权限路径',
    `permisson_name`     varchar(255) DEFAULT NULL COMMENT '权限名称',
    `permisson_code`     varchar(255) DEFAULT NULL COMMENT '权限编码',
    `request_type`       varchar(255) DEFAULT NULL COMMENT '请求类型',
    `permisson_describe` varchar(255) DEFAULT NULL COMMENT '描述',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_api_permissioncode` (`permisson_code`),
    KEY `idx_api_appcode` (`app_code`),
    KEY `idx_api_menucode` (`menus_code`)
) COMMENT ='api权限配置';


-- `cloudt3-system`.sys_platform_app definition

CREATE TABLE `sys_platform_app`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(40)  DEFAULT NULL COMMENT '应用编码',
    `app_name`           varchar(40)  DEFAULT NULL COMMENT '应用名称',
    `app_type`           varchar(40)  DEFAULT NULL COMMENT '应用类型',
    `app_describe`       varchar(40)  DEFAULT NULL COMMENT '描述',
    `app_state`          bit(1)       DEFAULT NULL COMMENT '状态',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `app_order`          int          DEFAULT NULL COMMENT '排序',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    `url`                varchar(255) DEFAULT NULL COMMENT '外部应用访问地址',
    `token_url`          varchar(255) DEFAULT NULL COMMENT '外部应用生成token地址',
    `outer_app`          bit(1)       DEFAULT b'0' COMMENT '是否外部应用',
    `auth_type`          varchar(255) DEFAULT 'AUTHED' COMMENT '授权类型',
    `icon`               varchar(255) DEFAULT NULL COMMENT '应用图标',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK4vrt57roma9gws0oqianml315` (`app_code`)
) COMMENT ='平台应用管理';


-- `cloudt3-system`.sys_platform_area definition

CREATE TABLE `sys_platform_area`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `area_name`          varchar(255) NOT NULL COMMENT '地区名称',
    `area_code`          varchar(255) NOT NULL COMMENT '地区编码',
    `parent_area_code`   varchar(255) DEFAULT NULL COMMENT '上级地区编码',
    `short_name`         varchar(255) DEFAULT NULL COMMENT '简称',
    `area_type`          varchar(255) DEFAULT NULL COMMENT '类型，UDC[cloudt-system:areaType]',
    `zip_code`           varchar(255) DEFAULT NULL COMMENT '邮编',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用，默认是',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '编码路径',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `p_id`               bigint       DEFAULT '-1' COMMENT '上级节点ID',
    `root_id`            bigint       DEFAULT NULL COMMENT '根节点ID',
    `lft`                int          DEFAULT NULL COMMENT '左节点序号',
    `rgt`                int          DEFAULT NULL COMMENT '右节点序号',
    `depth`              int          DEFAULT '0' COMMENT '深度',
    `sort_no`            int          DEFAULT '0' COMMENT '顺序',
    `pinyin`             varchar(255) DEFAULT NULL COMMENT '汉语拼音',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `idx_area_code` (`area_code`),
    KEY `idx_area_parent_code` (`parent_area_code`),
    KEY `idx_area_pid` (`p_id`),
    KEY `idx_area_rootid` (`root_id`),
    KEY `idx_area_lft` (`lft`),
    KEY `idx_area_rgt` (`rgt`)
) COMMENT ='行政区域';


-- `cloudt3-system`.sys_platform_currency definition

CREATE TABLE `sys_platform_currency`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `curr_code`          varchar(255) NOT NULL COMMENT '货币编码',
    `curr_name`          varchar(255) NOT NULL COMMENT '货币名称',
    `disp_decimal`       int          DEFAULT '0' COMMENT '小数位数',
    `enabled`            bit(1)       DEFAULT b'0' COMMENT '是否启用，默认否',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `idx_currency_code` (`curr_code`)
) COMMENT ='货币';


-- `cloudt3-system`.sys_platform_database_source definition

CREATE TABLE `sys_platform_database_source`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `dbs_code`              varchar(255) NOT NULL COMMENT '数据源标识',
    `dbs_type`              varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_name`              varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_description`       varchar(255) NOT NULL COMMENT '描述',
    `dbs_hostname`          varchar(255) NOT NULL COMMENT 'IP/主机名',
    `dbs_db_port`           varchar(255) NOT NULL COMMENT '数据库端口',
    `jdbc_extra_parameters` varchar(255) NOT NULL COMMENT 'jdbc额外参数',
    `dbs_url`               varchar(255) NOT NULL COMMENT 'URL',
    `dbs_db_name`           varchar(255) NOT NULL COMMENT '默认数据库名',
    `dbs_driver_class`      varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_username`          varchar(255) NOT NULL COMMENT '账号名称',
    `dbs_password`          varchar(255) NOT NULL COMMENT '数据库密码',
    `dbs_schema`            varchar(255) NOT NULL COMMENT 'Schema',
    `dbs_link_mode`         varchar(255) NOT NULL COMMENT '链接方式 如oracle SID/服务名',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='数据源表';


-- `cloudt3-system`.sys_platform_menus definition

CREATE TABLE `sys_platform_menus`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `menus_app_code`     varchar(40)   DEFAULT NULL COMMENT '菜单归属应用',
    `menus_name`         varchar(40)   DEFAULT NULL COMMENT '菜单名称',
    `menus_type`         varchar(40)   DEFAULT NULL COMMENT '菜单类型',
    `node_type`          varchar(40)   DEFAULT NULL COMMENT '节点类型',
    `menus_code`         varchar(200)  DEFAULT NULL COMMENT '菜单编码',
    `menus_order`        int           DEFAULT NULL COMMENT '排序',
    `menus_state`        bit(1)        DEFAULT NULL COMMENT '菜单状态',
    `menus_parent_code`  varchar(200)  DEFAULT NULL COMMENT '上级菜单编码',
    `menus_route`        varchar(4000) DEFAULT NULL,
    `menus_describe`     varchar(200)  DEFAULT NULL COMMENT '描述',
    `menus_icon`         varchar(100)  DEFAULT NULL COMMENT '图标',
    `display`            bit(1)        DEFAULT NULL COMMENT '是否展示',
    `tenant_org_id`      bigint        DEFAULT NULL COMMENT '租户组织ID',
    `tenant_id`          bigint        DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint        DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int           DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `outer_link`         bit(1)        DEFAULT NULL COMMENT '是否外链接',
    `outer_link_type`    varchar(255)  DEFAULT NULL COMMENT '外链接类型',
    `std_product`        bit(1)        DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255)  DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_menu_code` (`menus_code`),
    KEY `idx_menu_app` (`menus_app_code`),
    KEY `idx_menu_type` (`menus_type`),
    KEY `idx_menu_nodetype` (`node_type`)
) COMMENT ='平台菜单表';


-- `cloudt3-system`.sys_platform_menus_api definition

CREATE TABLE `sys_platform_menus_api`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `app_id`             bigint       DEFAULT NULL COMMENT '应用id',
    `menus_id`           bigint       DEFAULT NULL COMMENT '菜单id',
    `api_id`             bigint       DEFAULT NULL COMMENT '接口id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `menus_code`         varchar(255) NOT NULL COMMENT '菜单编码',
    `api_code`           varchar(100) DEFAULT NULL,
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`)
) COMMENT ='菜单接口';


-- `cloudt3-system`.sys_platform_next_number definition

CREATE TABLE `sys_platform_next_number`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(500) DEFAULT NULL COMMENT '应用编码',
    `code`               varchar(255) NOT NULL COMMENT '下一编号代码',
    `name`               varchar(255) NOT NULL COMMENT '下一编号名称',
    `step`               int          DEFAULT NULL COMMENT '下一编号步长',
    `next_number`        bigint       DEFAULT NULL COMMENT '下一编号取值',
    `nn_period`          varchar(255) DEFAULT NULL COMMENT '下一编号周期',
    `nn_time`            datetime(6)  DEFAULT NULL COMMENT '发号时间',
    `version`            int          DEFAULT NULL COMMENT '乐观锁标记',
    `enabled`            bit(1)       DEFAULT NULL COMMENT '是否启用',
    `internal`           bit(1)       DEFAULT NULL COMMENT '是否系统内置',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `code_appcod_index` (`code`, `app_code`) USING BTREE,
    KEY `version_next_index` (`version`) USING BTREE
) COMMENT ='取号下一编号表';


-- `cloudt3-system`.sys_platform_number_rule definition

CREATE TABLE `sys_platform_number_rule`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编号',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编号',
    `rule_name`          varchar(255) DEFAULT NULL COMMENT '规则名称',
    `sample_code`        varchar(255) DEFAULT NULL COMMENT '取号示例',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    `tenant_custom`      bit(1)       DEFAULT b'0' COMMENT '是否开启租户自定义',
    PRIMARY KEY (`id`)
) COMMENT ='发号器规则';


-- `cloudt3-system`.sys_platform_number_ruledtl definition

CREATE TABLE `sys_platform_number_ruledtl`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编号',
    `rule_id`            bigint       DEFAULT NULL COMMENT '发号器规则ID',
    `seq`                int          DEFAULT NULL COMMENT '排序号',
    `number_type`        varchar(255) DEFAULT NULL COMMENT '取号类型：sys:numbertype',
    `number_pattern`     varchar(255) DEFAULT NULL COMMENT '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码',
    `nn_len`             int          DEFAULT NULL COMMENT '自增序号宽度，默认左补零',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    `rule_code`          varchar(255) DEFAULT NULL COMMENT '规则编码',
    PRIMARY KEY (`id`),
    KEY `idx_sysplatform_number_ruledtl_rule_id` (`rule_id`)
) COMMENT ='发号器规则明细';


-- `cloudt3-system`.sys_platform_password_policy definition

CREATE TABLE `sys_platform_password_policy`
(
    `id`                       bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`                bigint                DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`            bigint                DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`            bigint                DEFAULT NULL COMMENT '租户组织ID',
    `remark`                   varchar(255)          DEFAULT NULL COMMENT '备注',
    `create_user_id`           bigint                DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                  varchar(255)          DEFAULT NULL COMMENT '记录创建者',
    `create_time`              datetime(6)           DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`           bigint                DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                  varchar(255)          DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`              datetime(6)           DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`              int                   DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`       int                   DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`                bigint                DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`              bigint                DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`                bigint                DEFAULT NULL COMMENT '数据归属公司id',
    `policy_name`              varchar(100) NOT NULL COMMENT '策略名称',
    `min_length`               int          NOT NULL DEFAULT '1' COMMENT '最小长度',
    `max_length`               int          NOT NULL DEFAULT '20' COMMENT '最大长度',
    `require_uppercase`        tinyint(1)   NOT NULL DEFAULT '0' COMMENT '是否大写字母',
    `require_lowercase`        tinyint(1)   NOT NULL COMMENT '是否小写字母',
    `require_numbers`          tinyint(1)   NOT NULL COMMENT '是否包含数字',
    `require_special_chars`    tinyint(1)            DEFAULT NULL COMMENT '是否包含特殊字符',
    `cannot_contain_username`  tinyint(1)            DEFAULT NULL COMMENT '是否包含用户名',
    `max_password_age_days`    int                   DEFAULT NULL COMMENT '密码最长有效天数',
    `remember_last_passwords`  int                   DEFAULT NULL COMMENT '密码和前几次密码不能重复',
    `lockout_threshold`        int                   DEFAULT NULL COMMENT '密码重试最大失败次数',
    `lockout_duration_minutes` int                   DEFAULT NULL COMMENT '账户被锁定的时间长度/分钟',
    `is_default`               tinyint(1)            DEFAULT NULL COMMENT '是否默认',
    `sort_order`               int                   DEFAULT NULL COMMENT '排序',
    `policy_code`              varchar(100) NOT NULL COMMENT '规则编码',
    PRIMARY KEY (`id`)
) COMMENT ='密码策略配置';


-- `cloudt3-system`.sys_platform_sql_execute definition

CREATE TABLE `sys_platform_sql_execute`
(
    `id`                 bigint NOT NULL,
    `sql_name`           varchar(255) DEFAULT NULL COMMENT '为SQL命令命名，方便前端显示 ',
    `query_sql`          text COMMENT '存储SQL命令 ',
    `datasource_name`    varchar(255) DEFAULT NULL COMMENT '数据源的标识或名称 ',
    `execute_sql_result` text COMMENT 'SQL执行结果 ',
    `execute_sql_delay`  bigint       DEFAULT NULL COMMENT 'SQL执行时间/毫秒 ',
    `execute_start_time` datetime(6)  DEFAULT NULL COMMENT '开始时间',
    `execute_end_time`   datetime(6)  DEFAULT NULL COMMENT '结束时间',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID ',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sql_code`           varchar(255) DEFAULT NULL COMMENT 'SQL编码',
    `category`           varchar(255) DEFAULT NULL COMMENT '分类, [udc]cloudt-system:sqlCategory',
    `sql_type`           varchar(255) DEFAULT NULL COMMENT 'SQL类型',
    `limit_size`         int          DEFAULT NULL COMMENT '限制数据量',
    PRIMARY KEY (`id`)
);


-- `cloudt3-system`.sys_platform_udc definition

CREATE TABLE `sys_platform_udc`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`           varchar(200) DEFAULT NULL COMMENT '应用编码',
    `udc_code`           varchar(200) DEFAULT NULL COMMENT '编码',
    `udc_name`           varchar(200) DEFAULT NULL COMMENT '名称',
    `allow_update`       bit(1)       DEFAULT NULL COMMENT '允许编辑',
    `allow_add_value`    bit(1)       DEFAULT NULL COMMENT '允许新增值',
    `udc_describe`       varchar(200) DEFAULT NULL COMMENT '描述',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `parent_udc_code`    varchar(255) DEFAULT NULL COMMENT '上级UDC编码',
    `project_custom`     bit(1)       DEFAULT b'1' COMMENT '是否项目定制',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UKf1j7tsoktr4f9qm4eynqr0aul` (`app_code`, `udc_code`, `tenant_id`)
) COMMENT ='平台应用udc';


-- `cloudt3-system`.sys_platform_udc_value definition

CREATE TABLE `sys_platform_udc_value`
(
    `id`                    bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`             bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `app_code`              varchar(200) DEFAULT NULL COMMENT '应用编码',
    `udc_code`              varchar(200) DEFAULT NULL COMMENT 'udc编码',
    `udc_value_code`        varchar(200) DEFAULT NULL COMMENT '值编码',
    `udc_value_name`        varchar(200) DEFAULT NULL COMMENT '值名称',
    `udc_order`             int          DEFAULT NULL COMMENT '排序',
    `allow_start`           bit(1)       DEFAULT NULL COMMENT '是否启用',
    `udc_value_describe`    varchar(200) DEFAULT NULL COMMENT '描述',
    `allow_default`         bit(1)       DEFAULT NULL COMMENT '是否内置',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `parent_udc_value_code` varchar(255) DEFAULT NULL COMMENT '上级值编码',
    `project_custom`        bit(1)       DEFAULT b'1' COMMENT '是否项目定制',
    `value_alias_name`      varchar(255) DEFAULT NULL COMMENT '值的别名',
    `std_product`           bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`           varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UKd1khpd8wkki803mn7nwki7qxj` (`app_code`, `udc_code`, `udc_value_code`, `tenant_id`)
) COMMENT ='udc值';


-- `cloudt3-system`.sys_position definition

CREATE TABLE `sys_position`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`        varchar(255) DEFAULT NULL,
    `position_name`        varchar(255) NOT NULL,
    `position_description` varchar(255) DEFAULT NULL,
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位';


-- `cloudt3-system`.sys_position_org definition

CREATE TABLE `sys_position_org`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`      varchar(255) NOT NULL,
    `org_code`           varchar(255) NOT NULL,
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位组织关联';


-- `cloudt3-system`.sys_position_role definition

CREATE TABLE `sys_position_role`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`      varchar(255) NOT NULL,
    `role_code`          varchar(255) NOT NULL,
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位角色关联';


-- `cloudt3-system`.sys_receipt_source_config definition

CREATE TABLE `sys_receipt_source_config`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `source_no`          varchar(32)  DEFAULT NULL COMMENT '来源编号',
    `source_name`        varchar(128) DEFAULT NULL COMMENT '来源名称',
    `source_type`        varchar(32)  DEFAULT NULL COMMENT '来源类型',
    `connect_url`        varchar(128) DEFAULT NULL COMMENT '接口URL',
    `param_value`        varchar(128) DEFAULT NULL COMMENT '接口参数',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='单据来源配置';


-- `cloudt3-system`.sys_receipt_source_config_detail definition

CREATE TABLE `sys_receipt_source_config_detail`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `source_no`          varchar(32)  DEFAULT NULL COMMENT '来源编号',
    `field_name`         varchar(128) DEFAULT NULL COMMENT '透出字段',
    `field_definition`   varchar(32)  DEFAULT NULL COMMENT '字段定义',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `mas_id`             bigint       DEFAULT NULL COMMENT '主表id',
    PRIMARY KEY (`id`)
) COMMENT ='单据来源配置明细';


-- `cloudt3-system`.sys_resource_byte definition

CREATE TABLE `sys_resource_byte`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `resource_type`      varchar(255) NOT NULL COMMENT '资源类型',
    `resource_key`       varchar(255) NOT NULL COMMENT '资源唯一标识',
    `resource`           longblob     NOT NULL COMMENT '资源',
    `mime_type`          varchar(255) DEFAULT NULL COMMENT '文件mime-type',
    `suffix`             varchar(255) DEFAULT NULL COMMENT '扩展名',
    `resource_name`      varchar(255) DEFAULT NULL COMMENT '原始名称',
    `show_name`          varchar(255) DEFAULT NULL COMMENT '显示名称',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `size`               bigint       DEFAULT NULL COMMENT '文件大小',
    `temp`               bit(1)       DEFAULT b'1' COMMENT '是否是临时文件',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_res_byte_restype` (`resource_type`) USING BTREE,
    KEY `idx_res_byte_reskey` (`resource_key`) USING BTREE,
    KEY `idx_res_byte_temp` (`temp`) USING BTREE
) COMMENT ='资源表';


-- `cloudt3-system`.sys_role definition

CREATE TABLE `sys_role`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `code`               varchar(255) NOT NULL COMMENT '角色编码',
    `name`               varchar(255) NOT NULL COMMENT '角色名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `type`               varchar(255) DEFAULT NULL COMMENT '角色类型',
    `type_id`            varchar(255) DEFAULT NULL COMMENT '类型标识',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `business_key`       varchar(255) DEFAULT 'sys' COMMENT '业务标识，[UDC]cloudt-system:roleBusiness',
    `group_id`           bigint       DEFAULT '-1' COMMENT '分组ID',
    PRIMARY KEY (`id`),
    KEY `idx_role_code` (`code`),
    KEY `idx_role_type` (`type`),
    KEY `idx_role_type_id` (`type_id`),
    KEY `idx_role_business` (`business_key`),
    KEY `idx_role_group` (`group_id`)
) COMMENT ='角色';


-- `cloudt3-system`.sys_role_data_permission definition

CREATE TABLE `sys_role_data_permission`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `role_code`             varchar(255) NOT NULL COMMENT '角色编码',
    `permission_type`       varchar(255) NOT NULL COMMENT '权限类型',
    `app_code`              varchar(255) DEFAULT NULL COMMENT '应用编码',
    `menu_code`             varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `business_object_code`  varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `operation_code`        varchar(255) DEFAULT NULL COMMENT '操作编码',
    `rule_group_code`       varchar(255) DEFAULT NULL COMMENT '规则组编码',
    `rule_relation`         varchar(255) DEFAULT NULL COMMENT '规则关系',
    `rule_name`             varchar(255) DEFAULT NULL COMMENT '规则名称',
    `rule_order`            int          DEFAULT '0' COMMENT '规则排序',
    `rule_description`      varchar(255) DEFAULT NULL COMMENT '规则描述',
    `rule_field`            varchar(255) DEFAULT NULL COMMENT '规则字段',
    `rule_field_type`       varchar(255) DEFAULT NULL COMMENT '规则字段类型',
    `field_value_condition` varchar(255) DEFAULT NULL COMMENT '字段与值的关系',
    `rule_value_type`       varchar(255) DEFAULT NULL COMMENT '值类型',
    `rule_value`            varchar(255) DEFAULT NULL COMMENT '规则值',
    `rule_value_name`       varchar(255) DEFAULT NULL COMMENT '规则值名称',
    `data_set`              varchar(255) DEFAULT NULL COMMENT '数据集类型',
    `bs1`                   longtext COMMENT '特用字段1',
    `bs2`                   longtext COMMENT '特用字段2',
    `bs3`                   longtext COMMENT '特用字段3',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `ref_resource`          bit(1)       DEFAULT b'0' COMMENT '是否引用资源配置',
    `ref_business_object`   varchar(255) DEFAULT NULL COMMENT '引用的业务对象编码',
    `ref_field`             varchar(255) DEFAULT NULL COMMENT '引用的业务对象字段',
    PRIMARY KEY (`id`),
    KEY `idx_role_datapermission_role` (`role_code`),
    KEY `idx_role_datapermission_type` (`permission_type`),
    KEY `idx_role_datapermission_opera` (`operation_code`),
    KEY `idx_role_datapermission_menu` (`menu_code`),
    KEY `idx_role_datapermission_obj` (`business_object_code`)
) COMMENT ='角色与数据权限的关联';


-- `cloudt3-system`.sys_role_field_permission definition

CREATE TABLE `sys_role_field_permission`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `role_code`            varchar(255) NOT NULL COMMENT '角色编码',
    `permission_type`      varchar(255) NOT NULL COMMENT '权限类型',
    `app_code`             varchar(255) DEFAULT NULL COMMENT '应用编码',
    `menu_code`            varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `business_object_code` varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `operation_code`       varchar(255) DEFAULT NULL COMMENT '操作编码',
    `field_name`           varchar(255) DEFAULT NULL COMMENT '字段名称',
    `readable`             bit(1)       DEFAULT b'1' COMMENT '可读',
    `writeable`            bit(1)       DEFAULT b'1' COMMENT '可写',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_role_fieldperm_role` (`role_code`),
    KEY `idx_role_fieldperm_type` (`permission_type`),
    KEY `idx_role_fieldperm_menu` (`menu_code`),
    KEY `idx_role_fieldperm_obj` (`business_object_code`),
    KEY `idx_role_fieldperm_opera` (`operation_code`)
) COMMENT ='角色与字段权限的关联';


-- `cloudt3-system`.sys_role_group definition

CREATE TABLE `sys_role_group`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `group_code`         varchar(255) DEFAULT NULL COMMENT '分组编码',
    `group_name`         varchar(255) NOT NULL COMMENT '分组名称',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '启用状态',
    `description`        varchar(255) DEFAULT NULL COMMENT '描述',
    `type`               varchar(255) DEFAULT NULL COMMENT '角色类型',
    `type_id`            varchar(255) DEFAULT NULL COMMENT '类型标识',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_role_group_type` (`type`),
    KEY `idx_role_group_typeid` (`type_id`)
) COMMENT ='角色分组';


-- `cloudt3-system`.sys_role_permission definition

CREATE TABLE `sys_role_permission`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `role_id`            bigint       NOT NULL COMMENT '角色ID',
    `permission_id`      bigint       DEFAULT NULL COMMENT '权限ID',
    `permission_code`    varchar(255) NOT NULL COMMENT '权限编码',
    `permission_type`    varchar(255) NOT NULL COMMENT '权限类型',
    `custom`             bit(1)       DEFAULT b'0' COMMENT '是否自定义权限树',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `role_code`          varchar(255) DEFAULT NULL COMMENT '角色编码',
    PRIMARY KEY (`id`),
    KEY `idx_role_perm_role_id` (`role_id`),
    KEY `idx_role_perm_perm_code` (`permission_code`),
    KEY `idx_role_perm_perm_type` (`permission_type`),
    KEY `idx_role_perm_perm_app` (`app_code`)
) COMMENT ='角色权限关联';


-- `cloudt3-system`.sys_setting definition

CREATE TABLE `sys_setting`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `setting_no`         varchar(255) NOT NULL COMMENT '设置的编号',
    `setting_name`       varchar(255) DEFAULT NULL COMMENT '设置名称',
    `setting_type`       varchar(255) DEFAULT NULL COMMENT '设置类型',
    `setting_type2`      varchar(255) DEFAULT NULL COMMENT '设置类型2',
    `email`              varchar(255) DEFAULT NULL COMMENT '设置类型3',
    `setting_status`     varchar(255) DEFAULT NULL COMMENT '设置状态',
    `setting_desc`       varchar(500) DEFAULT NULL COMMENT '设置描述',
    `setting_val`        varchar(500) DEFAULT NULL COMMENT '设置值',
    `def_val`            varchar(500) DEFAULT NULL,
    `sort_no`            int          DEFAULT NULL COMMENT '排序号',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `std_product`        bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255) DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `UK_qyumypdg9tjvfnplxeyl9642s` (`setting_no`) USING BTREE,
    KEY `idx_setting_settingNo` (`setting_no`)
) COMMENT ='系统配置表';


-- `cloudt3-system`.sys_sub_user definition

CREATE TABLE `sys_sub_user`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sub_user_id`        bigint NOT NULL COMMENT '子账号ID',
    `type`               varchar(255) DEFAULT NULL COMMENT '归属类型',
    `type_id`            varchar(255) DEFAULT NULL COMMENT '归属类型标识',
    `permission_type`    varchar(255) DEFAULT NULL COMMENT '权限类型',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sub_user_user` (`type_id`),
    KEY `idx_sub_user_subuser` (`sub_user_id`)
) COMMENT ='系统子账号';


-- `cloudt3-system`.sys_tax_rate definition

CREATE TABLE `sys_tax_rate`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tax_rate_no`        varchar(255) NOT NULL COMMENT '税率编号',
    `tax_rate_desc`      varchar(255)   DEFAULT NULL COMMENT '税率说明',
    `valid_from`         datetime(6)    DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime(6)    DEFAULT NULL COMMENT '失效日期',
    `tax_rate_value`     decimal(20, 6) DEFAULT NULL COMMENT '税率值',
    `enabled`            bit(1)         DEFAULT b'1' COMMENT '是否启用',
    `tenant_id`          bigint         DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint         DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint         DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255)   DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint         DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)   DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)    DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint         DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)   DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)    DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int            DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int            DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint         DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint         DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint         DEFAULT NULL COMMENT '数据归属公司id',
    `tax_rate_type`      varchar(255)   DEFAULT NULL COMMENT '税率类型，UDC[cloudt-system:taxRateType]',
    `std_product`        bit(1)         DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`        varchar(255)   DEFAULT NULL COMMENT '标产版本',
    PRIMARY KEY (`id`),
    KEY `idx_tax_rate_no` (`tax_rate_no`),
    KEY `idx_tax_rate_type` (`tax_rate_type`)
) COMMENT ='税率';


-- `cloudt3-system`.sys_tenant definition

CREATE TABLE `sys_tenant`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_code`        varchar(255) NOT NULL COMMENT '租户编码',
    `tenant_name`        varchar(255) NOT NULL COMMENT '租户名称',
    `sys_user_id`        bigint       NOT NULL COMMENT '管理员用户ID',
    `admin_account`      varchar(255) NOT NULL COMMENT '管理员登录账号',
    `tenant_type`        varchar(255) DEFAULT NULL COMMENT '租户类型',
    `enabled`            bit(1)       DEFAULT b'0' COMMENT '是否启用',
    `linkman`            varchar(255) DEFAULT NULL COMMENT '联系人',
    `contact_number`     varchar(255) DEFAULT NULL COMMENT '联系电话',
    `address`            varchar(255) DEFAULT NULL COMMENT '联系地址',
    `tenant_isolation`   varchar(255) DEFAULT NULL COMMENT '租户数据隔离策略',
    `db_initialized`     bit(1)       DEFAULT b'0' COMMENT '数据库是否已初始化',
    `base_data_sync_id`  bigint       DEFAULT NULL COMMENT '基础数据同步记录ID',
    `schema_name`        varchar(255) DEFAULT NULL COMMENT 'schema名称',
    `tenant_domain`      varchar(255) DEFAULT NULL COMMENT '域名地址，二级域名部分',
    `custom_domain`      varchar(255) DEFAULT NULL COMMENT '用户自己的域名',
    `industry`           varchar(255) DEFAULT NULL COMMENT '所属行业，[UDC]COM:INDUSTRY',
    `customer`           varchar(255) DEFAULT NULL COMMENT '所属客户，[UDC]SYS:CUSTOMER',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_tenant_code` (`tenant_code`)
) COMMENT ='平台租户表';


-- `cloudt3-system`.sys_tenant_app definition

CREATE TABLE `sys_tenant_app`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint       NOT NULL COMMENT '租户ID',
    `app_code`           varchar(255) NOT NULL COMMENT '应用编码',
    `assign_time`        datetime(6)  NOT NULL COMMENT '分配时间',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_app_tenant_id` (`sys_tenant_id`),
    KEY `idx_tenant_app_app_code` (`app_code`)
) COMMENT ='租户的应用';


-- `cloudt3-system`.sys_tenant_area definition

CREATE TABLE `sys_tenant_area`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint NOT NULL COMMENT '租户ID',
    `enabled`            bit(1) NOT NULL DEFAULT b'0' COMMENT '是否启用自定义行政区域',
    `tenant_id`          bigint          DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint          DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint          DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint          DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint          DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int             DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int             DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint          DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint          DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint          DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_sys_tenant_area_tenant` (`sys_tenant_id`)
) COMMENT ='租户自定义行政区域';


-- `cloudt3-system`.sys_tenant_bdata_sync definition

CREATE TABLE `sys_tenant_bdata_sync`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint NOT NULL COMMENT '租户ID',
    `finished`           bit(1) NOT NULL COMMENT '是否同步结束',
    `success`            bit(1) NOT NULL COMMENT '是否同步成功',
    `start_time`         datetime(6)  DEFAULT NULL COMMENT '同步开始时间',
    `end_time`           datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败原因',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_bdata_sync_tenant` (`sys_tenant_id`)
) COMMENT ='租户基础数据同步记录';


-- `cloudt3-system`.sys_tenant_bdata_sync_detail definition

CREATE TABLE `sys_tenant_bdata_sync_detail`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sync_id`            bigint       NOT NULL COMMENT '同步记录ID',
    `data_type`          varchar(255) NOT NULL COMMENT '数据类型',
    `finished`           bit(1)       NOT NULL COMMENT '是否同步结束',
    `success`            bit(1)       NOT NULL COMMENT '是否同步成功',
    `start_time`         datetime(6)  DEFAULT NULL COMMENT '同步开始时间',
    `end_time`           datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败原因',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_bdata_sync_d_sync` (`sync_id`)
) COMMENT ='租户基础数据迁移记录明细';


-- `cloudt3-system`.sys_tenant_currency definition

CREATE TABLE `sys_tenant_currency`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint       NOT NULL COMMENT '租户ID',
    `curr_code`          varchar(255) NOT NULL COMMENT '货币编码',
    `enabled`            bit(1)       NOT NULL DEFAULT b'0' COMMENT '是否启用',
    `tenant_id`          bigint                DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint                DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint                DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255)          DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint                DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)          DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)           DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint                DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)          DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)           DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int                   DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int                   DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint                DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint                DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint                DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_currency_tenant` (`sys_tenant_id`)
) COMMENT ='租户的货币';


-- `cloudt3-system`.sys_tenant_datasource definition

CREATE TABLE `sys_tenant_datasource`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint NOT NULL COMMENT '租户ID',
    `app_code`           varchar(255) DEFAULT NULL COMMENT '应用编码',
    `def`                bit(1)       DEFAULT NULL COMMENT '是否是默认数据源',
    `use_def`            bit(1)       DEFAULT NULL COMMENT '是否使用默认数据源',
    `ds_url`             varchar(255) DEFAULT NULL COMMENT '连接地址',
    `ds_username`        varchar(255) DEFAULT NULL COMMENT '账号',
    `ds_password`        varchar(255) DEFAULT NULL COMMENT '密码',
    `ds_driver`          varchar(255) DEFAULT NULL COMMENT '驱动类',
    `ds_pool_prop`       varchar(255) DEFAULT NULL COMMENT '连接池配置',
    `enabled`            bit(1)       DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_tenant_ds_tenantapp` (`sys_tenant_id`, `app_code`),
    KEY `idx_tenant_ds_tenantid` (`sys_tenant_id`)
) COMMENT ='租户数据源';


-- `cloudt3-system`.sys_tenant_db_migrate definition

CREATE TABLE `sys_tenant_db_migrate`
(
    `id`                  bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`           bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`       bigint       NOT NULL COMMENT '租户ID',
    `app_code`            varchar(255) NOT NULL COMMENT '应用编码',
    `tenant_isolation`    varchar(255) NOT NULL COMMENT '租户数据隔离策略',
    `database_source_id`  bigint       DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`         varchar(255) DEFAULT NULL COMMENT 'schema名称',
    `migrate_success`     bit(1)       DEFAULT NULL COMMENT '是否已成功',
    `migrate_start_time`  datetime(6)  DEFAULT NULL COMMENT '迁移开始时间',
    `migrate_finish_time` datetime(6)  DEFAULT NULL COMMENT '迁移结束时间',
    `fail_reason`         longtext COMMENT '失败原因',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_db_migrate_tenant_id` (`sys_tenant_id`)
) COMMENT ='租户数据库的创建记录';


-- `cloudt3-system`.sys_tenant_menu definition

CREATE TABLE `sys_tenant_menu`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint          DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint          DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint          DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint          DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int             DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int             DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint          DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint          DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint          DEFAULT NULL COMMENT '数据归属公司id',
    `sys_tenant_id`      bigint NOT NULL COMMENT '租户ID',
    `enabled`            bit(1) NOT NULL DEFAULT b'0' COMMENT '是否启用自定义菜单树',
    `tenant_org_id`      bigint          DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_sys_tenant_menu_tenant` (`sys_tenant_id`)
) COMMENT ='员工';


-- `cloudt3-system`.sys_tenant_menu_tree definition

CREATE TABLE `sys_tenant_menu_tree`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `menu_code`          varchar(255) NOT NULL COMMENT '菜单编码',
    `menu_name`          varchar(255) DEFAULT NULL COMMENT '菜单名称',
    `node_type`          varchar(255) DEFAULT NULL COMMENT '节点类型（MENU-菜单, APP-应用）',
    `parent_menu_code`   varchar(255) DEFAULT NULL COMMENT '父菜单编码',
    `icon`               varchar(255) DEFAULT NULL COMMENT '菜单图标',
    `custom`             bit(1)       DEFAULT b'0' COMMENT '是否自定义菜单',
    `sort_no`            int          DEFAULT '0' COMMENT '排序号',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `enabled`            bit(1)       DEFAULT b'0' COMMENT '是否启用',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_menu_tree_menu` (`menu_code`),
    KEY `idx_tenant_menu_tree_parent` (`parent_menu_code`)
) COMMENT ='自定义菜单树';


-- `cloudt3-system`.sys_tenant_org definition

CREATE TABLE `sys_tenant_org`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `org_id`             bigint NOT NULL COMMENT '组织ID',
    `admin_id`           bigint       DEFAULT NULL COMMENT '管理员用户ID',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_org_org_id` (`org_id`),
    KEY `idx_tenant_org_admin_id` (`admin_id`)
) COMMENT ='租户组织';


-- `cloudt3-system`.sys_tenant_user definition

CREATE TABLE `sys_tenant_user`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys_user_id`        bigint NOT NULL COMMENT '用户ID',
    `sys_tenant_id`      bigint NOT NULL COMMENT '租户ID',
    `bind_time`          datetime(6)  DEFAULT NULL COMMENT '绑定时间',
    `last_login_time`    datetime(6)  DEFAULT NULL COMMENT '上次登录时间',
    `expired_time`       datetime(6)  DEFAULT NULL COMMENT '账号过期时间',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `def`                bit(1)       DEFAULT b'0' COMMENT '是否是默认租户',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_user_user_id` (`sys_user_id`),
    KEY `idx_tenant_user_tenant_id` (`sys_tenant_id`),
    KEY `idx_tenant_user_key` (`sys_user_id`, `sys_tenant_id`)
) COMMENT ='用户与租户的绑定关系';


-- `cloudt3-system`.sys_third_api_business definition

CREATE TABLE `sys_third_api_business`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint       DEFAULT NULL COMMENT '租户ID',
    `business_type`      varchar(255) DEFAULT NULL COMMENT '业务类型',
    `business_key`       varchar(255) DEFAULT NULL COMMENT '业务数据key',
    `success`            bit(1)       DEFAULT b'0' COMMENT '是否成功',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `success_time`       datetime(6)  DEFAULT NULL COMMENT '请求成功时间',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_bus_type` (`business_type`),
    KEY `idx_thirdapi_bus_key` (`business_key`)
) COMMENT ='三方接口调用业务状态';


-- `cloudt3-system`.sys_third_api_log definition

CREATE TABLE `sys_third_api_log`
(
    `id`                     bigint NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`          bigint       DEFAULT NULL COMMENT '租户ID',
    `app_code`               varchar(255) DEFAULT NULL COMMENT '应用编码',
    `restful`                bit(1)       DEFAULT b'1' COMMENT '是否是Restful接口',
    `server`                 bit(1)       DEFAULT b'0' COMMENT '是否是服务端',
    `server_addr`            varchar(255) DEFAULT NULL COMMENT '服务端地址，当不是服务端时，不能为空',
    `client_id`              varchar(255) DEFAULT NULL COMMENT '客户端ID',
    `user_id`                bigint       DEFAULT NULL COMMENT '请求用户ID',
    `username`               varchar(255) DEFAULT NULL COMMENT '请求用户',
    `uri`                    varchar(255) DEFAULT NULL COMMENT '请求的接口地址',
    `req_method`             varchar(255) DEFAULT NULL COMMENT '请求方式',
    `req_query_params_json`  longtext COMMENT '请求的查询参数',
    `req_body`               longtext COMMENT '请求体',
    `req_headers_json`       longtext COMMENT '请求头',
    `req_success`            bit(1)       DEFAULT b'0' COMMENT '是否请求成功',
    `req_fail_msg`           longtext COMMENT '请求失败信息',
    `req_time`               datetime(6)  DEFAULT NULL COMMENT '请求时间',
    `req_ip`                 varchar(255) DEFAULT NULL COMMENT '请求者IP',
    `resp_body`              longtext COMMENT '响应体',
    `resp_success`           bit(1)       DEFAULT b'0' COMMENT '是否响应成功',
    `resp_fail_msg`          longtext COMMENT '响应失败信息',
    `resp_time`              datetime(6)  DEFAULT NULL COMMENT '响应时间',
    `tenant_id`              bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`          bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`          bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                 varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`         bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`            datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`         bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`            datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`            int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`     int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`              bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`            bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`              bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `third_app`              varchar(255) DEFAULT NULL COMMENT '外部应用名称，作为客户端时，不能为空',
    `business_type`          varchar(255) DEFAULT NULL COMMENT '业务类型',
    `business_key`           varchar(255) DEFAULT NULL COMMENT '业务数据key',
    `need_retry`             bit(1)       DEFAULT b'0' COMMENT '是否需要重试',
    `retry_times`            int          DEFAULT '0' COMMENT '重试次数',
    `retry_fail_reason`      longtext COMMENT '重试失败原因',
    `retried`                bit(1)       DEFAULT b'0' COMMENT '是否是重试记录',
    `original_id`            bigint       DEFAULT NULL COMMENT '原始记录ID',
    `last_retry_id`          bigint       DEFAULT NULL COMMENT '最后一次重试的ID',
    `manual_retry`           bit(1)       DEFAULT b'0' COMMENT '是否是手动重试',
    `detected_operator_auth` bit(1)       DEFAULT b'0' COMMENT '自动获取操作人的token',
    `retry_param_json`       longtext COMMENT '重试参数',
    `business_type_name`     varchar(255) DEFAULT NULL COMMENT '业务类型名称',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_log_tenant` (`sys_tenant_id`),
    KEY `idx_thirdapi_log_app` (`app_code`),
    KEY `idx_thirdapi_log_server` (`server`),
    KEY `idx_thirdapi_log_uri` (`uri`),
    KEY `idx_thirdapi_log_reqsuc` (`req_success`),
    KEY `idx_thirdapi_log_respsuc` (`resp_success`),
    KEY `idx_thirdapi_log_third` (`third_app`),
    KEY `idx_thirdapi_log_bustype` (`business_type`),
    KEY `idx_thirdapi_log_buskey` (`business_key`),
    KEY `idx_thirdapi_log_reqtime` (`req_time`)
) COMMENT ='三方接口调用日志';


-- `cloudt3-system`.sys_third_api_retry definition

CREATE TABLE `sys_third_api_retry`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint       DEFAULT NULL COMMENT '租户ID',
    `record_log_id`      bigint       DEFAULT NULL COMMENT '原始记录ID',
    `retry_times`        int          DEFAULT '0' COMMENT '发送重试的次数',
    `send_time`          datetime(6)  DEFAULT NULL COMMENT '上次发送时间',
    `send_time_next`     datetime(6)  DEFAULT NULL COMMENT '下次发送时间',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_thirdapi_log_tenant` (`sys_tenant_id`),
    KEY `idx_thirdapi_log_record` (`record_log_id`)
) COMMENT ='三方接口调用重试记录';


-- `cloudt3-system`.sys_third_party_account definition

CREATE TABLE `sys_third_party_account`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `sys_tenant_id`      bigint       NOT NULL COMMENT '租户ID',
    `name`               varchar(255) NOT NULL COMMENT '账号名称',
    `account`            varchar(255) NOT NULL COMMENT '账号',
    `account_type`       varchar(255) NOT NULL COMMENT '账号类型',
    `enabled`            bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `config_json`        longtext COMMENT 'json格式的配置内容',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `cas_id`             bigint       DEFAULT NULL COMMENT '统一认证中心的ID',
    `business_type`      varchar(255) DEFAULT NULL COMMENT '业务类型',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_third_part_account` (`account`),
    KEY `idx_third_part_tenant` (`sys_tenant_id`),
    KEY `idx_third_part_account_t` (`account_type`)
) COMMENT ='第三方账号';


-- `cloudt3-system`.sys_tmpl definition

CREATE TABLE `sys_tmpl`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `name`                  varchar(255) NOT NULL COMMENT '模板名称',
    `app_code`              varchar(255) NOT NULL COMMENT '应用编码',
    `code_`                 varchar(255) NOT NULL COMMENT '模板编号',
    `file_code`             varchar(255) DEFAULT NULL COMMENT '模板文件标识',
    `file_name`             varchar(255) DEFAULT NULL COMMENT '模板文件名称',
    `export`                bit(1)       DEFAULT b'1' COMMENT '是否是导出模板',
    `head_row`              int          DEFAULT NULL COMMENT '头部所占行数，头部以下都是数据部分',
    `field_type_row`        int          DEFAULT NULL COMMENT '数据字段类型所在行，fieldTypeRow不能大于headRow',
    `enabled`               bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `data_limit_per`        int          DEFAULT '-1' COMMENT '导入数据限制，每次允许导入的记录数量，-1表示无限制',
    `async_threshold`       int          DEFAULT '-1' COMMENT '异步导入阀值，导入数据超过阀值后将转为异步的方式，-1表示无限制',
    `concurrent_limit`      int          DEFAULT '-1' COMMENT '并发限制，同一模板可并发导入的最大数量，-1表示无限制',
    `attribute_list`        longtext COMMENT '属性列表',
    `export_sheet_limit`    int          DEFAULT '1000000' COMMENT '导出时每个sheet限制的记录数，最大100万',
    `export_sheet_strategy` varchar(255) DEFAULT NULL COMMENT '导出时超出sheet限制后的策略',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `std_product`           bit(1)       DEFAULT b'0' COMMENT '是否标产内置',
    `std_version`           varchar(255) DEFAULT NULL COMMENT '标产版本',
    `sheet_nos`             varchar(255) DEFAULT NULL COMMENT '需要解析导入的sheet页，从1开始，多个之间以逗号分隔',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `idx_tmpl_code` (`code_`) USING BTREE,
    KEY `idx_tmpl_app` (`app_code`) USING BTREE
) COMMENT ='导入导出模板';


-- `cloudt3-system`.sys_tmpl_import_file definition

CREATE TABLE `sys_tmpl_import_file`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `record_id`          bigint       NOT NULL COMMENT '导入导出记录ID',
    `tmpl_id`            bigint       NOT NULL COMMENT '模板文件ID',
    `file_code`          varchar(255) NOT NULL COMMENT '文件编码',
    `file_order`         int          DEFAULT '0' COMMENT '文件顺序',
    `file_name`          varchar(255) DEFAULT NULL COMMENT '文件名称',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_tmpl_import_file_tmpl_id` (`tmpl_id`),
    KEY `idx_tmpl_import_file_record_id` (`record_id`)
) COMMENT ='导入导出的文件记录';


-- `cloudt3-system`.sys_tmpl_import_record definition

CREATE TABLE `sys_tmpl_import_record`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tmpl_id`            bigint NOT NULL COMMENT '模板ID',
    `file_code`          varchar(255) DEFAULT NULL COMMENT '文件的标识',
    `export`             bit(1)       DEFAULT b'1' COMMENT '是否是导出',
    `user_id`            bigint       DEFAULT NULL COMMENT '操作用户ID',
    `user_name`          varchar(255) DEFAULT NULL COMMENT '操作用户名称',
    `time_import`        datetime(6)  DEFAULT NULL COMMENT '开始时间',
    `time_finish`        datetime(6)  DEFAULT NULL COMMENT '结束时间',
    `finish`             bit(1)       DEFAULT b'0' COMMENT '是否结束',
    `succ`               bit(1)       DEFAULT b'0' COMMENT '是否成功',
    `fail_reason`        longtext COMMENT '失败原因',
    `num_total`          bigint       DEFAULT '0' COMMENT '总数量',
    `num_suc`            bigint       DEFAULT '0' COMMENT '成功数量',
    `query_param`        longtext COMMENT '查询参数',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `fail_file_code`     varchar(255) DEFAULT NULL COMMENT '失败记录的文件编码',
    `tmpl_code`          varchar(255) DEFAULT NULL COMMENT '模板编码',
    `cost_time_info`     longtext COMMENT '耗时信息',
    `custom_tip_msg`     varchar(255) DEFAULT NULL COMMENT '自定义提示信息',
    PRIMARY KEY (`id`),
    KEY `idx_tmpl_imp_record_tmpl` (`tmpl_id`),
    KEY `idx_tmpl_imp_record_tmplc` (`tmpl_code`)
) COMMENT ='导入导出历史记录';


-- `cloudt3-system`.sys_unify_query_record definition

CREATE TABLE `sys_unify_query_record`
(
    `id`                   bigint NOT NULL COMMENT '记录唯一ID',
    `user_id`              bigint       DEFAULT NULL COMMENT '查询用户ID',
    `query_time`           datetime(6)  DEFAULT NULL COMMENT '查询时间',
    `finish_time`          datetime(6)  DEFAULT NULL COMMENT '查询结束时间',
    `cost_time`            bigint       DEFAULT NULL COMMENT '耗时，毫秒',
    `success`              bit(1)       DEFAULT b'1' COMMENT '是否查询成功',
    `fail_reason`          longtext COMMENT '失败原因',
    `app_code`             varchar(255) DEFAULT NULL COMMENT '所属应用编码',
    `business_object_code` varchar(255) DEFAULT NULL COMMENT '查询业务对象编码',
    `business_fields`      varchar(255) DEFAULT NULL COMMENT '查询业务字段',
    `business_params`      varchar(255) DEFAULT NULL COMMENT '查询业务参数',
    `query_type`           varchar(255) DEFAULT NULL COMMENT '查询类型',
    `sql_txt`              longtext COMMENT 'SQL',
    `sql_params`           longtext COMMENT 'SQL参数',
    `query_result`         longtext COMMENT '查询结果',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_unifyquery_rd_user` (`user_id`),
    KEY `idx_unifyquery_rd_app` (`app_code`),
    KEY `idx_unifyquery_rd_bus` (`business_object_code`),
    KEY `idx_unifyquery_rd_querytime` (`query_time`)
) COMMENT ='统一查询记录';


-- `cloudt3-system`.sys_user definition

CREATE TABLE `sys_user`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `tenant_id`             bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `username`              varchar(255) NOT NULL COMMENT '登录账号',
    `password`              varchar(255) NOT NULL COMMENT '登录密码',
    `need_reset`            bit(1)       DEFAULT b'1' COMMENT '密码是否需要重新设置',
    `last_name`             varchar(255) DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`            varchar(255) DEFAULT NULL COMMENT '姓名-名字',
    `gender`                varchar(255) DEFAULT NULL COMMENT '性别，（male-男，female-女，secret-保密）',
    `nick_name`             varchar(255) DEFAULT NULL COMMENT '昵称',
    `birth_date`            date         DEFAULT NULL COMMENT '生日',
    `mobile`                varchar(255) DEFAULT NULL COMMENT '手机号',
    `email`                 varchar(255) DEFAULT NULL COMMENT '邮箱',
    `enabled`               bit(1)       DEFAULT b'1' COMMENT '是否启用',
    `last_login_time`       datetime(6)  DEFAULT NULL COMMENT '上次登录时间',
    `expired_time`          datetime(6)  DEFAULT NULL COMMENT '账号过期时间',
    `id_card`               varchar(255) DEFAULT NULL COMMENT '身份证号',
    `province_code`         varchar(255) DEFAULT NULL COMMENT '省编码',
    `city_code`             varchar(255) DEFAULT NULL COMMENT '市编码',
    `address`               varchar(255) DEFAULT NULL COMMENT '详细地址',
    `personal_sign`         varchar(255) DEFAULT NULL COMMENT '个性签名',
    `source_type`           varchar(255) DEFAULT NULL COMMENT '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    `avatar_url`            longtext COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`           varchar(255) DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `sync_cas`              bit(1)       DEFAULT b'1' COMMENT '是否需要向统一身份认证中心同步',
    `cas_user_id`           bigint       DEFAULT NULL COMMENT '在统一身份认证中心的ID',
    `password_expired_time` datetime(6)  DEFAULT NULL COMMENT '密码过期时间',
    `county_code`           varchar(255) DEFAULT NULL COMMENT '县编码',
    `user_type`             varchar(255) DEFAULT NULL COMMENT '用户类型',
    `country_code`          varchar(255) DEFAULT NULL COMMENT '国家编码',
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_sys_user_username` (`username`),
    KEY `idx_sys_user_mobile` (`mobile`),
    KEY `idx_sys_user_email` (`email`),
    KEY `idx_sys_user_source` (`source_type`),
    KEY `idx_sys_user_cas_user` (`cas_user_id`)
) COMMENT ='系统用户账号';


-- `cloudt3-system`.sys_user_company definition

CREATE TABLE `sys_user_company`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `sys_user_id`        bigint       DEFAULT NULL COMMENT '用户ID',
    `ou_id`              bigint       DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(255) DEFAULT NULL COMMENT '公司编码',
    `ou_name`            varchar(255) DEFAULT NULL COMMENT '公司名称',
    `bind_time`          datetime(6)  DEFAULT NULL COMMENT '绑定时间',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_company_user_id` (`sys_user_id`),
    KEY `idx_sys_user_company_ou_id` (`ou_id`)
) COMMENT ='用户与公司关联表';


-- `cloudt3-system`.sys_user_role definition

CREATE TABLE `sys_user_role`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint NOT NULL COMMENT '用户ID',
    `role_id`            bigint NOT NULL COMMENT '角色ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_role_user_id` (`user_id`),
    KEY `idx_sys_user_role_role_id` (`role_id`)
) COMMENT ='用户角色关联表';


-- `cloudt3-system`.sys_user_terminal definition

CREATE TABLE `sys_user_terminal`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `user_id`            bigint       DEFAULT NULL COMMENT '用户ID',
    `terminal_code`      varchar(255) DEFAULT NULL COMMENT '终端编码，Terminal枚举类',
    `time_bind`          datetime(6)  DEFAULT NULL COMMENT '绑定时间',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_terminal_user` (`user_id`)
) COMMENT ='用户与终端的关联';


-- `cloudt3-system`.sys_user_type definition

CREATE TABLE `sys_user_type`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint       NOT NULL COMMENT '用户ID',
    `type`               varchar(255) NOT NULL COMMENT '用户类型',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `sys_tenant_id`      bigint       DEFAULT NULL COMMENT '所属租户',
    `identity_id`        varchar(255) DEFAULT NULL COMMENT '身份ID',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_type_user_id` (`user_id`),
    KEY `idx_sys_user_type_type` (`type`),
    KEY `idx_sys_user_type_idt` (`identity_id`)
) COMMENT ='用户类型';


-- `cloudt3-system`.sys_version definition

CREATE TABLE `sys_version`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `version_no`         varchar(255) NOT NULL COMMENT '版本号',
    `describe_msg`       varchar(255) DEFAULT NULL COMMENT '版本描述',
    `release_time`       datetime(6)  DEFAULT NULL COMMENT '发布时间',
    `change_content`     varchar(255) DEFAULT NULL COMMENT '变更日志',
    `status`             bit(1)       DEFAULT NULL COMMENT '生效状态',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT NULL COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`)
) COMMENT ='标产版本';


-- `cloudt3-system`.sys_watermark_config definition

CREATE TABLE `sys_watermark_config`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT NULL COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '记录最后更新时间',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `dynamic_font`       varchar(255) DEFAULT NULL COMMENT '动态文字',
    `custom_field`       varchar(255) DEFAULT NULL COMMENT '自定义文字',
    `font_size`          int          DEFAULT NULL COMMENT '文字大小',
    `font_color`         varchar(255) DEFAULT NULL COMMENT '颜色深浅',
    `rotate`             int          DEFAULT NULL COMMENT '旋转角度',
    `stacking_deep`      int          DEFAULT NULL COMMENT '层叠深度',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    PRIMARY KEY (`id`)
) COMMENT ='系统水印配置';


-- `cloudt3-system`.sys_website_appearance definition

CREATE TABLE `sys_website_appearance`
(
    `id`                      bigint NOT NULL COMMENT '记录唯一ID',
    `title`                   varchar(32)   DEFAULT NULL COMMENT '浏览器标题',
    `type`                    varchar(32)   DEFAULT NULL COMMENT '网站类型',
    `browser_logo_id`         varchar(64)   DEFAULT NULL COMMENT '浏览器logo图片id',
    `webpage_logo_id`         varchar(64)   DEFAULT NULL COMMENT '网页logo图片id',
    `theme_color`             varchar(20)   DEFAULT NULL COMMENT '网站主题色',
    `font_size`               int           DEFAULT '12' COMMENT '字体大小',
    `language`                varchar(32)   DEFAULT 'zh_CN' COMMENT '默认语言，默认中文',
    `multi_language_flag`     tinyint(1)    DEFAULT '1' COMMENT '是否支持多语言：1是，0否',
    `menu_unfold_flag`        tinyint(1)    DEFAULT '1' COMMENT '菜单是否展开：1是，0否',
    `menu_width`              int           DEFAULT NULL COMMENT '菜单区域宽度',
    `description`             varchar(2048) DEFAULT NULL COMMENT '网站描述',
    `tenant_id`               bigint        DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`           bigint        DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`           bigint        DEFAULT NULL COMMENT '租户组织ID',
    `remark`                  varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`          bigint        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`                 varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`             datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`          bigint        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`                 varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`             datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`             int           DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`      int           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`               bigint        DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`             bigint        DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`               bigint        DEFAULT NULL COMMENT '数据归属公司id',
    `table_double_click_edit` bit(1)        DEFAULT b'1' COMMENT '表格双击后编辑',
    PRIMARY KEY (`id`)
) COMMENT ='网站外观配置信息表';


-- `cloudt3-system`.sys_website_bar definition

CREATE TABLE `sys_website_bar`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `bar_name`           varchar(32)  DEFAULT NULL COMMENT '栏位名称',
    `bar_type`           varchar(32)  DEFAULT NULL COMMENT '栏位类型',
    `bar_code`           varchar(32)  DEFAULT NULL COMMENT '栏位编码',
    `target_type`        varchar(32)  DEFAULT NULL COMMENT '目标类型',
    `window_open_mode`   varchar(32)  DEFAULT NULL COMMENT '打开方式',
    `home_page_flag`     tinyint(1)   DEFAULT '0' COMMENT '是否为首页：1是，0否',
    `mall_mode`          varchar(32)  DEFAULT NULL COMMENT '适用商城',
    `link_address`       varchar(255) DEFAULT NULL COMMENT '链接地址',
    `link_address_id`    bigint       DEFAULT NULL COMMENT '链接地址',
    `link_type`          varchar(32)  DEFAULT NULL COMMENT '链接类型',
    `show_flag`          tinyint(1)   DEFAULT '1' COMMENT '是否显示：1是，0否',
    `sort_no`            int          DEFAULT NULL COMMENT '排序',
    `pid`                bigint       DEFAULT NULL COMMENT '上级id',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `p_name`             varchar(256) DEFAULT NULL COMMENT '上级栏目名称',
    PRIMARY KEY (`id`)
) COMMENT ='网站栏目配置';

-- `cloudt3-system`.sys_user_sync definition

CREATE TABLE `sys_user_sync`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint       NOT NULL COMMENT '账户ID',
    `outer_sys_code`     varchar(255) NOT NULL COMMENT '外部系统编码',
    `sync_time`          datetime(6)  DEFAULT NULL COMMENT '同步时间',
    `sync_success`       bit(1)       DEFAULT b'0' COMMENT '是否同步成功',
    `sync_finish_time`   datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败信息',
    `fail_reason_detail` longtext COMMENT '同步失败的详细信息',
    `receipt`            longtext COMMENT '回执信息',
    `outer_user_id`      varchar(255) DEFAULT NULL COMMENT '外部系统用户ID',
    `outer_user_code`    varchar(255) DEFAULT NULL COMMENT '外部系统用户编码',
    `sync_url`           varchar(255) DEFAULT NULL COMMENT '同步接口地址',
    `sync_data`          longtext COMMENT '同步的数据信息',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_sync_outersys` (`outer_sys_code`),
    KEY `idx_sys_user_sync_user` (`user_id`),
    KEY `idx_sys_user_sync_time` (`sync_time`)
) COMMENT ='账号同步记录';

-- `cloudt3-system`.sys_user_sync_record definition

CREATE TABLE `sys_user_sync_record`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `outer_sys_code`     varchar(255) NOT NULL COMMENT '外部系统编码',
    `user_id`            bigint       DEFAULT NULL COMMENT '账户ID',
    `username`           varchar(255) DEFAULT NULL COMMENT '登录号',
    `last_name`          varchar(255) DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`         varchar(255) DEFAULT NULL COMMENT '姓名-名字',
    `mobile`             varchar(255) DEFAULT NULL COMMENT '手机号',
    `email`              varchar(255) DEFAULT NULL COMMENT '邮箱',
    `id_card`            varchar(255) DEFAULT NULL COMMENT '身份证号',
    `sync_time`          datetime(6)  DEFAULT NULL COMMENT '同步时间',
    `sync_success`       bit(1)       DEFAULT b'0' COMMENT '是否同步成功',
    `sync_finish_time`   datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败信息',
    `fail_reason_detail` longtext COMMENT '同步失败的详细信息',
    `receipt`            longtext COMMENT '回执信息',
    `outer_user_id`      varchar(255) DEFAULT NULL COMMENT '外部系统用户ID',
    `outer_user_code`    varchar(255) DEFAULT NULL COMMENT '外部系统用户编码',
    `sync_url`           varchar(255) DEFAULT NULL COMMENT '同步接口地址',
    `sync_data`          longtext COMMENT '同步的数据信息',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_syncrd_outersys` (`outer_sys_code`),
    KEY `idx_sys_user_syncrd_user` (`user_id`),
    KEY `idx_sys_user_syncrd_username` (`username`),
    KEY `idx_sys_user_syncrd_time` (`sync_time`)
) COMMENT ='账号同步记录';