/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.datadiff.log.domain;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogConvert;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogDomainService;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogRepo;
import com.elitescloud.cloudt.datadiff.log.domain.SysDataModifyLogRepoProc;
import com.elitescloud.cloudt.datadiff.log.entity.SysDataModifyLogDO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogPageParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogParamVO;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogPageRespVO;
import com.elitescloud.cloudt.datadiff.log.resp.SysDataModifyLogRespVO;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDataModifyLogDomainServiceImpl
implements SysDataModifyLogDomainService {
    private static final Logger log = LoggerFactory.getLogger(SysDataModifyLogDomainServiceImpl.class);
    private final SysDataModifyLogRepo sysDataModifyLogRepo;
    private final SysDataModifyLogRepoProc sysDataModifyLogRepoProc;

    @Override
    public PagingVO<SysDataModifyLogPageRespVO> queryList(SysDataModifyLogPageParamVO paramVO) {
        long count = this.sysDataModifyLogRepoProc.countBy(paramVO);
        if (count > 0L) {
            List<SysDataModifyLogPageRespVO> list = this.sysDataModifyLogRepoProc.pageBy(paramVO);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public Optional<SysDataModifyLogDTO> findById(Long id) {
        return this.sysDataModifyLogRepo.findById(id).map(SysDataModifyLogConvert.INSTANCE::doToDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(SysDataModifyLogSaveVO saveVO) {
        if (saveVO.getId() == null) {
            SysDataModifyLogDO sysDataModifyLogDO = SysDataModifyLogConvert.INSTANCE.saveVoToDO(saveVO);
            return ((SysDataModifyLogDO)this.sysDataModifyLogRepo.save(sysDataModifyLogDO)).getId();
        }
        Optional option = this.sysDataModifyLogRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        SysDataModifyLogDO sysDataModifyLogDO = (SysDataModifyLogDO)option.get();
        SysDataModifyLogConvert.INSTANCE.copySaveParamToDo(saveVO, sysDataModifyLogDO);
        return ((SysDataModifyLogDO)this.sysDataModifyLogRepo.save(sysDataModifyLogDO)).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.sysDataModifyLogRepoProc.deleteByIds(ids);
    }

    @Override
    public List<SysDataModifyLogRespVO> findByParam(SysDataModifyLogParamVO paramVO) {
        return this.sysDataModifyLogRepoProc.findByParam(paramVO);
    }

    public SysDataModifyLogDomainServiceImpl(SysDataModifyLogRepo sysDataModifyLogRepo, SysDataModifyLogRepoProc sysDataModifyLogRepoProc) {
        this.sysDataModifyLogRepo = sysDataModifyLogRepo;
        this.sysDataModifyLogRepoProc = sysDataModifyLogRepoProc;
    }
}

