/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public class SystemUserDetailManager
extends AbstractUserDetailManager {
    private static final Logger log = LoggerFactory.getLogger(SystemUserDetailManager.class);
    private final UserQueryService userQueryService;
    private final UserMngManager userMngManager;

    public SystemUserDetailManager(AuthorizationProperties authorizationProperties, UserQueryService userQueryService, UserMngManager userMngManager) {
        super(authorizationProperties);
        this.userQueryService = userQueryService;
        this.userMngManager = userMngManager;
    }

    public GeneralUserDetails loadUserByUsername(@NotBlank String s) {
        return this.loadUser(() -> this.userQueryService.getUserByUsername(s));
    }

    public GeneralUserDetails loadUserByMobile(String s) {
        return this.loadUser(() -> this.userQueryService.getUserByMobile(s));
    }

    public GeneralUserDetails loadUserByEmail(String s) {
        return this.loadUser(() -> this.userQueryService.getUserByEmail(s));
    }

    public GeneralUserDetails loadUserById(String s) {
        return this.loadUser(() -> this.userQueryService.getUserById(Long.parseLong(s)));
    }

    public GeneralUserDetails loadUserByAccount(String s) {
        return this.loadUser(() -> this.userQueryService.getUserByAccount(s));
    }

    public GeneralUserDetails loadUserByWechatOpenid(String s) {
        return this.loadUser(() -> this.userQueryService.getUserByWechatOpenid(s));
    }

    public GeneralUserDetails loadUserByOpenId(String appId, String openId) {
        return this.loadUser(() -> this.userQueryService.getUserByOpenId(appId, openId));
    }

    public GeneralUserDetails registerOnLoadUserByMobileNotFound(@NotBlank String mobile) {
        SysUserDTO user = this.userQueryService.getUserByMobile(mobile);
        if (user != null) {
            return this.loadUser(() -> user);
        }
        log.info("\u81ea\u52a8\u6ce8\u518c\u7528\u6237\uff1a{}", (Object)mobile);
        SysUserSaveBO saveBO = new SysUserSaveBO();
        saveBO.setUsername(this.generateUsername());
        saveBO.setMobile(mobile);
        saveBO.setEnabled(Boolean.valueOf(true));
        saveBO.setSourceType(UserSourceType.REGISTER.getValue());
        String userType = this.obtainRegisteredUserType();
        if (CharSequenceUtil.isNotBlank((CharSequence)userType)) {
            saveBO.setUserTypesAdd(Set.of(new SysUserTypeBO(userType)));
        }
        SysUserDO userDO = (SysUserDO)((TransactionTemplate)SpringContextHolder.getBean(TransactionTemplate.class)).execute(status -> this.userMngManager.upsert(saveBO));
        return this.loadUser(() -> this.userQueryService.getUserById(userDO.getId()));
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier) {
        SysUserDTO user = userDTOSupplier.get();
        if (user == null) {
            return null;
        }
        return super.wrapUserDetails(user);
    }

    private String generateUsername() {
        String username;
        while (this.userQueryService.getIdByUsername(username = "auto_" + RandomUtil.randomString((int)15)).computeData() != null) {
        }
        return username;
    }

    private String obtainRegisteredUserType() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        String userType = request.getParameter("user_type");
        if (CharSequenceUtil.isBlank((CharSequence)userType)) {
            return null;
        }
        Map udcMap = ((UdcProvider)SpringContextHolder.getBean(UdcProvider.class)).getValueMapByUdcCode(UserType.ADMIN_SYSTEM.getAppCode(), UserType.ADMIN_SYSTEM.getUdcCode());
        if (udcMap.containsKey(userType)) {
            return userType;
        }
        log.warn("\u7528\u6237\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a{}", (Object)userType);
        return null;
    }
}

