/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.cas;

import com.elitescloud.boot.auth.cas.UserSourceProvider;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.system.cas.BaseCasClientService;
import com.elitescloud.cloudt.system.service.IUserService;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

class SystemUserSyncProvider
extends BaseCasClientService
implements UserSourceProvider {
    private static final Logger log = LogManager.getLogger(SystemUserSyncProvider.class);
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private IUserService userService;
    @Autowired
    private AuthorizationSdkProperties sdkProperties;

    SystemUserSyncProvider() {
    }

    public List<AuthUserDTO> queryUserList(int size) {
        return this.userRepoProc.queryToSyncCas(size).stream().map(t -> {
            AuthUserDTO dto = super.do2Dto((SysUserDO)t);
            if (Boolean.TRUE.equals(this.sdkProperties.getCasClient().getSupportEncodedPassword())) {
                dto.setPasswordEncoded(t.getPassword());
            }
            return dto;
        }).collect(Collectors.toList());
    }

    public void successCallback(Map<String, Long> userMap) {
        this.userService.updateCasSyncResult(userMap);
    }
}

