/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.common;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.common.AccessToken;
import com.elitescloud.cloudt.system.util.BeanUtils;
import com.elitescloud.cloudt.system.util.ExceptionUtils;
import com.elitescloud.cloudt.system.util.RedisUtil;
import com.elitescloud.cloudt.system.util.RestWrapper;
import com.elitescloud.cloudt.system.util.StringUtils;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Client {
    private static final Logger log = LoggerFactory.getLogger(OAuth2Client.class);
    private final RestWrapper restWrapper;
    private final RedisUtil redisUtil;

    public String getAccessToken(String platformCode, String url, String clientId, String clientSecret) {
        String tokenKey = StringUtils.tenantKey(platformCode, clientId);
        String cacheToken = this.redisUtil.getString(tokenKey);
        if (StrUtil.isNotBlank((CharSequence)cacheToken)) {
            log.info("[BPMN][INFINITY] CacheToken(" + tokenKey + "): ", (Object)cacheToken);
            return cacheToken;
        }
        return this.createAccessToken(platformCode, url, clientId, clientSecret);
    }

    private String createAccessToken(String platformCode, String url, String clientId, String clientSecret) {
        AccessToken token = this.authentication(url, clientId, clientSecret, AccessToken.class);
        String accessToken = token.getAccessToken();
        Long expiresIn = token.getExpiresIn();
        log.info("[BPMN][INFINITY] AccessToken: ", (Object)accessToken);
        log.info("[BPMN][INFINITY] ExpiresIn: ", (Object)expiresIn);
        if (expiresIn > 10L) {
            this.redisUtil.set(StringUtils.tenantKey(platformCode, clientId), accessToken, expiresIn - 5L, TimeUnit.SECONDS);
        }
        return accessToken;
    }

    public String authentication(String url, String clientId, String clientSecret) {
        String accessToken = this.authentication(url, clientId, clientSecret, String.class);
        log.info("[BPMN][INFINITY] AccessToken: ", (Object)accessToken);
        return accessToken;
    }

    public <T> T authentication(String url, String clientId, String clientSecret, Class<T> clazz) {
        log.info("[BPMN][INFINITY] Url: ", (Object)url);
        log.info("[BPMN][INFINITY] ClientId: ", (Object)clientId);
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("grant_type", "client_credentials");
            param.put("client_id", clientId);
            param.put("client_secret", clientSecret);
            String result = this.restWrapper.postFormUrlencoded(url, param);
            return BeanUtils.toBean(result, clazz);
        }
        catch (Exception e) {
            log.error("[BPMN][INFINITY] \u8ba4\u8bc1\u5931\u8d25\uff1a", (Object)ExceptionUtils.formatException(e));
            throw new RuntimeException(e);
        }
    }

    public OAuth2Client(RestWrapper restWrapper, RedisUtil redisUtil) {
        this.restWrapper = restWrapper;
        this.redisUtil = redisUtil;
    }
}

