/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config;

import com.elitescloud.cloudt.system.common.InfinityWebProperties;
import com.elitescloud.cloudt.system.common.OAuth2Client;
import com.elitescloud.cloudt.system.service.impl.InfinityRestClient;
import com.elitescloud.cloudt.system.util.RedisUtil;
import com.elitescloud.cloudt.system.util.RestWrapper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
@EnableConfigurationProperties(value={InfinityWebProperties.class})
@ConditionalOnProperty(prefix="cbpl.infinity.web", name={"enabled"}, havingValue="true")
public class InfinityWebAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(InfinityWebAutoConfiguration.class);

    @Bean
    @ConditionalOnClass
    public OAuth2Client oAuth2Client(RestWrapper restWrapper, RedisUtil redisUtil) {
        return new OAuth2Client(restWrapper, redisUtil);
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(InfinityWebProperties properties) {
        HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)InfinityWebProperties.CONNECT_TIMEOUT)).responseTimeout(Duration.ofMillis(InfinityWebProperties.RESPONSE_TIMEOUT)).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)InfinityWebProperties.READ_TIMEOUT, TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)InfinityWebProperties.WRITE_TIMEOUT, TimeUnit.MILLISECONDS)));
        if (properties.isIgnoreSslSecure()) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                httpClient.secure(ssl -> ssl.sslContext(sslContext));
            }
            catch (SSLException e) {
                log.error("\u5ffd\u7565\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(0x6400000)).build()).build();
    }

    @Bean
    public InfinityRestClient infinityRestClient(WebClient webClient) {
        return new InfinityRestClient(webClient);
    }
}

