/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.jpa.config.auditing.AuditCustomizer;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.SysVersionService;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import com.elitescloud.cloudt.system.service.model.BaseStdTreeModel;
import org.springframework.stereotype.Component;

@Component
public class SystemAuditCustomizer
implements AuditCustomizer {
    private final SystemProperties.StdProject prop;
    private final SysVersionService versionService;

    public SystemAuditCustomizer(SystemProperties properties, SysVersionService versionService) {
        this.prop = properties.getStdProject();
        this.versionService = versionService;
    }

    public void onCreate(Object source) {
        if (!this.needRecordStd()) {
            return;
        }
        if (source instanceof BaseStdModel) {
            BaseStdModel model = (BaseStdModel)source;
            model.setStdProduct(Boolean.valueOf(true));
            model.setStdVersion(this.obtainCurrentVersion());
            return;
        }
        if (source instanceof BaseStdTreeModel) {
            BaseStdTreeModel model = (BaseStdTreeModel)source;
            model.setStdProduct(Boolean.valueOf(true));
            model.setStdVersion(this.obtainCurrentVersion());
        }
    }

    public void onUpdate(Object source) {
    }

    private boolean needRecordStd() {
        if (!Boolean.TRUE.equals(this.prop.getEnabled())) {
            return false;
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return false;
        }
        if (InnerUserEnum.ADMIN.getUsername().equals(currentUser.getUsername())) {
            return true;
        }
        SysTenantDTO tenant = currentUser.getTenant();
        return tenant != null && tenant.getTenantCode().equals(this.prop.getTenantCode());
    }

    private String obtainCurrentVersion() {
        return (String)this.versionService.findActiveVersion().getData();
    }
}

