/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config.support;

import com.elitescloud.boot.mq.common.MessageRetryProvider;
import com.elitescloud.boot.mq.common.model.RetryMessageDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysMqSendResultDTO;
import com.elitescloud.cloudt.system.service.SysMqMessageMngService;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={MessageRetryProvider.class})
public class SystemMqMessageRetryProvider
implements MessageRetryProvider {
    private static final Logger log = LoggerFactory.getLogger(SystemMqMessageRetryProvider.class);
    @Autowired
    private SysMqMessageMngService messageMngService;

    public List<RetryMessageDTO> queryTask(String lastMessageId, int size) {
        ApiResult<List<RetryMessageDTO>> msgRes = this.messageMngService.queryRetryMessage(lastMessageId, size);
        if (msgRes.isFailed()) {
            log.error("\u67e5\u8be2\u5f85\u91cd\u8bd5\u6d88\u606f\u5f02\u5e38\uff1a{}", (Object)msgRes.getMsg());
        }
        return (List)msgRes.getData();
    }

    public void deleteTask(@NotBlank String messageId, String reason) {
        log.info("\u5220\u9664\u91cd\u8bd5\u6d88\u606f\uff1a{}, {}", (Object)messageId, (Object)reason);
        ApiResult<Boolean> res = this.messageMngService.deleteRetryMessage(messageId, reason);
        log.info("\u5220\u9664\u91cd\u8bd5\u6d88\u606f\u7ed3\u679c\uff1a{}\uff0c{}", (Object)messageId, (Object)res.getMsg());
    }

    public boolean trySend(@NotBlank String messageId, Integer version) {
        ApiResult<Boolean> res = this.messageMngService.trySend(messageId, version);
        log.info("\u6d88\u606f\u662f\u5426\u53ef\u53d1\u9001\uff1a{}\uff0c{}\uff0c{}", new Object[]{messageId, res.getData(), res.getMsg()});
        if (res.isSuccess()) {
            return Boolean.TRUE.equals(res.getData());
        }
        return true;
    }

    public void updateRetryResult(@NotBlank String messageId, boolean success, String reason) {
        log.info("\u66f4\u65b0\u6d88\u606f\u91cd\u8bd5\u7ed3\u679c\uff1a{}\uff0c{}\uff0c{}", new Object[]{messageId, success, reason});
        SysMqSendResultDTO sysMqSendResultDTO = new SysMqSendResultDTO();
        sysMqSendResultDTO.setMessageId(messageId);
        sysMqSendResultDTO.setSuccess(Boolean.valueOf(success));
        sysMqSendResultDTO.setFailReason(reason);
        this.messageMngService.updateSendResult(sysMqSendResultDTO);
    }
}

