/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.boot.auth.provider.security.AuthenticationCheckService;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.service.repo.SysSettingRepoProc;
import com.elitescloud.cloudt.system.util.HttpServletUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class UserTypeClientAuthenticationCheckService<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private static final Logger logger = LoggerFactory.getLogger(UserTypeClientAuthenticationCheckService.class);
    @Autowired
    private SysSettingRepoProc settingRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        if (userDetails.isSystemAdmin() || userDetails.isTenantAdmin()) {
            return;
        }
        String settingValue = (String)this.tenantDataIsolateProvider.byTenantDirectly(() -> this.settingRepoProc.getSettingValBySettingNo("sys_userType_loginClient"), userDetails.getTenant());
        if (CharSequenceUtil.isBlank((CharSequence)settingValue)) {
            return;
        }
        String clientId = this.obtainClientId();
        logger.debug("\u767b\u5f55\u7ec8\u7aef\uff1a{}", (Object)clientId);
        if (CharSequenceUtil.isBlank((CharSequence)clientId)) {
            return;
        }
        List cfgList = (List)JSONUtil.json2Obj((String)settingValue, (TypeReference)new TypeReference<List<UserTypeClientCfg>>(){});
        if (CollUtil.isEmpty((Collection)cfgList)) {
            throw new AuthorizationException("\u8d26\u53f7\u7c7b\u578b\u4e0e\u767b\u5f55\u5ba2\u6237\u7aef\u7684\u914d\u7f6e\u6709\u8bef, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        for (UserTypeClientCfg cfg : cfgList) {
            if (!clientId.equals(cfg.getClientId())) continue;
            if (CollUtil.isEmpty(cfg.getUserTypes())) {
                throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u767b\u5f55\u8be5\u5ba2\u6237\u7aef");
            }
            if (cfg.getUserTypes().contains("*")) {
                return;
            }
            if (CollUtil.isEmpty((Collection)userDetails.getUser().getUserTypeList())) {
                throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u767b\u5f55\u8be5\u5ba2\u6237\u7aef");
            }
            for (SysUserType userType : userDetails.getUser().getUserTypeList()) {
                if (!cfg.getUserTypes().contains(userType.getUserType())) continue;
                return;
            }
            throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u767b\u5f55\u8be5\u5ba2\u6237\u7aef");
        }
        throw new AuthorizationException("\u767b\u5f55\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u767b\u5f55\u8be5\u5ba2\u6237\u7aef");
    }

    private String obtainClientId() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        String clientId = request.getParameter("client_id");
        if (CharSequenceUtil.isNotBlank((CharSequence)clientId)) {
            return clientId;
        }
        return (String)request.getAttribute("cloudtClientId");
    }

    static class UserTypeClientCfg
    implements Serializable {
        private static final long serialVersionUID = 8476309616466393193L;
        private String clientId;
        private List<String> userTypes;

        UserTypeClientCfg() {
        }

        public String getClientId() {
            return this.clientId;
        }

        public List<String> getUserTypes() {
            return this.userTypes;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setUserTypes(List<String> userTypes) {
            this.userTypes = userTypes;
        }
    }
}

