/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config.support.userouterapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.elitescloud.boot.auth.provider.common.AlipayAppProvider;
import com.elitescloud.boot.auth.provider.common.param.AlipayApp;
import com.elitescloud.boot.auth.provider.provider.alipay.AlipayTemplate;
import com.elitescloud.cloudt.system.service.common.service.UserOuterAppProvider;
import com.elitescloud.cloudt.system.service.dto.SysUserOuterAppDTO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"alipayUserOuterAppProvider"})
public class AlipayUserOuterAppProvider
implements UserOuterAppProvider {
    private static final Logger logger = LoggerFactory.getLogger(AlipayUserOuterAppProvider.class);
    @Autowired
    private AlipayAppProvider alipayAppProvider;
    @Autowired
    private AlipayTemplate alipayTemplate;

    public SysUserOuterAppDTO get(String appId, HttpServletRequest request) {
        AlipayApp app = this.alipayAppProvider.getApp(appId);
        if (app == null) {
            return null;
        }
        String code = request.getParameter("code");
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            logger.info("\u652f\u4ed8\u5b9d\u6388\u6743\u7801\u4e3a\u7a7a");
            return null;
        }
        AlipaySystemOauthTokenResponse oauthTokenResponse = this.alipayTemplate.oauthToken(appId, code);
        SysUserOuterAppDTO outerAppDTO = new SysUserOuterAppDTO();
        if (app.isPreferUserId()) {
            outerAppDTO.setOpenId(CharSequenceUtil.blankToDefault((CharSequence)oauthTokenResponse.getUserId(), (String)oauthTokenResponse.getOpenId()));
        } else {
            outerAppDTO.setOpenId(oauthTokenResponse.getOpenId());
        }
        outerAppDTO.setUnionId(oauthTokenResponse.getUnionId());
        return outerAppDTO;
    }
}

