/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.config.support.userouterapp;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.provider.common.WechatAppProvider;
import com.elitescloud.boot.auth.provider.common.param.WechatApp;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.auth.provider.provider.wechat.param.WechatOpenIdAndUnionId;
import com.elitescloud.cloudt.system.service.common.service.UserOuterAppProvider;
import com.elitescloud.cloudt.system.service.dto.SysUserOuterAppDTO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"wechatUserOuterAppProvider"})
public class WechatUserOuterAppProvider
implements UserOuterAppProvider {
    private static final Logger logger = LoggerFactory.getLogger(WechatUserOuterAppProvider.class);
    @Autowired
    private WechatAppProvider appProvider;
    @Autowired
    private WechatTemplate template;

    public SysUserOuterAppDTO get(String appId, HttpServletRequest request) {
        WechatApp app = this.appProvider.getApp(appId);
        if (app == null) {
            return null;
        }
        String code = request.getParameter("code");
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            logger.info("\u5fae\u4fe1\u6388\u6743\u7801\u4e3a\u7a7a");
            return null;
        }
        WechatOpenIdAndUnionId info = this.template.getOpenId(appId, code);
        if (info == null) {
            return null;
        }
        SysUserOuterAppDTO userOuterAppDTO = new SysUserOuterAppDTO();
        userOuterAppDTO.setOpenId(info.getOpenId());
        userOuterAppDTO.setUnionId(info.getUnionId());
        return userOuterAppDTO;
    }
}

