/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.common.user;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.model.vo.save.index.ModifyPasswordSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.index.PasswordUpdateSaveVO;
import com.elitescloud.cloudt.system.service.IndexUserService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u901a\u7528\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/common/user"}, produces={"application/json"})
@Validated
public class UserCommonController {
    private final IndexUserService indexUserService;

    public UserCommonController(IndexUserService indexUserService) {
        this.indexUserService = indexUserService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/currentUser"})
    public ApiResult<SysUserDTO> currentUser() {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        currentUser.getUser().setPassword(null);
        return ApiResult.ok((Object)currentUser.getUser());
    }

    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u7528\u6237\u5bc6\u7801\u3010\u901a\u8fc7\u8001\u5bc6\u7801\u3011")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/update/currentPwd"})
    public ApiResult<Boolean> updatePassword(@RequestBody ModifyPasswordSaveVO saveVO) {
        return this.indexUserService.updatePassword(saveVO);
    }

    @ApiOperation(value="\u3010\u4fee\u6539\u5bc6\u7801\u3011\u4fee\u6539\u5bc6\u7801\u7684\u53d1\u9001\u9a8c\u8bc1\u7801")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/updatePwd/sendCode"})
    public ApiResult<String> sendVerifyCodeForUpdatePwd(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return this.indexUserService.sendVerifyCodeForUpdatePwd(false, verifyCodeParam);
    }

    @ApiOperation(value="\u3010\u4fee\u6539\u5bc6\u7801\u3011\u6839\u636e\u9a8c\u8bc1\u7801\u4fee\u6539\u5bc6\u7801")
    @ApiOperationSupport(order=4)
    @PutMapping(value={"/updatePwd/verifyCode"})
    public ApiResult<Long> updatePwd(@RequestBody @Valid PasswordUpdateSaveVO saveVO) {
        return this.indexUserService.updatePwdByVerifyCode(false, saveVO);
    }

    @ApiOperation(value="\u3010\u627e\u56de\u5bc6\u7801\u3011\u627e\u56de\u5bc6\u7801\u7684\u53d1\u9001\u9a8c\u8bc1\u7801")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/retrievePwd/sendCode"})
    public ApiResult<String> sendVerifyCodeForRetrievePwd(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeParam) {
        return this.indexUserService.sendVerifyCodeForUpdatePwd(true, verifyCodeParam);
    }

    @ApiOperation(value="\u3010\u627e\u56de\u5bc6\u7801\u3011\u6839\u636e\u9a8c\u8bc1\u7801\u4fee\u6539\u5bc6\u7801")
    @ApiOperationSupport(order=6)
    @PutMapping(value={"/retrievePwd/verifyCode"})
    public ApiResult<Long> retrievePwd(@RequestBody @Valid PasswordUpdateSaveVO saveVO) {
        return this.indexUserService.updatePwdByVerifyCode(true, saveVO);
    }

    static {
        InterceptUri.addAllowUri(Set.of("/common/user/retrievePwd/sendCode", "/common/user/retrievePwd/verifyCode"));
    }
}

