/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.query.devops.CacheMethodDataQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheMethodRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheServiceRespVO;
import com.elitescloud.cloudt.system.service.devops.CacheMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7840\u6570\u636e\u7f13\u5b58\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/devops/cache"}, produces={"application/json"})
@Validated
public class CacheMngController {
    private CacheMngService mngService;

    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5217\u8868")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true)})
    @GetMapping(value={"/cacheServices"})
    public ApiResult<List<CacheServiceRespVO>> queryCacheServices(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId) {
        return this.mngService.queryCacheServices(serviceId);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u670d\u52a1\u7684\u65b9\u6cd5")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key", required=true)})
    @GetMapping(value={"/cacheMethods"})
    public ApiResult<List<CacheMethodRespVO>> queryCacheMethods(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") String cacheServiceKey) {
        return this.mngService.queryCacheMethods(serviceId, cacheServiceKey);
    }

    @ApiOperation(value="\u6839\u636e\u7f13\u5b58\u65b9\u6cd5\u67e5\u8be2\u6570\u636e")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/queryCacheDataByCacheMethod"})
    public ApiResult<Object> queryCacheDataByCacheMethod(@RequestBody @Valid CacheMethodDataQueryVO queryVO) {
        return this.mngService.queryCacheDataByCacheMethod(queryVO.getServiceId(), queryVO.getCacheServiceKey(), queryVO.getMethod(), queryVO.getParams(), queryVO.getTenantCode());
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u7684\u6570\u636e\u9879")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key", required=true), @ApiImplicitParam(name="tenantCode", value="\u79df\u6237\u7f16\u7801")})
    @GetMapping(value={"/items"})
    public ApiResult<List<String>> queryCacheItems(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") String cacheServiceKey, @RequestParam(name="tenantCode", required=false) String tenantCode) {
        return this.mngService.queryCacheItems(serviceId, cacheServiceKey, tenantCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u9879\u7684\u6570\u636e")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key", required=true), @ApiImplicitParam(name="cacheItem", value="\u7f13\u5b58\u9879", required=true), @ApiImplicitParam(name="tenantCode", value="\u79df\u6237\u7f16\u7801")})
    @GetMapping(value={"/item/data"})
    public ApiResult<Object> queryCacheItemData(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") String cacheServiceKey, @RequestParam(name="cacheItem") @NotBlank(message="\u7f13\u5b58\u9879\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u9879\u4e3a\u7a7a") String cacheItem, @RequestParam(name="tenantCode", required=false) String tenantCode) {
        return this.mngService.queryCacheItemData(serviceId, cacheServiceKey, cacheItem, tenantCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u670d\u52a1\u4e0b\u7684\u6240\u6709\u6570\u636e")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key", required=true), @ApiImplicitParam(name="tenantCode", value="\u79df\u6237\u7f16\u7801")})
    @GetMapping(value={"/item/data/all"})
    public ApiResult<Map<String, Object>> queryCacheDataByCacheKey(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") String cacheServiceKey, @RequestParam(name="tenantCode", required=false) String tenantCode) {
        return this.mngService.queryAllCacheItemData(serviceId, cacheServiceKey, tenantCode);
    }

    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key", required=true)})
    @PutMapping(value={"/reload"})
    public ApiResult<Boolean> reload(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a") String cacheServiceKey) {
        return this.mngService.reload(serviceId, cacheServiceKey);
    }

    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="cacheServiceKey", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6Key")})
    @DeleteMapping(value={"/clear"})
    public ApiResult<Boolean> clear(@RequestParam(name="serviceId") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") @NotBlank(message="\u670d\u52a1\u5b9e\u4f8bID\u4e3a\u7a7a") String serviceId, @RequestParam(name="cacheServiceKey", required=false) String cacheServiceKey) {
        return this.mngService.clear(serviceId, cacheServiceKey);
    }

    @Autowired
    public void setMngService(CacheMngService mngService) {
        this.mngService = mngService;
    }
}

