/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.devops;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.devops.BasicDataRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordExportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordImportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ImportBasicDataSaveVO;
import com.elitescloud.cloudt.system.service.SystemDataService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8fd0\u7ef4\u5de5\u5177"})
@RestController
@RequestMapping(value={"/devops/init"}, produces={"application/json"})
@Validated
public class SystemInitController {
    private final SystemDataService service;

    public SystemInitController(SystemDataService service) {
        this.service = service;
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u7c7b\u578b\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/dataType/all"})
    public ApiResult<List<CodeNameParam>> listDataType() {
        return this.service.listDataType();
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/export/data"})
    public ApiResult<Boolean> exportData(@RequestBody ExportBasicDataSaveVO saveVO) {
        return this.service.exportData(saveVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u51fa\u8bb0\u5f55")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/export/pageRecord"})
    public ApiResult<PagingVO<BasicRecordExportPageRespVO>> pageExportedRecord(@RequestBody BasicDataRecordPageQueryVO queryVO) {
        return this.service.pageExportedRecord(queryVO);
    }

    @ApiOperation(value="\u5bfc\u5165\u521d\u59cb\u5316\u6570\u636e")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6570\u636e\u6587\u4ef6", required=true)})
    @PostMapping(value={"/import/data"})
    public ApiResult<Boolean> importData(@RequestParam(name="file") @NotNull(message="\u8bf7\u9009\u62e9\u6587\u4ef6") @NotNull(message="\u8bf7\u9009\u62e9\u6587\u4ef6") MultipartFile file, ImportBasicDataSaveVO saveVO) {
        return this.service.importData(file, saveVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\u8bb0\u5f55")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/import/pageRecord"})
    public ApiResult<PagingVO<BasicRecordImportPageRespVO>> pageImportedRecord(@RequestBody BasicDataRecordPageQueryVO queryVO) {
        return this.service.pageImportedRecord(queryVO);
    }
}

