/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.model.vo.resp.index.AuthedUserFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.CurrentEmployeeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserDataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.save.index.ModifyPasswordSaveVO;
import com.elitescloud.cloudt.system.service.IndexUserService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7528\u6237\u4e3b\u9875\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/mng/index/user"}, produces={"application/json"})
@Validated
public class IndexUserController {
    private final IndexUserService indexUserService;

    public IndexUserController(IndexUserService indexUserService) {
        this.indexUserService = indexUserService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/currentUser"})
    public ApiResult<SysUserDTO> currentUser() {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        currentUser.getUser().setPassword(null);
        return ApiResult.ok((Object)currentUser.getUser());
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/currentEmp"})
    public ApiResult<CurrentEmployeeRespVO> getEmployeeInfo() {
        return this.indexUserService.getEmployeeInfo();
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="terminal", value="\u7ec8\u7aef\u7c7b\u578b\uff0c[UDC]cloudt-system:terminalType", dataType="string"), @ApiImplicitParam(name="includeAction", value="\u662f\u5426\u5305\u542b\u6309\u94ae", dataType="boolean", defaultValue="false"), @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean", defaultValue="true"), @ApiImplicitParam(name="cacheable", value="\u662f\u5426\u53ef\u7f13\u5b58", dataType="boolean", defaultValue="true")})
    @GetMapping(value={"/menus"})
    public ApiResult<List<UserMenuRespVO>> getUserMenu(@RequestParam(name="terminal", required=false) String terminal, @RequestParam(name="includeAction", defaultValue="false") Boolean includeAction, @RequestParam(name="tree", defaultValue="true") Boolean tree, @RequestParam(name="cacheable", defaultValue="true") Boolean cacheable) {
        return this.indexUserService.getUserMenu(terminal, includeAction, tree, cacheable);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u4e0b\u7684\u6309\u94ae")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801", dataType="String", required=true)})
    @GetMapping(value={"/menu/action"})
    public ApiResult<List<UserMenuRespVO>> getUserAction(@RequestParam(name="menuCode") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") String menuCode) {
        return this.indexUserService.getUserAction(menuCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u6709\u7684\u6309\u94ae")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/allAction"})
    public ApiResult<List<UserMenuRespVO>> getUserActions() {
        return this.indexUserService.getUserAction(null);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u8868\u683c\u914d\u7f6e")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="tableCode", value="\u8868\u683c\u7f16\u7801", required=true, paramType="query")
    @GetMapping(value={"/frontTable/cfg"})
    public ApiResult<String> getFrontTableCfg(@RequestParam(value="tableCode") @NotBlank(message="tableCode") @NotBlank(message="tableCode") String tableCode) {
        return this.indexUserService.getFrontTableCfg(tableCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f53\u524d\u9875\u9762\u7684\u6570\u636e\u6743\u9650\u914d\u7f6e")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="all", value="\u662f\u5426\u83b7\u53d6\u6240\u6709", defaultValue="false", dataType="boolean"), @ApiImplicitParam(name="reload", value="\u662f\u5426\u91cd\u65b0\u52a0\u8f7d", defaultValue="false", dataType="boolean")})
    @GetMapping(value={"/dataPermission/current"})
    public ApiResult<UserDataPermissionRespVO> getUserDataPermission(@RequestParam(value="all", defaultValue="false", required=false) Boolean all, @RequestParam(value="reload", defaultValue="false", required=false) Boolean reload) {
        return this.indexUserService.getDataPermission(all, reload);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f53\u524d\u9875\u9762\u7684\u5b57\u6bb5\u6743\u9650")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/fieldPermission/current"})
    public ApiResult<List<AuthedUserFieldRespVO>> getUserFieldPermission() {
        return this.indexUserService.getFieldPermission();
    }

    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u7528\u6237\u5bc6\u7801\u3010\u901a\u8fc7\u8001\u5bc6\u7801\u3011")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/update/currentPwd"})
    public ApiResult<Boolean> updatePassword(@RequestBody ModifyPasswordSaveVO saveVO) {
        return this.indexUserService.updatePassword(saveVO);
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u7684\u5f53\u524d\u79df\u6237")
    @ApiOperationSupport(order=12)
    @ApiImplicitParam(name="tenantId", value="\u79df\u6237ID", dataType="long", required=true)
    @GetMapping(value={"/switchTenant"})
    public ApiResult<SysUserDTO> switchTenant(@RequestParam(value="tenantId") Long tenantId) {
        return this.indexUserService.switchTenant(tenantId);
    }

    @ApiOperation(value="\u5207\u6362\u7528\u6237\u7684\u5f53\u524d\u7ec4\u7ec7")
    @ApiOperationSupport(order=13)
    @ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", dataType="long", required=true)
    @GetMapping(value={"/switchOrg"})
    public ApiResult<SysUserDTO> switchOrg(@RequestParam(value="orgId") Long orgId) {
        return this.indexUserService.switchOrg(orgId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6388\u6743\u7684\u5b57\u6bb5")
    @ApiOperationSupport(order=4)
    @ApiIgnore
    @GetMapping(value={"/user/field"})
    @Deprecated(since="3.3.0")
    public ApiResult<List<UserFieldRespVO>> getUserAuthorizedField(@RequestParam(name="menuCode") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") String menuCode, @RequestParam(name="apiCode") @NotBlank(message="\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a") String apiCode) {
        return this.indexUserService.getUserField(menuCode, apiCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684OpenID")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="AppId\uff0c\u7b2c\u4e09\u65b9\u5e94\u7528\u7684ID\uff0c\u5982\u5fae\u4fe1\u7684appId"), @ApiImplicitParam(name="code", value="\u6388\u6743\u7801, \u5efa\u8bae\u4f20\u9012\uff0c\u5982\u4e4b\u524d\u672a\u7ed1\u5b9a\u5219\u9700\u8981\u8be5\u6388\u6743\u7801\u83b7\u53d6openId\u8fdb\u884c\u7ed1\u5b9a")})
    @GetMapping(value={"/openId"})
    public ApiResult<String> getOpenId(HttpServletRequest request, @RequestParam(name="appId") @NotBlank(message="appId\u4e3a\u7a7a") @NotBlank(message="appId\u4e3a\u7a7a") String outerAppId) {
        return this.indexUserService.getOpenId(request, outerAppId);
    }

    @ApiOperation(value="\u89e3\u7ed1\u5f53\u524d\u7528\u6237\u7684OpenID")
    @ApiOperationSupport(order=22)
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="AppId\uff0c\u7b2c\u4e09\u65b9\u5e94\u7528\u7684ID\uff0c\u5982\u5fae\u4fe1\u7684appId")})
    @GetMapping(value={"/openId/unbind"})
    public ApiResult<String> unbindOpenId(@RequestParam(name="appId") @NotBlank(message="appId\u4e3a\u7a7a") @NotBlank(message="appId\u4e3a\u7a7a") String outerAppId) {
        return this.indexUserService.unbindOpenId(outerAppId);
    }
}

