/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.common;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonMenuTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.MenuQueryService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@BusinessObject(businessType="Sys_Common:\u516c\u5171")
@Api(tags={"\u901a\u7528\u6743\u9650\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/mng/common/permission"}, produces={"application/json"})
@Validated
public class CommonPermissionController {
    private RoleQueryService roleQueryService;
    private MenuQueryService menuQueryService;

    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="[\u901a\u7528\u7ec4\u4ef6]\u67e5\u8be2\u89d2\u8272\u5217\u8868", dataPermissionEnabled=true)
    @GetMapping(value={"/roles"})
    @ApiOperation(value="[\u901a\u7528\u7ec4\u4ef6]\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u6807\u8bc6\uff0c[UDC]cloudt-system:roleBusiness"), @ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0")})
    public ApiResult<List<IdCodeNameParam>> queryRoleList(@RequestParam(name="businessKey", required=false) String businessKey, @RequestParam(name="roleName", required=false) String roleName, @RequestParam(name="showAll", required=false, defaultValue="false") Boolean showAll) {
        return this.roleQueryService.listRole(showAll, businessKey, roleName);
    }

    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="[\u901a\u7528\u7ec4\u4ef6]\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u5217\u8868", dataPermissionEnabled=true)
    @GetMapping(value={"/roleGroups"})
    @ApiOperation(value="[\u901a\u7528\u7ec4\u4ef6]\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u5217\u8868")
    @ApiOperationSupport(order=2)
    public ApiResult<List<IdCodeNameParam>> queryRoleGroupList(@RequestParam(name="showAll", required=false, defaultValue="false") Boolean showAll) {
        BelongType.Belonger belonger = showAll != null && showAll != false ? null : BelongType.getBelonger();
        return this.roleQueryService.listAllRoleGroup(belonger);
    }

    @ApiOperation(value="[\u901a\u7528\u7ec4\u4ef6]\u83b7\u53d6\u7cfb\u7edf\u83dc\u5355")
    @ApiOperationSupport(order=5)
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801"), @ApiImplicitParam(name="withSys", value="\u662f\u5426\u663e\u793a\u7ba1\u7406\u83dc\u5355", defaultValue="false", dataType="boolean"), @ApiImplicitParam(name="withBusiness", value="\u662f\u5426\u663e\u793a\u4e1a\u52a1\u83dc\u5355", defaultValue="true", dataType="boolean"), @ApiImplicitParam(name="withMenu", value="\u662f\u5426\u663e\u793a\u83dc\u5355", defaultValue="true", dataType="boolean"), @ApiImplicitParam(name="withAction", value="\u662f\u5426\u663e\u793a\u6309\u94ae", defaultValue="false", dataType="boolean"), @ApiImplicitParam(name="defTree", value="\u662f\u5426\u4f7f\u7528\u9ed8\u8ba4\u6811", defaultValue="false", dataType="boolean"), @ApiImplicitParam(name="tree", value="\u662f\u5426\u663e\u793a\u6811\u72b6", defaultValue="true", dataType="boolean")})
    @GetMapping(value={"/tenantMenu"})
    public ApiResult<List<CommonMenuTreeNodeRespVO>> menuTreeSystem(@RequestParam(name="appCode", required=false) String appCode, @RequestParam(name="withSys", required=false, defaultValue="false") Boolean withSys, @RequestParam(name="withBusiness", required=false, defaultValue="true") Boolean withBusiness, @RequestParam(name="withMenu", required=false, defaultValue="true") Boolean withMenu, @RequestParam(name="withAction", required=false, defaultValue="false") Boolean withAction, @RequestParam(name="defTree", required=false, defaultValue="false") Boolean defTree, @RequestParam(name="tree", required=false, defaultValue="true") Boolean tree) {
        return this.menuQueryService.menuTreeSystem(appCode, withSys, withBusiness, withMenu, withAction, defTree, tree);
    }

    @Autowired
    public void setRoleQueryService(RoleQueryService roleQueryService) {
        this.roleQueryService = roleQueryService;
    }

    @Autowired
    public void setMenuQueryService(MenuQueryService menuQueryService) {
        this.menuQueryService = menuQueryService;
    }
}

