/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiRetryLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogAggPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.ThirdApiLogSaveVO;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import com.elitescloud.cloudt.system.service.impl.ThirdApiLogRetrySupportServiceImpl;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e09\u65b9\u63a5\u53e3\u65e5\u5fd7"})
@RestController
@RequestMapping(value={"/mng/thirdLog"}, produces={"application/json"})
@Validated
public class ThirdApiLogController {
    private ThirdApiLogService service;
    private ThirdApiLogRetrySupportServiceImpl thirdApiLogRecordService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u5217\u8868")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryByPage(@RequestBody ThirdApiLogQueryVO queryVO) {
        return this.service.queryByPage(queryVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u91cd\u8bd5\u5217\u8868")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u65e5\u5fd7\u8bb0\u5f55ID", required=true)
    @GetMapping(value={"/listRetry"})
    public ApiResult<List<ThirdApiLogPageRespVO>> listRetryRecord(@RequestParam(name="id") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") Long id) {
        return this.service.listRetryRecord(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u91cd\u8bd5\u5217\u8868")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u65e5\u5fd7\u8bb0\u5f55ID", required=true)
    @GetMapping(value={"/pageRetry"})
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> pageRetryRecord(@RequestBody ThirdApiRetryLogQueryVO queryVO) {
        return this.service.pageRetryRecord(queryVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u65e5\u5fd7\u8bb0\u5f55ID", required=true)
    @GetMapping(value={"/detail"})
    public ApiResult<ThirdApiLogDetailRespVO> getDetail(@RequestParam(name="id") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") Long id) {
        return this.service.getDetail(id);
    }

    @ApiOperation(value="\u4fee\u6539\u65e5\u5fd7\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="retry", value="\u662f\u5426\u91cd\u8bd5")
    @PostMapping(value={"/save"})
    public ApiResult<Long> saveAndSend(@RequestBody @Valid ThirdApiLogSaveVO saveVO, @RequestParam(name="retry", required=false, defaultValue="false") Boolean retry) {
        return this.thirdApiLogRecordService.saveLog(saveVO, Boolean.TRUE.equals(retry));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u805a\u5408\u65e5\u5fd7\u5217\u8868")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/pageAgg"})
    public ApiResult<PagingVO<ThirdApiLogAggPageRespVO>> queryAggByPage(@RequestBody ThirdApiLogQueryVO queryVO) {
        return this.service.queryAggByPage(queryVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u805a\u5408\u65e5\u5fd7\u5217\u8868\u7684\u660e\u7ec6")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/pageAgg/{id}/detail"})
    public ApiResult<List<ThirdApiLogPageRespVO>> queryAggDetail(@PathVariable(value="id") Long id, @RequestBody ThirdApiLogQueryVO queryVO) {
        return this.service.listAggDetail(queryVO, id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u805a\u5408\u65e5\u5fd7\u5217\u8868\u7684\u660e\u7ec6")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/pageAgg/{id}/detail/page"})
    public ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryAggDetailByPage(@PathVariable(value="id") Long id, @RequestBody ThirdApiLogQueryVO queryVO) {
        return this.service.pageAggDetail(queryVO, id);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u7c7b\u578b")
    @ApiOperationSupport(order=11)
    @GetMapping(value={"/const/businessType"})
    public ApiResult<List<CodeNameParam>> listBusinessTypes() {
        return this.service.listBusinessTypes();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u76ee\u6807\u7cfb\u7edf")
    @ApiOperationSupport(order=12)
    @GetMapping(value={"/const/targetSystem"})
    public ApiResult<List<CodeNameParam>> listTargetSystems() {
        return this.service.listTargetSystems();
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u6e90\u7cfb\u7edf")
    @ApiOperationSupport(order=13)
    @GetMapping(value={"/const/sourceSystem"})
    public ApiResult<List<CodeNameParam>> listSourceSystems() {
        return this.service.listSourceSystems();
    }

    @Autowired
    public void setService(ThirdApiLogService service) {
        this.service = service;
    }

    @Autowired
    public void setThirdApiLogRecordService(ThirdApiLogRetrySupportServiceImpl thirdApiLogRecordService) {
        this.thirdApiLogRecordService = thirdApiLogRecordService;
    }
}

