/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.extend;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplImportRecordRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageQueryRespVO;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.TmplQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/tmplRecord"}, produces={"application/json"})
@Api(tags={"\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55"})
@ApiSupport(author="wang shao", order=12)
@Validated
@BusinessObject(businessType="Sys_Tmpl:\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f", businessDoClass=SysTmplDO.class)
public class TmplRecordController {
    private static final Logger log = LoggerFactory.getLogger(TmplRecordController.class);
    @Autowired
    private TmplQueryService tmplService;
    @Autowired
    private TmplImportRecordService tmplImportRecordService;

    @PostMapping(value={"/tmpl/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55")
    @ApiOperationSupport(order=1)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", dataPermissionEnabled=true)
    public ApiResult<PagingVO<TmplPageQueryRespVO>> search(@RequestBody @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") TmplQueryParam queryParam) {
        return this.tmplService.search(queryParam);
    }

    @GetMapping(value={"/tmpl/file"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", produces="application/octet-stream")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileCode", value="\u6a21\u677f\u6587\u4ef6\u7684\u552f\u4e00\u6807\u8bc6", required=true, paramType="query")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6")
    public HttpEntity<StreamingResponseBody> download(@RequestParam(name="fileCode") @NotBlank(message="\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a") String fileCode) {
        return this.tmplService.downloadByFileCode(fileCode);
    }

    @GetMapping(value={"/tmpl/file/byTmplCode"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u7f16\u7801\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6", produces="application/octet-stream")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="tmplCode", value="\u6a21\u677f\u6587\u4ef6\u7f16\u7801", required=true, paramType="query")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u6839\u636e\u6a21\u677f\u7f16\u7801\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6")
    public HttpEntity<StreamingResponseBody> downloadByTmplCode(@RequestParam(name="tmplCode") @NotBlank(message="\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a") String tmplCode) {
        return this.tmplService.downloadByCode(tmplCode);
    }

    @PostMapping(value={"/tmpl/{id}/import"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    public ApiResult<PagingVO<TmplImportRecordRespVO>> searchImport(@PathVariable Long id, @RequestBody @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") TmplImportQueryParam queryParam) {
        return this.tmplImportRecordService.searchImport(id, queryParam);
    }

    @PostMapping(value={"/tmpl/records"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    @ApiOperationSupport(order=21)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u5bfc\u5165\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    public ApiResult<PagingVO<TmplImportRecordRespVO>> searchRecords(@RequestBody @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") @NotNull(message="\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a") TmplImportQueryParam queryParam) {
        return this.tmplImportRecordService.searchImport(null, queryParam);
    }

    @GetMapping(value={"/tmpl/record/{recordId}/files"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u7684\u6587\u4ef6\u5217\u8868")
    @ApiOperationSupport(order=22)
    @ApiImplicitParams(value={@ApiImplicitParam(name="importId", value="\u5bfc\u51fa\u8bb0\u5f55ID", required=true, paramType="path", dataType="long")})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u83b7\u53d6\u5bfc\u51fa\u7684\u6587\u4ef6\u5217\u8868\uff08\u5bfc\u51fa\uff09\u8bb0\u5f55")
    public ApiResult<List<FileObjRespVO<String>>> listFileOfExport(@PathVariable(value="recordId") Long recordId) {
        return this.tmplImportRecordService.listFileOfExport(recordId);
    }
}

