/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.org;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeSaveVO;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5458\u5de5\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/employee"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_Employee:\u5458\u5de5", businessDoClass=SysEmployeeDO.class)
public class EmployeeMngController {
    private final EmployeeMngService employeeMngService;

    public EmployeeMngController(EmployeeMngService employeeMngService) {
        this.employeeMngService = employeeMngService;
    }

    @ApiOperation(value="\u5458\u5de5\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationCode="sys_emp_mng_page", operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u5458\u5de5", dataPermissionEnabled=false, fieldPermissionAutoFilter=true)
    public ApiResult<PagingVO<EmployeePagedRespVO>> page(@RequestBody EmployeePageQueryVO queryVO) {
        return this.employeeMngService.page(queryVO);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5458\u5de5\u6269\u5c55\u4fe1\u606f\u4fee\u6539")
    @PostMapping(value={"/testUpdate"})
    public ApiResult testUpdate(@RequestBody @Valid EmployeeSaveVO saveVO) {
        return this.employeeMngService.testUpdate(saveVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.employeeMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u5220\u9664\u5458\u5de5")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="keepUser", value="\u662f\u5426\u4fdd\u7559\u8d26\u53f7", required=true, dataType="boolean", paramType="query")})
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u5458\u5de5", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id, @RequestParam(name="keepUser", defaultValue="false") Boolean keepUser) {
        return this.employeeMngService.delete(id, keepUser);
    }

    @ApiOperation(value="\u83b7\u53d6\u5458\u5de5\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5458\u5de5\u8be6\u60c5", dataPermissionEnabled=true)
    public ApiResult<EmployeeDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.employeeMngService.getDetail(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5458\u5de5[\u5168\u90e8\u4fe1\u606f]")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u5458\u5de5[\u5168\u90e8\u4fe1\u606f]", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true, allowRepeatRequest=false)
    public ApiResult<Long> save(@RequestBody @Valid EmployeeSaveVO saveVO) {
        return this.employeeMngService.upsert(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5458\u5de5\u7684\u6240\u6709\u7ec4\u7ec7")
    @ApiOperationSupport(order=22)
    @ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}/org"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u5458\u5de5\u7684\u6240\u6709\u7ec4\u7ec7", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<List<EmpOrgRespVO>> getOrg(@PathVariable(value="id") Long id) {
        return this.employeeMngService.getEmployeeOrgs(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u5458\u5de5\u7684\u89d2\u8272")
    @ApiOperationSupport(order=31)
    @ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}/role"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u5458\u5de5\u7684\u89d2\u8272", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<List<IdCodeNameCheckParam>> getRole(@PathVariable(value="id") Long id) {
        return this.employeeMngService.getRole(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5458\u5de5\u7684\u89d2\u8272")
    @ApiOperationSupport(order=32)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5458\u5de5ID", required=true, dataType="int"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ID", required=true, dataType="int", allowMultiple=true)})
    @PutMapping(value={"/save/{id}/role"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u5458\u5de5\u7684\u89d2\u8272", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true, allowRepeatRequest=false)
    public ApiResult<Long> saveRole(@PathVariable(value="id") Long id, @RequestBody List<Long> roleIds) {
        return this.employeeMngService.saveRole(id, roleIds);
    }
}

