/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.org;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgSaveVO;
import com.elitescloud.cloudt.system.service.OrgMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/org"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_Org:\u7ec4\u7ec7", businessDoClass=SysOrgDO.class, publicResource=true)
public class OrgMngController {
    private final OrgMngService orgMngService;

    public OrgMngController(OrgMngService orgMngService) {
        this.orgMngService = orgMngService;
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6811")
    @ApiOperationSupport(order=1)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean", defaultValue="true")
    @GetMapping(value={"/tree/get"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6811", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<List<OrgTreeNodeRespVO>> getTree(@RequestParam(name="tree", defaultValue="true") Boolean tree) {
        return this.orgMngService.getOrgTree(tree);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7ec4\u7ec7ID", required=true, dataType="int"), @ApiImplicitParam(name="withParentType", value="\u6307\u5b9a\u7684\u4e0a\u7ea7\u7c7b\u578b\uff0c[UDC]cloudt-system:orgType")})
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u7ec4\u7ec7\u8be6\u60c5", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<OrgDetailRespVO> get(@PathVariable(value="id") Long id, @RequestParam(name="withParentType", required=false) String withParentType) {
        return this.orgMngService.getDetail(id, withParentType);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u7ec4\u7ec7", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid OrgSaveVO saveVO) {
        return this.orgMngService.upsert(saveVO);
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u7ec4\u7ec7ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u7ec4\u7ec7", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.orgMngService.delete(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7", dataPermissionEnabled=false)
    public ApiResult<PagingVO<OrgPagedRespVO>> queryByPage(@RequestBody OrgPageQueryVO queryVO) {
        return this.orgMngService.queryByPage(queryVO);
    }

    @PatchMapping(value={"/switch/{id}/enabled"})
    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=6)
    @ApiImplicitParam(name="id", value="\u7ec4\u7ec7ID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.orgMngService.updateEnabled(id);
    }

    @PutMapping(value={"/tree/rebuild"})
    @ApiOperation(value="\u91cd\u6784\u884c\u653f\u7ec4\u7ec7\u57df\u6811")
    @ApiOperationSupport(order=7)
    @ApiImplicitParam(name="rootOrgId", value="\u6839\u8282\u70b9ID", paramType="query")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u91cd\u6784\u884c\u653f\u7ec4\u7ec7\u57df\u6811")
    public ApiResult<Boolean> treeRebuild(@RequestParam(value="rootOrgId", required=false) Long rootOrgId) {
        return this.orgMngService.updateTreeRebuild(rootOrgId);
    }
}

