/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.position;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.query.position.OrgVo;
import com.elitescloud.cloudt.system.model.vo.query.position.RoleVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionQueryVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionSaveVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionVo;
import com.elitescloud.cloudt.system.service.SysPositionService;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/positions"})
@Api(tags={"\u5c97\u4f4d\u7ba1\u7406"})
@BusinessObject(businessType="Sys_Position:\u5c97\u4f4d")
public class SysPositionController {
    private final SysPositionService sysPositionService;

    public SysPositionController(SysPositionService sysPositionService) {
        this.sysPositionService = sysPositionService;
    }

    @PostMapping(value={"/getAllPositions"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5c97\u4f4d\u67e5\u8be2")
    public ApiResult<List<SysPositionVo>> getAllPositions(@RequestBody SysPositionQueryVo sysPositionVo) {
        return this.sysPositionService.getAllPositions(sysPositionVo);
    }

    @GetMapping(value={"/findOrgsByPosition/{positionCode}"})
    public ApiResult<List<OrgVo>> findOrgsByPosition(@PathVariable String positionCode) {
        return ApiResult.ok(this.sysPositionService.findOrgsByPosition(positionCode));
    }

    @GetMapping(value={"/findRolesByPosition/{positionCode}"})
    public ApiResult<List<RoleVo>> findRolesByPosition(@PathVariable String positionCode) {
        return ApiResult.ok(this.sysPositionService.findRolesByPosition(positionCode));
    }

    @GetMapping(value={"/getPositionByCode/{positionCode}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5c97\u4f4d\u7f16\u7801\u67e5\u8be2")
    public ApiResult<SysPositionVo> getPositionByCode(@PathVariable(value="positionCode") String positionCode) {
        return this.sysPositionService.getPositionByCode(positionCode);
    }

    @GetMapping(value={"/getPositionById/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5c97\u4f4dID\u67e5\u8be2")
    public ApiResult<SysPositionVo> getPositionById(@PathVariable(value="id") Long id) {
        return this.sysPositionService.getPositionById(id);
    }

    @PostMapping
    @GetMapping(value={"/createPosition"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u5c97\u4f4d\u521b\u5efa")
    public ApiResult<Long> createPosition(@RequestBody SysPositionSaveVo position) {
        return this.sysPositionService.createPosition(position);
    }

    @PutMapping(value={"/updatePosition/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5c97\u4f4d\u66f4\u65b0")
    public ApiResult<Boolean> updatePosition(@PathVariable(value="id") Long id, @RequestBody SysPositionSaveVo position) {
        return this.sysPositionService.updatePosition(id, position);
    }

    @DeleteMapping(value={"/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5c97\u4f4dID\u5220\u9664")
    public ApiResult<Void> deletePosition(@PathVariable(value="id") Long id) {
        this.sysPositionService.deletePosition(id);
        return ApiResult.ok();
    }
}

