/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.sys;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.controller.mng.org.EmployeeMngController;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiOperationPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiPageRespVO;
import com.elitescloud.cloudt.system.service.OpenApiMngService;
import com.elitescloud.cloudt.system.service.OpenApiQueryService;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Api(tags={"OpenApi\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/openapi"}, produces={"application/json"})
@Validated
public class OpenApiMngController {
    private OpenApiMngService mngService;
    private OpenApiQueryService queryService;

    @ApiOperation(value="\u3010\u6d4b\u8bd5\u3011\u6d4b\u8bd5\u4fdd\u5b58OpenApi")
    @ApiOperationSupport(order=1)
    @ApiImplicitParam(name="controllerClass", value="controller\u7c7b\u7684\u552f\u4e00\u9650\u5b9a\u540d\u79f0")
    @GetMapping(value={"/testSave"})
    public Object testSave(@RequestParam(name="controllerClass", required=false) String controllerClass, @RequestParam(name="save", required=false, defaultValue="false") Boolean save) throws Exception {
        if (CharSequenceUtil.isBlank((CharSequence)controllerClass)) {
            controllerClass = EmployeeMngController.class.getName();
        }
        Class<?> controller = Class.forName(controllerClass);
        OpenAPI openApi = (OpenAPI)this.mngService.testAnalyzeController(controller).getData();
        if (Boolean.TRUE.equals(save)) {
            return this.mngService.updateOpenApi(openApi, OpenApiSourceEnum.GATHER_PULL);
        }
        return Json.pretty((Object)openApi);
    }

    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u540d\u79f0\u62c9\u53d6\u6700\u65b0OpenAPI")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801")
    @PostMapping(value={"/pullOpenApiByAppCode"})
    public ApiResult<Long> pullOpenApiByAppCode(@RequestParam(name="appCode") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") String appCode) {
        return this.mngService.updateOpenApi(appCode);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2OpenAPI")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/pageOpenApi"})
    public ApiResult<PagingVO<OpenApiPageRespVO>> pageMng(@RequestBody OpenApiPageQueryVO queryVO) {
        return this.mngService.pageMng(queryVO);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2OpenAPI\u4e0b\u7684\u64cd\u4f5c")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/pageOpenApiOperation"})
    public ApiResult<PagingVO<OpenApiOperationPageRespVO>> pageMng(@RequestBody OpenApiOperationPageQueryVO queryVO) {
        return this.mngService.pageMng(queryVO);
    }

    @ApiOperation(value="\u6839\u636eID\u62c9\u53d6\u6700\u65b0OpenAPI")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID")
    @PutMapping(value={"/pullOpenApi"})
    public ApiResult<Long> pullOpenApi(@RequestParam(name="id") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") Long id) {
        return this.mngService.updateOpenApi(id);
    }

    @GetMapping(value={"/downloadOpenApi"})
    @ApiOperation(value="\u4e0b\u8f7dOpenApi", produces="application/octet-stream")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="OpenApi\u7684\u552f\u4e00\u6807\u8bc6", required=true, paramType="query")})
    public HttpEntity<StreamingResponseBody> download(@RequestParam(name="id") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") @NotNull(message="\u8bb0\u5f55ID\u4e3a\u7a7a") Long id) {
        return this.queryService.downloadOpenApi(id);
    }

    @GetMapping(value={"/downloadOpenApi/rpc"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528\u7f16\u7801\u8fdc\u7a0b\u4e0b\u8f7dOpenApi", produces="application/octet-stream")
    @ApiOperationSupport(order=7)
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801", required=true, paramType="query")})
    public HttpEntity<StreamingResponseBody> downloadByRpc(@RequestParam(name="appCode") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") String appCode) {
        return this.queryService.downloadOpenApiByRpc(appCode);
    }

    @GetMapping(value={"/selectDistinctOperationGroupByApiType"})
    @ApiOperation(value="\u53bb\u91cd\u83b7\u53d6\u5168\u90e8\u7684\u63a5\u53e3\u5206\u7ec4\u6570\u636e\uff0c\u7528\u4e8e\u5185\u90e8\u63a5\u53e3\u7684\u4e0b\u62c9\u67e5\u8be2")
    public ApiResult<List<String>> selectDistinctOperationGroupByApiType() {
        return this.mngService.selectDistinctOperationGroupByApiType();
    }

    @Autowired
    public void setMngService(OpenApiMngService mngService) {
        this.mngService = mngService;
    }

    @Autowired
    public void setQueryService(OpenApiQueryService queryService) {
        this.queryService = queryService;
    }
}

