/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.udc;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.system.service.UdcMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UDC\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/udc"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="SysPlatform_Udc:\u5e73\u53f0UDC", businessDoClass=SysPlatformUdcDO.class)
public class UdcMngController {
    private final UdcMngService udcMngService;

    public UdcMngController(UdcMngService udcMngService) {
        this.udcMngService = udcMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2UDC")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5206\u9875\u67e5\u8be2UDC", dataPermissionEnabled=true)
    public ApiResult<PagingVO<UdcPageRespVO>> page(@RequestBody UdcPageQueryVO queryVO) {
        return this.udcMngService.page(queryVO);
    }

    @ApiOperation(value="\u83b7\u53d6UDC\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="UDC\u7684ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="id\u67e5\u8be2")
    public ApiResult<UdcDetailRespVO> detail(@PathVariable(value="id") Long id) {
        return this.udcMngService.detail(id);
    }

    @ApiOperation(value="\u4fdd\u5b58UDC")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58UDC", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@Valid @RequestBody UdcSaveVO saveVO) {
        return this.udcMngService.save(saveVO);
    }

    @ApiOperation(value="\u4fdd\u5b58UDC\u7684\u503c")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="UDC\u7684ID", required=true, dataType="int")
    @PostMapping(value={"/save/{id}/value"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58UDC\u503c", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> saveValue(@PathVariable Long id, @Valid @RequestBody UdcValueSaveVO saveVO) {
        return this.udcMngService.saveValue(id, saveVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u72b6\u6001")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="UDC\u503c\u7684ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/value/{id}/enabled"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u72b6\u6001", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> updateValueEnabled(@PathVariable Long id) {
        return this.udcMngService.updateValueEnabled(id);
    }

    @ApiOperation(value="\u5220\u9664UDC\u7684\u503c")
    @ApiOperationSupport(order=6)
    @ApiImplicitParam(name="id", value="UDC\u503c\u7684ID", required=true, dataType="int")
    @DeleteMapping(value={"/delete/value/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664UDC\u7684\u503c", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> deleteValue(@PathVariable Long id) {
        return this.udcMngService.deleteValue(id);
    }
}

