/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.user;

import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UserTypeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/user"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_User:\u8d26\u53f7", businessDoClass=SysUserDO.class, publicResource=true, supportTenant=false)
public class UserMngController {
    private final UserMngService userMngService;

    public UserMngController(UserMngService userMngService) {
        this.userMngService = userMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d26\u53f7")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u8d26\u53f7", dataPermissionEnabled=true)
    public ApiResult<PagingVO<UserPageRespVO>> page(@RequestBody UserPageQueryVO queryVO) {
        return this.userMngService.page(queryVO);
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.userMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u5220\u9664\u8d26\u53f7")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u8d26\u53f7", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.userMngService.delete(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d26\u53f7\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u8d26\u53f7\u8be6\u60c5")
    public ApiResult<UserDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.userMngService.get(id);
    }

    @ApiOperation(value="\u65b0\u589e(\u4fee\u6539)\u8d26\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=8)
    @PutMapping(value={"/upsert"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u65b0\u589e(\u4fee\u6539)\u8d26\u6237\u4fe1\u606f", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> upsert(@RequestBody @Valid UserSaveVO saveVO) {
        return this.userMngService.save(saveVO);
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @ApiOperationSupport(order=9)
    @PatchMapping(value={"/reset/{id}/password"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u91cd\u7f6e\u5bc6\u7801", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> updatePassword(@PathVariable(value="id") Long id) {
        return this.userMngService.updatePassword(id);
    }

    @ApiOperation(value="\u6e05\u9664CAS\u7684UserId")
    @ApiOperationSupport(order=10)
    @PatchMapping(value={"/cas/clear/userId"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u6e05\u9664CAS\u7684UserId", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> clearCasUserId(@RequestBody List<Long> ids) {
        return this.userMngService.clearCasUserId(ids);
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7ID\u83b7\u53d6\u8d26\u53f7\u7c7b\u578b")
    @ApiOperationSupport(order=11)
    @ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="long")
    @GetMapping(value={"/userType/list"})
    public ApiResult<List<UserTypeRespVO>> listUserType(@NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") Long id) {
        return this.userMngService.listUserType(id);
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u8d26\u53f7\u7c7b\u578b")
    @ApiOperationSupport(order=12)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="long"), @ApiImplicitParam(name="userType", value="\u7528\u6237\u7c7b\u578b[UDC]cloudt-system:userType", required=true), @ApiImplicitParam(name="userType", value="\u7528\u6237\u8eab\u4efd\u6807\u8bc6ID")})
    @DeleteMapping(value={"/userType/user"})
    public ApiResult<Long> delUserType(@NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") Long id, @NotBlank(message="\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a") @RequestParam(name="userType") @NotBlank(message="\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a") String userType, @RequestParam(name="identityId", required=false) String identityId) {
        return this.userMngService.removeUserType(id, userType, identityId);
    }

    @ApiOperation(value="\u7ed9\u8d26\u6237\u65b0\u589e\u8d26\u53f7\u7c7b\u578b")
    @ApiOperationSupport(order=13)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8d26\u53f7ID", required=true, dataType="long"), @ApiImplicitParam(name="userType", value="\u7528\u6237\u7c7b\u578b[UDC]cloudt-system:userType", required=true), @ApiImplicitParam(name="userType", value="\u7528\u6237\u8eab\u4efd\u6807\u8bc6ID")})
    @PostMapping(value={"/userType/user"})
    public ApiResult<Long> saveUserType(@NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") @RequestParam(name="id") @NotNull(message="\u8d26\u6237ID\u4e3a\u7a7a") Long id, @NotBlank(message="\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a") @RequestParam(name="userType") @NotBlank(message="\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a") String userType, @RequestParam(name="identityId", required=false) String identityId) {
        return this.userMngService.addUserType(id, userType, identityId);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u7ebf\u8bbe\u5907")
    @GetMapping(value={"/userOnlineDevice"})
    public ApiResult<List<UserLoginDeviceDTO>> userOnlineDevice(@RequestParam(name="userId") Long userId) {
        return this.userMngService.userOnlineDevice(userId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u6570\u91cf")
    @DeleteMapping(value={"/expiredUserOnlineDevice"})
    public ApiResult<Boolean> expiredUserOnlineDevice(@RequestParam(name="userId") Long userId, @RequestParam(name="clientId", required=false) String clientId) {
        return this.userMngService.expiredUserOnlineDevice(userId, clientId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u6570\u91cf")
    @GetMapping(value={"/onlineUserNum"})
    public ApiResult<Integer> onlineUserNum() {
        return this.userMngService.onlineUserNum();
    }

    @ApiOperation(value="\u4e0b\u7ebf\u6240\u6709\u7528\u6237")
    @DeleteMapping(value={"/expiredAllOnlineUser"})
    public ApiResult<Integer> expiredAllOnlineUser() {
        return this.userMngService.expiredAllOnlineUser();
    }

    static {
        InterceptUri.addAllowUri(Set.of("/mng/user/cas/clear/userId"));
    }
}

