/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.openapi;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysSiteMsgSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.msg.SysSiteMsgViewedDTO;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgMngService;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgQueryService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ad9\u5185\u4fe1"})
@RestController
@RequestMapping(value={"/openapi/siteMsg"}, produces={"application/json"})
@Validated
public class SysSiteMsgOpenApiController {
    @Autowired
    private SiteMsgMngService mngService;
    @Autowired
    private SiteMsgQueryService queryService;

    @PostMapping(value={"/send"})
    public ApiResult<String> send(@RequestBody @Valid SysSiteMsgSaveDTO saveDTO) {
        return this.mngService.send(saveDTO);
    }

    @DeleteMapping(value={"/delete"})
    public ApiResult<String> delete(@RequestParam(name="batchId") @NotBlank(message="\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a") @NotBlank(message="\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a") String batchId) {
        return this.mngService.delete(batchId);
    }

    @GetMapping(value={"/viewed"})
    public ApiResult<List<SysSiteMsgViewedDTO>> queryViewedResult(@RequestParam(name="batchId") @NotBlank(message="\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a") @NotBlank(message="\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a") String batchId) {
        return this.queryService.queryViewedResult(batchId);
    }
}

