/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.common.MediaType;
import com.elitescloud.cloudt.system.model.entity.InfinityApiDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FormColumnDefinition;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiDetailVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiMergeVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.JsonColumnDefinition;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.util.BeanUtils;
import java.util.Collections;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(config=BaseMapperConfig.class)
public interface InfinityApiConvert {
    public static final InfinityApiConvert INSTANCE = (InfinityApiConvert)Mappers.getMapper(InfinityApiConvert.class);

    public List<InfinityApiDetailVO> doToVO(List<InfinityApiDO> var1);

    @Mappings(value={@Mapping(target="headerParam", source="headerParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="queryParam", source="queryParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="pathParam", source="pathParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="bodyParam", expression="java(toObjectColumn(infinityApiDO.getMediaType(), infinityApiDO.getBodyParam()))"), @Mapping(target="response", source="response", qualifiedByName={"valueToJsonColumn"})})
    public InfinityApiDetailVO doToVO(InfinityApiDO var1);

    @Mappings(value={@Mapping(target="headerParam", source="headerParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="queryParam", source="queryParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="pathParam", source="pathParam", qualifiedByName={"valueToFormColumn"}), @Mapping(target="bodyParam", expression="java(toObjectColumn(apiMergeVO.getMediaType(), apiMergeVO.getBodyParam()))"), @Mapping(target="response", source="response", qualifiedByName={"valueToJsonColumn"}), @Mapping(target="serverUrl", expression="java(inheritServerUrl(apiMergeVO))"), @Mapping(target="authMethod", expression="java(inheritAuthMethod(apiMergeVO))"), @Mapping(target="authAccount", expression="java(inheritAuthAccount(apiMergeVO))")})
    public InfinityApiDetailVO mergeToDetailVO(InfinityApiMergeVO var1);

    @Mappings(value={@Mapping(target="headerParam", source="headerParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="queryParam", source="queryParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="pathParam", source="pathParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="bodyParam", source="bodyParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="response", source="response", qualifiedByName={"saveParamToStr"}), @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")})
    public InfinityApiDO saveParamToDO(ApiSaveParamVO var1);

    @Mappings(value={@Mapping(target="headerParam", source="headerParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="queryParam", source="queryParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="pathParam", source="pathParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="bodyParam", source="bodyParam", qualifiedByName={"saveParamToStr"}), @Mapping(target="response", source="response", qualifiedByName={"saveParamToStr"}), @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")})
    public void saveParamMergeToDO(ApiSaveParamVO var1, @MappingTarget InfinityApiDO var2);

    @Named(value="saveParamToStr")
    default public <T> String saveParamToStr(T saveParam) {
        if (ObjectUtil.isNull(saveParam)) {
            return null;
        }
        return BeanUtils.toJsonOptional(saveParam).orElse(String.valueOf(saveParam));
    }

    @Named(value="valueToFormColumn")
    default public List<FormColumnDefinition> valueToFormColumn(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        return BeanUtils.toList(value, FormColumnDefinition.class);
    }

    @Named(value="valueToJsonColumn")
    default public JsonColumnDefinition valueToJsonColumn(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        return BeanUtils.toBean(value, JsonColumnDefinition.class);
    }

    @Named(value="toObjectColumn")
    default public Object toObjectColumn(String mediaType, String bodyParam) {
        if (mediaType.equals(MediaType.MIME_NONE.getCode())) {
            return null;
        }
        if (List.of(MediaType.MIME_MULTIPART_FORM_DATA.getCode(), MediaType.MIME_FORM_URLENCODED.getCode()).contains(mediaType)) {
            return BeanUtils.toMapList(bodyParam);
        }
        if (mediaType.equals(MediaType.MIME_JSON_UTF8.getCode())) {
            return BeanUtils.toMap(bodyParam);
        }
        return bodyParam;
    }

    @Named(value="authAccountToStr")
    default public String authAccountToStr(ApiSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return saveParam.getAuthAccount();
    }

    @Named(value="inheritServerUrl")
    default public String inheritServerUrl(InfinityApiMergeVO apiMergeVO) {
        if (StrUtil.isNotBlank((CharSequence)apiMergeVO.getApiServerUrl())) {
            return apiMergeVO.getApiServerUrl();
        }
        if (StrUtil.isNotBlank((CharSequence)apiMergeVO.getFolderServerUrl())) {
            return apiMergeVO.getFolderServerUrl();
        }
        return apiMergeVO.getPlatformServerUrl();
    }

    @Named(value="inheritAuthMethod")
    default public String inheritAuthMethod(InfinityApiMergeVO apiMergeVO) {
        if (!apiMergeVO.getApiAuthMethod().equals(AuthMethod.AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getApiAuthMethod();
        }
        if (StrUtil.isNotBlank((CharSequence)apiMergeVO.getFolderAuthMethod()) && !apiMergeVO.getFolderAuthMethod().equals(AuthMethod.AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getFolderAuthMethod();
        }
        return apiMergeVO.getPlatformAuthMethod();
    }

    @Named(value="inheritAuthAccount")
    default public String inheritAuthAccount(InfinityApiMergeVO apiMergeVO) {
        if (!apiMergeVO.getApiAuthMethod().equals(AuthMethod.AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getApiAuthAccount();
        }
        if (StrUtil.isNotBlank((CharSequence)apiMergeVO.getFolderAuthMethod()) && !apiMergeVO.getFolderAuthMethod().equals(AuthMethod.AUTH_METHOD_INHERIT.getCode())) {
            return apiMergeVO.getFolderAuthAccount();
        }
        return apiMergeVO.getPlatformAuthAccount();
    }
}

