/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.model.entity.InfinityFolderDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FolderSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.util.BeanUtils;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(config=BaseMapperConfig.class)
public interface InfinityFolderConvert {
    public static final InfinityFolderConvert INSTANCE = (InfinityFolderConvert)Mappers.getMapper(InfinityFolderConvert.class);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public InfinityFolderDO saveParamToDO(FolderSaveParamVO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public void saveParamMergeToDO(FolderSaveParamVO var1, @MappingTarget InfinityFolderDO var2);

    public List<InfinityApiRespVO> toApiFolder(List<InfinityFolderDO> var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="platformCode", ignore=true), @Mapping(target="remark", ignore=true), @Mapping(target="folderId", source="id"), @Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(folderRespVO))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(folderRespVO))")})
    public InfinityApiRespVO toApiFolder(InfinityFolderDO var1);

    @Named(value="authAccountToStr")
    default public String authAccountToStr(FolderSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return "";
    }

    @Named(value="toBasicAuthAccount")
    default public BasicAuthAccountVO toBasicAuthAccount(InfinityFolderDO folderRespVO) {
        if (StrUtil.isBlank((CharSequence)folderRespVO.getAuthAccount())) {
            return null;
        }
        if (folderRespVO.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(folderRespVO.getAuthAccount(), BasicAuthAccountVO.class);
        }
        return null;
    }

    @Named(value="toOAuthAccount")
    default public OAuth2AccountVO toOAuthAccount(InfinityFolderDO folderRespVO) {
        if (StrUtil.isBlank((CharSequence)folderRespVO.getAuthAccount())) {
            return null;
        }
        if (folderRespVO.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(folderRespVO.getAuthAccount(), OAuth2AccountVO.class);
        }
        return null;
    }
}

