/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.model.entity.InfinityPlatformDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiPagingVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiSaveParamVO;
import com.elitescloud.cloudt.system.util.BeanUtils;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(config=BaseMapperConfig.class)
public interface InfinityPlatformConvert {
    public static final InfinityPlatformConvert INSTANCE = (InfinityPlatformConvert)Mappers.getMapper(InfinityPlatformConvert.class);

    public List<ThirdApiPagingVO> toPageVO(List<InfinityPlatformDO> var1);

    @Mappings(value={@Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(platformDO))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(platformDO))")})
    public ThirdApiPagingVO toPageVO(InfinityPlatformDO var1);

    public List<ThirdApiRespVO> doToVO(List<InfinityPlatformDO> var1);

    @Mappings(value={@Mapping(target="basicAuthAccount", expression="java(toBasicAuthAccount(platformDO))"), @Mapping(target="oauth2Account", expression="java(toOAuthAccount(platformDO))")})
    public ThirdApiRespVO doToVO(InfinityPlatformDO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public InfinityPlatformDO saveParamToDO(ThirdApiSaveParamVO var1);

    @Mapping(target="authAccount", expression="java(authAccountToStr(saveParam))")
    public void saveParamMergeToDO(ThirdApiSaveParamVO var1, @MappingTarget InfinityPlatformDO var2);

    @Named(value="authAccountToStr")
    default public String authAccountToStr(ThirdApiSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return "";
    }

    @Named(value="toBasicAuthAccount")
    default public BasicAuthAccountVO toBasicAuthAccount(InfinityPlatformDO platformDO) {
        if (StrUtil.isBlank((CharSequence)platformDO.getAuthAccount())) {
            return null;
        }
        if (platformDO.getAuthMethod().equals(AuthMethod.AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(platformDO.getAuthAccount(), BasicAuthAccountVO.class);
        }
        return null;
    }

    @Named(value="toOAuthAccount")
    default public OAuth2AccountVO toOAuthAccount(InfinityPlatformDO platformDO) {
        if (StrUtil.isBlank((CharSequence)platformDO.getAuthAccount())) {
            return null;
        }
        if (platformDO.getAuthMethod().equals(AuthMethod.AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(platformDO.getAuthAccount(), OAuth2AccountVO.class);
        }
        return null;
    }
}

