/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OrderItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.util.List;

public class PageQueryParam
implements Serializable {
    private int current;
    private int size;
    private List<OrderItem> orders;

    public int getPageNumber() {
        return this.current > 0 ? this.current - 1 : 0;
    }

    @JsonIgnore
    public void setPaging(JPAQuery<?> query) {
        int curr = this.current > 0 ? this.current - 1 : 0;
        query.offset((long)curr * (long)this.getSize());
        query.limit((long)this.getSize());
    }

    @JsonIgnore
    public void fillOrders(JPAQuery<?> query, EntityPathBase<?> entityPathBase) {
        if (ArrayUtil.isEmpty(this.getOrders())) {
            return;
        }
        PathBuilder orderByExpr = new PathBuilder(entityPathBase.getClass(), entityPathBase.getMetadata(), PathBuilderValidator.FIELDS);
        for (OrderItem order : this.getOrders()) {
            OrderSpecifier orderSpecifier = new OrderSpecifier(order.isAsc() ? Order.ASC : Order.DESC, (Expression)orderByExpr.get(order.getColumn()));
            query.orderBy(orderSpecifier);
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public int getSize() {
        return this.size;
    }

    public List<OrderItem> getOrders() {
        return this.orders;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setOrders(List<OrderItem> orders) {
        this.orders = orders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageQueryParam)) {
            return false;
        }
        PageQueryParam other = (PageQueryParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        List<OrderItem> this$orders = this.getOrders();
        List<OrderItem> other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQueryParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getSize();
        List<OrderItem> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        return result;
    }

    public String toString() {
        return "PageQueryParam(current=" + this.getCurrent() + ", size=" + this.getSize() + ", orders=" + String.valueOf(this.getOrders()) + ")";
    }
}

