/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.dpr.strategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.boot.spi.support.ProviderInstanceHolder;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.modules.dpr.strategy.impl.DprSysInternallyDynamic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.beetl.core.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DprValueResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(DprValueResolverFactory.class);
    private static volatile boolean initialized = false;
    private static final Map<String, DprValueResolverSPI> valueResolverSpiMap = new HashMap<String, DprValueResolverSPI>(32);
    private static final Map<String, DprValueType> valueTypeMap = new HashMap<String, DprValueType>(32);

    public static List<CodeNameParam> getValueTypes() {
        if (!initialized) {
            DprValueResolverFactory.init();
        }
        return valueTypeMap.values().stream().sorted(Comparator.comparing(DprValueType::sortNo)).map(t -> new CodeNameParam(t.code(), t.showName())).collect(Collectors.toList());
    }

    public static DprValueType parseValueType(String code) {
        if (!initialized) {
            DprValueResolverFactory.init();
        }
        return code == null ? null : valueTypeMap.get(code);
    }

    public static String convertDprValueTypeName(String code) {
        DprValueType valueType;
        if (!initialized) {
            DprValueResolverFactory.init();
        }
        return (valueType = DprValueResolverFactory.parseValueType(code)) == null ? null : valueType.showName();
    }

    public static DprValueResolverSPI.DprRuleValue resolveDprValue(@NotNull SysDprRoleApiDataRuleListQueryDTO rule, @NotNull GeneralUserDetails userDetails) {
        DprValueResolverSPI resolverSPI;
        if (!initialized) {
            DprValueResolverFactory.init();
        }
        Assert.notNull((Object)rule, (String)"\u6570\u636e\u6743\u9650\u89c4\u5219\u4e3a\u7a7a");
        Assert.notNull((Object)userDetails, (String)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        String ruleValueType = CharSequenceUtil.blankToDefault((CharSequence)rule.getDprRuleValue(), (String)rule.getDprSysInternally());
        logger.info("\u5f00\u59cb\u89e3\u6790\u6570\u636e\u6743\u9650\u89c4\u5219\uff1a{}, {}", (Object)rule.getDprRuleId(), (Object)ruleValueType);
        Assert.hasText((String)ruleValueType, (String)"\u672a\u77e5\u89c4\u5219\u503c\u7c7b\u578b");
        if (ruleValueType.startsWith(DprSysInternallyDynamic.PREFIX)) {
            ruleValueType = SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC.code();
        }
        if ((resolverSPI = valueResolverSpiMap.get(ruleValueType)) == null) {
            logger.error("\u672a\u53d1\u73b0\u89c4\u5219\u503c{}\u7684\u89e3\u6790\u5668", (Object)ruleValueType);
            return null;
        }
        DprValueType valueType = valueTypeMap.get(ruleValueType);
        DprValueResolverSPI.DprRuleValue value = resolverSPI.resolve(valueType, userDetails, rule);
        Assert.notNull((Object)value, (String)"\u6570\u636e\u6743\u9650\u89c4\u5219\u89e3\u6790\u7684\u503c\u4e3a\u7a7a");
        value.setValueType(valueType);
        logger.info("\u89e3\u6790\u5f97\u7ed3\u679c\uff1a{}", value.getValue());
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (initialized) {
            return;
        }
        Class<DprValueResolverFactory> clazz = DprValueResolverFactory.class;
        synchronized (DprValueResolverFactory.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            List spiList = ProviderInstanceHolder.loadProviderInstances(DprValueResolverSPI.class, (Boolean)false);
            if (!spiList.isEmpty()) {
                for (DprValueResolverSPI dprValueResolverSPI : spiList) {
                    Object[] valueTypes = dprValueResolverSPI.valueTypes();
                    if (ArrayUtils.isEmpty((Object[])valueTypes)) {
                        logger.error("{}\u672a\u914d\u7f6e\u503c\u7c7b\u578b\uff0c\u5ffd\u7565", (Object)dprValueResolverSPI.getClass().getName());
                        continue;
                    }
                    for (Object valueType : valueTypes) {
                        Assert.hasText((String)valueType.code(), () -> DprValueResolverFactory.lambda$init$1((DprValueType)valueType));
                        if (valueResolverSpiMap.containsKey(valueType.code())) {
                            logger.error("{}\u5b58\u5728\u91cd\u590d\uff0c\u5ffd\u7565", (Object)valueType.code());
                            continue;
                        }
                        valueResolverSpiMap.put(valueType.code(), dprValueResolverSPI);
                        valueTypeMap.put(valueType.code(), (DprValueType)valueType);
                    }
                }
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static /* synthetic */ String lambda$init$1(DprValueType valueType) {
        return valueType.getClass().getName() + "\u5b58\u5728\u503c\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a";
    }
}

