/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.rpc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.provider.TenantOrgDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateTxtReplaceDTO;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateConfigRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateRepository;
import com.elitescloud.cloudt.system.modules.message.rpc.manager.SysMsgTemplateSendRpcServiceServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgSendRecordService;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgTemplateService;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonService;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import com.elitescloud.cloudt.system.service.SysMsgTemplateSendRpcService;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/msg/template/send"}, produces={"application/json"})
@TenantOrgTransaction(useTenantOrg=false)
public class SysMsgTemplateSendRpcServiceImpl
extends SysMsgTemplateSendRpcServiceServiceAbstract
implements SysMsgTemplateSendRpcService {
    private static final Logger log = LoggerFactory.getLogger(SysMsgTemplateSendRpcServiceImpl.class);
    private final SysMsgTemplateRepository sysMsgTemplateRepository;
    private final SysMsgTemplateConfigRepository sysMsgTemplateConfigRepository;
    private final SysMsgSendCommonService sysMsgSendCommonService;
    private final SysMsgTemplateService msgTemplateService;
    private final TaskExecutor taskExecutor;
    private final TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider;
    private final SysMsgSendRecordService msgRecordService;

    public ApiResult<String> msgTemplateEmployeeSend(TemplateEmployeeSendParamDTO param) {
        String uuidBatch = UUID.randomUUID().toString();
        this.compatibleTemplateParams(param);
        MsgSendEmployeeUserDTO sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        this.sysMsgSendCommonService.checkSendUser(sendUser);
        List<EmployeePagedRespBean> recipientUserEmployeeList = this.obtainReceivers(param);
        List carbonUserList = param.getCarbonUserList();
        ArrayList<EmployeePagedRespBean> carbonUserEmployeeList = new ArrayList();
        if (carbonUserList != null && !carbonUserList.isEmpty()) {
            carbonUserEmployeeList = this.sysMsgSendCommonService.getCheckEmployeePagedRespBeans(carbonUserList);
        }
        SendTempLateMsgBO sendBo = new SendTempLateMsgBO(param.getContentReplaceMap(), param.getTitleReplaceMap(), param.getMesJoinParamMap(), uuidBatch, sendUser, recipientUserEmployeeList, carbonUserEmployeeList, param.getFileCodes(), param.getTemplateCode());
        sendBo.setReceiptUserId(param.getReceiptUserId());
        this.sendTemplateRpcMsg(sendBo);
        return ApiResult.ok((Object)uuidBatch);
    }

    public ApiResult<List<SysSendResultParam>> msgTemplateEmployeeSend(List<TemplateEmployeeSendParamDTO> paramList) {
        ArrayList<SysSendResultParam> resultParamList = new ArrayList<SysSendResultParam>(paramList.size());
        for (TemplateEmployeeSendParamDTO paramDTO : paramList) {
            try {
                ApiResult<String> sendResult = this.msgTemplateEmployeeSend(paramDTO);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(sendResult.isSuccess()), sendResult.getMsg(), (String)sendResult.getData()));
            }
            catch (Throwable e) {
                log.error("\u53d1\u9001\u5931\u8d25\uff1a", e);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(false), e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    public ApiResult<String> msgTemplateMsgTypeParamSend(TemplateAssignSendParamDTO param) {
        String uuidBatch = UUID.randomUUID().toString();
        this.compatibleTemplateParams(param);
        MsgSendEmployeeUserDTO sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        this.sysMsgSendCommonService.checkSendUser(sendUser);
        List<EmployeePagedRespBean> recipientEmployeeList = param.getRecipientUserList().stream().map(templateAssignRecipientUserDTO -> {
            Map map = templateAssignRecipientUserDTO.getRecipientUserAccountDtoMap();
            return this.sysMsgSendCommonService.setEmployeeBeanByAssignRecipientUserDTO(map, (TemplateAssignRecipientUserDTO)templateAssignRecipientUserDTO);
        }).filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        List carbonUserList = param.getContactUserList();
        List<EmployeePagedRespBean> carbonUserEmployeeList = null;
        if (carbonUserList != null && !carbonUserList.isEmpty()) {
            carbonUserEmployeeList = carbonUserList.stream().map(templateAssignRecipientUserDTO -> {
                Map map = templateAssignRecipientUserDTO.getRecipientUserAccountDtoMap();
                return this.sysMsgSendCommonService.setEmployeeBeanByAssignRecipientUserDTO(map, (TemplateAssignRecipientUserDTO)templateAssignRecipientUserDTO);
            }).filter(ObjectUtil::isNotNull).collect(Collectors.toList());
        }
        String templateCode = param.getTemplateCode();
        this.sysMsgSendCommonService.checkTemplateCode(templateCode);
        SendTempLateMsgBO sendBo = new SendTempLateMsgBO(param.getContentReplaceMap(), param.getTitleReplaceMap(), param.getMesJoinParamMap(), uuidBatch, sendUser, recipientEmployeeList, carbonUserEmployeeList, param.getFileCodes(), templateCode);
        sendBo.setReceiptAccount(param.getReceiptAccount());
        this.sendTemplateRpcMsg(sendBo);
        return ApiResult.ok((Object)uuidBatch);
    }

    public ApiResult<List<SysSendResultParam>> msgTemplateMsgTypeParamSend(List<TemplateAssignSendParamDTO> paramList) {
        ArrayList<SysSendResultParam> resultParamList = new ArrayList<SysSendResultParam>(paramList.size());
        for (TemplateAssignSendParamDTO paramDTO : paramList) {
            try {
                ApiResult<String> sendResult = this.msgTemplateMsgTypeParamSend(paramDTO);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(sendResult.isSuccess()), sendResult.getMsg(), (String)sendResult.getData()));
            }
            catch (Throwable e) {
                log.error("\u53d1\u9001\u5931\u8d25\uff1a", e);
                resultParamList.add(new SysSendResultParam(Boolean.valueOf(false), e.getMessage(), null));
            }
        }
        return ApiResult.ok(resultParamList);
    }

    public ApiResult<String> msgTemplateSend(TemplateEmployeeSendParamDTO param) {
        String uuidBatch = UUID.randomUUID().toString();
        this.compatibleTemplateParams(param);
        MsgSendEmployeeUserDTO sendUser = SysMsgSendCommonServiceAbstract.autoGetSender(param.getSendUser());
        param.setSendUser(sendUser);
        this.sysMsgSendCommonService.checkSendUser(sendUser);
        List recipientUserList = param.getRecipientUserList();
        ArrayList<EmployeePagedRespBean> recipientEmployeeList = recipientUserList == null ? new ArrayList<EmployeePagedRespBean>() : recipientUserList.stream().map(msgRecipientUserDTO -> {
            EmployeePagedRespBean employeePagedRespBean = new EmployeePagedRespBean();
            employeePagedRespBean.setUsername(msgRecipientUserDTO.getUserName());
            employeePagedRespBean.setUserId(msgRecipientUserDTO.getUserId());
            employeePagedRespBean.setLastName(msgRecipientUserDTO.getUserStandby());
            return employeePagedRespBean;
        }).collect(Collectors.toList());
        List carbonUserList = param.getCarbonUserList();
        ArrayList<EmployeePagedRespBean> carbonUserEmployeeList = carbonUserList == null ? new ArrayList<EmployeePagedRespBean>() : recipientUserList.stream().map(msgRecipientUserDTO -> {
            EmployeePagedRespBean employeePagedRespBean = new EmployeePagedRespBean();
            employeePagedRespBean.setUsername(msgRecipientUserDTO.getUserName());
            return employeePagedRespBean;
        }).collect(Collectors.toList());
        SendTempLateMsgBO sendBo = new SendTempLateMsgBO(param.getContentReplaceMap(), param.getTitleReplaceMap(), param.getMesJoinParamMap(), uuidBatch, sendUser, recipientEmployeeList, carbonUserEmployeeList, param.getFileCodes(), param.getTemplateCode());
        sendBo.setReceiptUserId(param.getReceiptUserId());
        this.sendTemplateRpcMsg(sendBo);
        return ApiResult.ok((Object)uuidBatch);
    }

    public ApiResult<SysMsgSentResultDTO> getSentResult(String recordId) {
        return this.msgRecordService.querySentResult(recordId);
    }

    public ApiResult<List<SysMsgSentResultDTO>> listSentResult(Set<String> recordIds) {
        return this.msgRecordService.querySentResults(recordIds);
    }

    public ApiResult<String> retrySend(String recordId) {
        return this.msgRecordService.retrySend(recordId);
    }

    private void compatibleTemplateParams(TemplateEmployeeSendParamDTO sendParamDTO) {
        Optional<Map> replaceParams;
        if (CollUtil.isEmpty((Map)sendParamDTO.getTitleReplaceMap()) && CollUtil.isNotEmpty((Collection)sendParamDTO.getMsgTemplateTitleReplaceDTOS())) {
            replaceParams = sendParamDTO.getMsgTemplateTitleReplaceDTOS().stream().filter(t -> CollUtil.isNotEmpty((Map)t.getReplaceMap())).findFirst().map(TemplateTxtReplaceDTO::getReplaceMap);
            sendParamDTO.setTitleReplaceMap(replaceParams.orElse(Collections.emptyMap()));
        }
        if (CollUtil.isEmpty((Map)sendParamDTO.getContentReplaceMap()) && CollUtil.isNotEmpty((Collection)sendParamDTO.getMsgTemplateContentReplaceDTOS())) {
            replaceParams = sendParamDTO.getMsgTemplateContentReplaceDTOS().stream().filter(t -> CollUtil.isNotEmpty((Map)t.getReplaceMap())).findFirst().map(TemplateTxtReplaceDTO::getReplaceMap);
            sendParamDTO.setContentReplaceMap(replaceParams.orElse(Collections.emptyMap()));
        }
    }

    private void compatibleTemplateParams(TemplateAssignSendParamDTO sendParamDTO) {
        Optional<Map> replaceParams;
        if (CollUtil.isEmpty((Map)sendParamDTO.getTitleReplaceMap()) && CollUtil.isNotEmpty((Collection)sendParamDTO.getMsgTemplateTitleReplaceDTOS())) {
            replaceParams = sendParamDTO.getMsgTemplateTitleReplaceDTOS().stream().filter(t -> CollUtil.isNotEmpty((Map)t.getReplaceMap())).findFirst().map(TemplateTxtReplaceDTO::getReplaceMap);
            sendParamDTO.setTitleReplaceMap(replaceParams.orElse(Collections.emptyMap()));
        }
        if (CollUtil.isEmpty((Map)sendParamDTO.getContentReplaceMap()) && CollUtil.isNotEmpty((Collection)sendParamDTO.getMsgTemplateContentReplaceDTOS())) {
            replaceParams = sendParamDTO.getMsgTemplateContentReplaceDTOS().stream().filter(t -> CollUtil.isNotEmpty((Map)t.getReplaceMap())).findFirst().map(TemplateTxtReplaceDTO::getReplaceMap);
            sendParamDTO.setContentReplaceMap(replaceParams.orElse(Collections.emptyMap()));
        }
    }

    private void sendTemplateRpcMsg(SendTempLateMsgBO sendBo) {
        this.sysMsgSendCommonService.checkTemplateCode(sendBo.getTemplateCode());
        SysMsgTemplateDO templateDo = (SysMsgTemplateDO)((Object)this.tenantOrgDataIsolateProvider.byNoTenantOrg(() -> this.sysMsgTemplateRepository.findByTemplateCode(sendBo.getTemplateCode())));
        Assert.notNull((Object)((Object)templateDo), (String)("\u6d88\u606f\u670d\u52a1\uff0c\u6d88\u606f\u6a21\u677f\u6ca1\u6709\u627e\u5230\uff1a" + sendBo.getTemplateCode()));
        sendBo.setTemplateDo(templateDo);
        List<SysMsgTemplateConfigDO> sysMsgTemplateConfigDTOList = this.sysMsgTemplateConfigRepository.findAllByTemplateIdAndSendTypeSwitch(sendBo.getTemplateDo().getId(), true);
        Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> groupedSendMap = this.sysMsgSendCommonService.sysMsgTemplateConfigDoToVoGroupBySendTypeCode(sysMsgTemplateConfigDTOList);
        sendBo.setGroupedSendMap(groupedSendMap);
        Map<MsgSendTypeEnum, List<EmployeePagedRespBean>> defaultReceiverMap = this.queryDefaultReceivers(sendBo.getTemplateCode());
        sendBo.setDefaultReceiverMap(defaultReceiverMap);
        Map<MsgSendTypeEnum, List<MessageAccountVO>> sendPathMap = this.sysMsgSendCommonService.saveSendRecordToMsgSendTypeEnumListMap(sendBo, MsgTypeEnum.TEMPLATE, true);
        CompletableFuture.runAsync(() -> groupedSendMap.forEach((sendTypeEnum, msgTemplateTxtReplaceDTOS) -> this.sysMsgSendCommonService.sendBatchMsg(sendBo.getUuidBatch(), (List)sendPathMap.get(sendTypeEnum), (MsgSendTypeEnum)sendTypeEnum, (SysMsgTemplateConfigVO)msgTemplateTxtReplaceDTOS, sendBo.getContentReplaceMap(), sendBo.getCarbonUserEmployeeList(), sendBo.getFileCodes(), sendBo.getReceiptAccount())), (Executor)this.taskExecutor).whenComplete((v, e) -> {
            if (e != null) {
                log.error("\u66f4\u65b0\u6d88\u606f\u72b6\u6001\u5f02\u5e38\uff1a", e);
            }
        });
    }

    private List<EmployeePagedRespBean> obtainReceivers(TemplateEmployeeSendParamDTO param) {
        if (CollUtil.isEmpty((Collection)param.getRecipientUserList())) {
            return Collections.emptyList();
        }
        Set<Long> userIds = param.getRecipientUserList().stream().map(MsgRecipientUserDTO::getUserId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.sysMsgSendCommonService.getCheckEmployeePagedRespBeans(userIds);
    }

    private Map<MsgSendTypeEnum, List<EmployeePagedRespBean>> queryDefaultReceivers(String templateCode) {
        Map defaultReceiverMap = (Map)this.msgTemplateService.queryDefaultReceivers(templateCode).computeData();
        if (defaultReceiverMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Long> userIds = defaultReceiverMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, EmployeePagedRespBean> employeeMap = this.sysMsgSendCommonService.getCheckEmployeePagedRespBeans(userIds).stream().collect(Collectors.toMap(SysEmployeeDO::getUserId, t -> t, (t1, t2) -> t1));
        HashMap<MsgSendTypeEnum, List<EmployeePagedRespBean>> result = new HashMap<MsgSendTypeEnum, List<EmployeePagedRespBean>>(defaultReceiverMap.size());
        for (Map.Entry entry : defaultReceiverMap.entrySet()) {
            List employeeList = ((Set)entry.getValue()).stream().map(employeeMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            result.put((MsgSendTypeEnum)entry.getKey(), employeeList);
        }
        return result;
    }

    public SysMsgTemplateSendRpcServiceImpl(SysMsgTemplateRepository sysMsgTemplateRepository, SysMsgTemplateConfigRepository sysMsgTemplateConfigRepository, SysMsgSendCommonService sysMsgSendCommonService, SysMsgTemplateService msgTemplateService, TaskExecutor taskExecutor, TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider, SysMsgSendRecordService msgRecordService) {
        this.sysMsgTemplateRepository = sysMsgTemplateRepository;
        this.sysMsgTemplateConfigRepository = sysMsgTemplateConfigRepository;
        this.sysMsgSendCommonService = sysMsgSendCommonService;
        this.msgTemplateService = msgTemplateService;
        this.taskExecutor = taskExecutor;
        this.tenantOrgDataIsolateProvider = tenantOrgDataIsolateProvider;
        this.msgRecordService = msgRecordService;
    }
}

